/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3QueryFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityFromRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1KeystoreClient;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1QueryFromRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.LookupResults;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.QueryResults;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.ShardQueryResult;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.datastore.v1.QueryResultBatch;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class NewFirestoreV1ResponseFromRepConverter {
    private static final Function<OnestoreEntity.IndexPostfix, OnestoreEntity.IndexPostfix> INDEX_POSTFIX_PROTO_1_TO_2_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.IndexPostfix.parser());
    private final FirestoreV1EntityFromRepConverter entityFromRepConverter;
    private final FirestoreV1ResourceRefFromRepConverter resourceRefFromRepConverter;
    private final FirestoreV1KeystoreClient firestoreV1KeystoreClient;

    public NewFirestoreV1ResponseFromRepConverter(FirestoreV1EntityFromRepConverter entityFromRepConverter, FirestoreV1ResourceRefFromRepConverter resourceRefFromRepConverter, FirestoreV1KeystoreClient firestoreV1KeystoreClient) {
        this.entityFromRepConverter = Preconditions.checkNotNull(entityFromRepConverter);
        this.resourceRefFromRepConverter = Preconditions.checkNotNull(resourceRefFromRepConverter);
        this.firestoreV1KeystoreClient = Preconditions.checkNotNull(firestoreV1KeystoreClient);
    }

    public BatchGetDocumentsResponse toBatchGetDocumentsResponse(ReadResult readResult, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        if (readResult.exists()) {
            return BatchGetDocumentsResponse.newBuilder().setFound(this.entityFromRepConverter.convertReadResultToDocument(readResult, configOverrides)).setReadTime(ConverterHelper.microsecondsToTimestamp(readResult.readTimestamp())).build();
        }
        if (readResult.missingEntityReason() == ReadResult.MissingEntityReason.MISSING) {
            return BatchGetDocumentsResponse.newBuilder().setMissing(FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertEntityRefServiceRelative(AppEngV3ResourceRefToRepConverter.convertValidEntityRef(readResult.reference(), configOverrides))).setReadTime(ConverterHelper.microsecondsToTimestamp(readResult.readTimestamp())).build();
        }
        throw DatastoreExceptionHelper.internalError("unexpected read result", null);
    }

    public CommitResponse toCommitResponse(WriteResult writeResult) throws InvalidConversionException {
        CommitResponse.Builder builder = CommitResponse.newBuilder();
        if (writeResult.commitTimestamp() != 0L) {
            builder.setCommitTime(ConverterHelper.microsecondsToTimestamp(writeResult.commitTimestamp()));
        }
        ImmutableMap<Integer, Integer> originalTransformations = writeResult.originalTransformations();
        ImmutableList<MutationResult> mutationResults = writeResult.mutationResults();
        HashMap<OnestoreEntity.Reference, Integer> transformStartIndexByKey = new HashMap<OnestoreEntity.Reference, Integer>();
        for (int i = 0; i < mutationResults.size(); ++i) {
            MutationResult mutationResult = (MutationResult)mutationResults.get(i);
            WriteResult.Builder result = builder.addWriteResultsBuilder();
            if (mutationResult.isDelete()) continue;
            this.addTransformResult(originalTransformations, transformStartIndexByKey, i, mutationResult, result);
        }
        return builder.build();
    }

    public RunQueryResponse toNonDocumentRunQueryResponse(QueryResults results) throws InvalidConversionException {
        return RunQueryResponse.newBuilder().setSkippedResults(results.skippedResults()).setReadTime(ConverterHelper.microsecondsToTimestamp(results.query().snapshotVersion())).build();
    }

    public Collection<RunQueryResponse> toRunQueryResponse(QueryResults results, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        ArrayList<RunQueryResponse> buffer = new ArrayList<RunQueryResponse>(results.readResults().size());
        if (results.skippedResults() > 0) {
            buffer.add(this.toNonDocumentRunQueryResponse(results));
        }
        if (!results.readResults().isEmpty()) {
            buffer.addAll(this.toDocumentRunQueryResponses(results, configOverrides));
        }
        return buffer;
    }

    public RunQueryResponse toRunQueryResponse(Timestamp readTimestamp, ReadResult readResult, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        return RunQueryResponse.newBuilder().setReadTime(readTimestamp).setDocument(this.entityFromRepConverter.convertReadResultToDocument(readResult, configOverrides)).build();
    }

    public Document toCreateResponse(WriteResult writeResult) throws DatastoreException {
        return this.toWrittenDocument((MutationResult)writeResult.mutationResults().get(0));
    }

    public Collection<RunQueryResponse> toDocumentRunQueryResponses(QueryResults queryResults, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Timestamp readTimestamp = ConverterHelper.microsecondsToTimestamp(queryResults.query().snapshotVersion());
        ArrayList<RunQueryResponse> responses = new ArrayList<RunQueryResponse>(queryResults.readResults().size());
        for (ReadResult readResult : queryResults.readResults()) {
            responses.add(this.toRunQueryResponse(readTimestamp, readResult, configOverrides));
        }
        return responses;
    }

    public Document toUpdateResponse(WriteResult writeResult) throws DatastoreException {
        return this.toWrittenDocument((MutationResult)writeResult.mutationResults().get(0));
    }

    public Optional<Document> toGetResponse(LookupResults response, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        List<ReadResult> results = response.results();
        return results.isEmpty() ? Optional.empty() : Optional.ofNullable(this.entityFromRepConverter.convertReadResultToDocument(results.get(0), configOverrides));
    }

    public Empty toDeleteResponse(WriteResult writeResult) {
        return Empty.getDefaultInstance();
    }

    public ListDocumentsResponse toListDocumentsResponse(long queryFingerprint, QueryResults results, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        ListDocumentsResponse.Builder builder = ListDocumentsResponse.newBuilder();
        for (ReadResult result : results.readResults()) {
            builder.addDocuments(this.entityFromRepConverter.convertReadResultToDocument(result, configOverrides));
        }
        if (results.moreResults().equals(QueryResultBatch.MoreResultsType.NOT_FINISHED) || results.moreResults().equals(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT)) {
            QueryResumeToken queryResumeToken = FirestoreV1QueryFromRepConverter.INSTANCE.convertQueryResumeState(queryFingerprint, results.resultSetCursor(), 0, -1);
            builder.setNextPageToken(this.convertQueryResumeTokenToString(queryResumeToken));
        }
        return builder.build();
    }

    public ListCollectionIdsResponse toListCollectionIdsResponse(QueryResults results, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        ListCollectionIdsResponse.Builder builder = ListCollectionIdsResponse.newBuilder();
        if (results.moreResults().equals(QueryResultBatch.MoreResultsType.NOT_FINISHED) || results.moreResults().equals(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT)) {
            QueryResumeToken queryResumeToken = this.toQueryResumeTokenForListCollectionIds(results.endCursor(), results.query().firstSortDirection());
            builder.setNextPageToken(this.convertQueryResumeTokenToString(queryResumeToken));
        }
        for (ReadResult readResult : results.readResults()) {
            EntityRef entityRef = AppEngV3ResourceRefToRepConverter.convertValidEntityRef(readResult.reference(), configOverrides);
            String collectionId = entityRef.resourceId().asString();
            builder.addCollectionIds(this.resourceRefFromRepConverter.convertEntityCollectionId(collectionId));
        }
        return builder.build();
    }

    public PartitionQueryResponse toPartitionQueryResponse(ShardQueryResult result, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        PartitionQueryResponse.Builder builder = PartitionQueryResponse.newBuilder();
        if (result.resumeCursor() != null) {
            QueryResumeToken queryResumeToken = FirestoreV1QueryFromRepConverter.INSTANCE.convertQueryResumeState(0L, result.resumeCursor(), 0, -1);
            builder.setResumeToken(this.convertQueryResumeTokenToString(queryResumeToken));
        }
        for (com.google.cloud.datastore.core.rep.Cursor cursor : result.cursors()) {
            builder.addPartitions(this.convertCursorForPartitionQuery(cursor));
        }
        return builder.build();
    }

    public BatchWriteResponse toBatchWriteResponse(WriteResult writeResult, Function<DatastoreException, Status> statusTranslator) throws InvalidConversionException {
        BatchWriteResponse.Builder builder = BatchWriteResponse.newBuilder();
        ImmutableMap<Integer, Integer> originalTransformations = writeResult.originalTransformations();
        HashMap<OnestoreEntity.Reference, Integer> transformStartIndexByKey = new HashMap<OnestoreEntity.Reference, Integer>();
        for (int i = 0; i < writeResult.mutationResults().size(); ++i) {
            MutationResult mutationResult = (MutationResult)writeResult.mutationResults().get(i);
            WriteResult.Builder result = builder.addWriteResultsBuilder();
            if (mutationResult.exception() != null) {
                builder.addStatus(statusTranslator.apply(mutationResult.exception()));
                continue;
            }
            builder.addStatus(Status.newBuilder().setCode(0));
            if (mutationResult.isDelete()) continue;
            this.addTransformResult(originalTransformations, transformStartIndexByKey, i, mutationResult, result);
        }
        return builder.build();
    }

    private void addTransformResult(ImmutableMap<Integer, Integer> originalTransformations, Map<OnestoreEntity.Reference, Integer> transformStartIndexByKey, int i, MutationResult mutationResult, WriteResult.Builder result) throws InvalidConversionException {
        result.setUpdateTime(ConverterHelper.microsecondsToTimestamp(mutationResult.updateVersion()));
        if (mutationResult.transformedValues() != null && originalTransformations.containsKey(i)) {
            int startIndex = transformStartIndexByKey.getOrDefault(mutationResult.key(), 0);
            int endIndex = startIndex + originalTransformations.get(i);
            transformStartIndexByKey.put(mutationResult.key(), endIndex);
            for (Value value : mutationResult.transformedValues().subList(startIndex, endIndex)) {
                result.addTransformResults(this.entityFromRepConverter.convertValue(value));
            }
        }
    }

    private String convertQueryResumeTokenToString(QueryResumeToken queryResumeToken) throws DatastoreException {
        return BaseEncoding.base64Url().omitPadding().encode(this.firestoreV1KeystoreClient.encrypt(queryResumeToken));
    }

    private QueryResumeToken toQueryResumeTokenForListCollectionIds(com.google.cloud.datastore.core.rep.Cursor cursor, @Nullable Direction direction) throws DatastoreException {
        DatastoreV3Pb.CompiledCursor v3EndCursor = AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(cursor, direction);
        Preconditions.checkState(v3EndCursor.hasPostfixPosition());
        return QueryResumeToken.newBuilder().setDatastoreLegacyCursor(INDEX_POSTFIX_PROTO_1_TO_2_CONVERTER.apply(v3EndCursor.getPostfixPosition())).build();
    }

    private Document toWrittenDocument(MutationResult mutationResult) throws DatastoreException {
        return this.entityFromRepConverter.convertEntityToDocument(mutationResult.entity(), mutationResult.createVersion(), mutationResult.updateVersion());
    }

    private Cursor convertCursorForPartitionQuery(com.google.cloud.datastore.core.rep.Cursor cursor) throws DatastoreException {
        Cursor.Builder builder = Cursor.newBuilder();
        builder.setBefore(cursor.before());
        builder.addValues(this.entityFromRepConverter.convertValue(Value.createEntityRef(cursor.key())));
        return builder.build();
    }
}

