/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index;

import com.google.cloud.datastore.core.rep.IndexValue;

public class IndexValueTypeExtractor {
    public static String extractType(com.google.cloud.datastore.core.rep.proto.IndexValue property) {
        switch (property.getValueTypeCase()) {
            case NULL_VALUE: {
                return "NULL";
            }
            case BOOLEAN_VALUE: {
                return "Boolean";
            }
            case NAN_VALUE: 
            case NUMBER_VALUE: {
                return "Number";
            }
            case TIMESTAMP_VALUE: {
                return "Date/Time";
            }
            case STRING_VALUE: {
                return "String";
            }
            case BYTES_VALUE: {
                return "Blob";
            }
            case RESOURCE_NAME_VALUE: {
                return "Key";
            }
            case GEO_POINT_VALUE: {
                return "GeoPt";
            }
            case ARRAY_VALUE: {
                return "Array";
            }
            case MAP_VALUE: {
                return "EmbeddedEntity";
            }
            case VALUETYPE_NOT_SET: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }

    public static String extractType(IndexValue indexValue) {
        switch (indexValue.type()) {
            case NULL: {
                return "NULL";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: {
                return "Number";
            }
            case TIMESTAMP: {
                return "Date/Time";
            }
            case STRING: {
                return "String";
            }
            case BYTES: {
                return "Blob";
            }
            case ENTITY_REF: {
                return "Key";
            }
            case GEO_POINT: {
                return "GeoPt";
            }
            case ARRAY: {
                return "Array";
            }
            case MAP: {
                return "EmbeddedEntity";
            }
            case LEGACY_USER: 
            case ABSENT_TYPE: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }
}

