/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.Value;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CachingValueToFirestoreIndexValueConverter
extends ValueToFirestoreIndexValueConverter {
    private final Map<Value, IndexValue> cache = new HashMap<Value, IndexValue>();

    public CachingValueToFirestoreIndexValueConverter(int truncationThreshold) {
        super(truncationThreshold);
    }

    public CachingValueToFirestoreIndexValueConverter(int truncationThreshold, boolean correctIncompleteKeyTruncation) {
        super(truncationThreshold, correctIncompleteKeyTruncation);
    }

    @Override
    public IndexValue convertValueTruncateIfThresholdExceeded(Value value) {
        IndexValue indexValue = this.cache.get(value);
        if (indexValue != null) {
            return indexValue;
        }
        return new CachingConverter(this.truncationThreshold).convertTopLevelValue(value);
    }

    private class CachingConverter
    extends ValueToFirestoreIndexValueConverter.Converter {
        public CachingConverter(int truncationThreshold) {
            super(truncationThreshold, CachingValueToFirestoreIndexValueConverter.this.correctIncompleteKeyTruncation);
        }

        public IndexValue convertTopLevelValue(Value value) {
            IndexValue indexValue = this.convertValue(value);
            if (indexValue.isDeepTruncated()) {
                CachingValueToFirestoreIndexValueConverter.this.cache.put(value, indexValue);
            }
            return indexValue;
        }

        @Override
        public IndexValue convertValue(Value value) {
            IndexValue indexValue = super.convertValue(value);
            if (!indexValue.isDeepTruncated()) {
                IndexValue cachedValue = (IndexValue)CachingValueToFirestoreIndexValueConverter.this.cache.get(value);
                if (cachedValue != null) {
                    return cachedValue;
                }
                CachingValueToFirestoreIndexValueConverter.this.cache.put(value, indexValue);
            }
            return indexValue;
        }
    }
}

