/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.cloud.datastore.core.common.UnicodeComparator;
import com.google.cloud.datastore.core.number.NumberComparisonHelper;
import com.google.cloud.datastore.core.rep.BaseIndexValueComparator;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nullable;

public class FirestoreIndexValueComparator
extends BaseIndexValueComparator {
    public static final FirestoreIndexValueComparator INSTANCE = new FirestoreIndexValueComparator();

    private FirestoreIndexValueComparator() {
    }

    @Override
    public int compare(@Nullable IndexValue left, @Nullable IndexValue right) {
        if (left == null) {
            if (right == null) {
                return 0;
            }
            return 1;
        }
        if (right == null) {
            return -1;
        }
        IndexValue.Type leftType = left.type();
        int typeComparison = Integer.compare(leftType.firestoreOrderNum(), right.type().firestoreOrderNum());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int comparisonWithoutTruncated = 0;
        switch (leftType) {
            case ABSENT_TYPE: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return Boolean.compare(left.asBoolean(), right.asBoolean());
            }
            case NUMBER: {
                return FirestoreIndexValueComparator.compareNumber(left, right);
            }
            case TIMESTAMP: {
                return Timestamps.compare(left.asTimestamp(), right.asTimestamp());
            }
            case STRING: {
                comparisonWithoutTruncated = UnicodeComparator.INSTANCE.compare(left.asString(), right.asString());
                break;
            }
            case BYTES: {
                comparisonWithoutTruncated = BYTE_STRING_COMPARATOR.compare(left.asBytes(), right.asBytes());
                break;
            }
            case ENTITY_REF: {
                return this.compareEntityRefWithoutTruncated(left.asEntityRef(), right.asEntityRef());
            }
            case GEO_POINT: {
                return this.compareGeoPoint(left.asGeoPoint(), right.asGeoPoint());
            }
            case ARRAY: {
                comparisonWithoutTruncated = this.compareArrayWithoutTruncated(left.asArray(), right.asArray());
                break;
            }
            case MAP: {
                comparisonWithoutTruncated = this.compareMapWithoutTruncated(left.asMap(), right.asMap());
                break;
            }
            case LEGACY_USER: {
                throw new IllegalArgumentException();
            }
        }
        if (comparisonWithoutTruncated != 0) {
            return comparisonWithoutTruncated;
        }
        return Boolean.compare(left.isShallowTruncated(), right.isShallowTruncated());
    }

    private static int compareNumber(IndexValue left, IndexValue right) {
        boolean rightIsDouble;
        boolean leftIsDouble = left.isNumberDouble();
        if (leftIsDouble == (rightIsDouble = right.isNumberDouble())) {
            if (leftIsDouble) {
                return NumberComparisonHelper.firestoreCompareDoubles(left.asNumberDouble(), right.asNumberDouble());
            }
            return Long.compare(left.asNumberLong(), right.asNumberLong());
        }
        if (leftIsDouble) {
            return NumberComparisonHelper.firestoreCompareDoubleWithLong(left.asNumberDouble(), right.asNumberLong());
        }
        return -NumberComparisonHelper.firestoreCompareDoubleWithLong(right.asNumberDouble(), left.asNumberLong());
    }
}

