/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class FirestoreIndexValueToValueConverter {
    public static final FirestoreIndexValueToValueConverter INSTANCE = new FirestoreIndexValueToValueConverter();

    private FirestoreIndexValueToValueConverter() {
    }

    public EntityRef convertEntityRef(String partitionId, IndexValue.EntityRef entityRefIV) {
        Preconditions.checkNotNull(partitionId);
        Preconditions.checkArgument(!entityRefIV.namespaceId.isShallowTruncated());
        Preconditions.checkArgument(!entityRefIV.segments.isShallowTruncated());
        PartitionRef partitionRef = PartitionRef.createFromDatabaseRefAndNamespace(entityRefIV.databaseRef, entityRefIV.namespaceId.asString());
        ImmutableList<IndexValue> segmentsArray = entityRefIV.segments.asArray();
        int numSegments = segmentsArray.size();
        Preconditions.checkArgument(numSegments == 0 || !((IndexValue)segmentsArray.get(numSegments - 1)).isShallowTruncated());
        ImmutableList.Builder entityRefPathBuilder = ImmutableList.builder();
        for (int kindIndex = 0; kindIndex < numSegments; kindIndex += 2) {
            EntityRef.ResourceId resourceId;
            IndexValue collectionIdSegment = (IndexValue)segmentsArray.get(kindIndex);
            IndexValue resourceIdSegment = (IndexValue)segmentsArray.get(kindIndex + 1);
            String collectionId = collectionIdSegment.asString();
            switch (resourceIdSegment.type()) {
                case NUMBER: {
                    long resourceIdLong = resourceIdSegment.asNumberLong();
                    resourceId = EntityRef.ResourceId.createLong(resourceIdLong);
                    break;
                }
                case STRING: {
                    String resourceIdString = resourceIdSegment.asString();
                    resourceId = EntityRef.ResourceId.createString(resourceIdString);
                    break;
                }
                default: {
                    resourceId = null;
                }
            }
            EntityRef.PathElement entityRefPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            entityRefPathBuilder.add(entityRefPathElement);
        }
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)((Object)entityRefPathBuilder.build()));
    }
}

