/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.cloud.datastore.core.index.common.IndexedEntityView;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FirestoreIndexedEntityView
implements IndexedEntityView {
    private static final Map.Entry<String, Value> ARRAY_CONTAINS_ENTRY = Maps.immutableEntry(null, null);
    private final Entity entity;
    private final Map<PropertyPath, Value> pathToShallowConvertedValueCache = new HashMap<PropertyPath, Value>();
    private final Map<PropertyPath, ImmutableSet<IndexValueAndRemainder>> pathToIndexValue = new HashMap<PropertyPath, ImmutableSet<IndexValueAndRemainder>>();
    private IndexValueAndRemainder parent;
    private ImmutableSet<IndexValueAndRemainder> ancestors;
    private final ValueToLegacyMapValueConverter legacyValueConverter;
    private final ValueToFirestoreIndexValueConverter indexValueConverter;
    private final ImmutableList<Map.Entry<String, Value>> specialProperties;

    public FirestoreIndexedEntityView(Entity entity, ValueToLegacyMapValueConverter legacyValueConverter, ValueToFirestoreIndexValueConverter indexValueConverter) {
        this.entity = entity;
        this.legacyValueConverter = Preconditions.checkNotNull(legacyValueConverter);
        this.indexValueConverter = Preconditions.checkNotNull(indexValueConverter);
        Value keyValue = Value.createEntityRef(entity.ref());
        this.pathToShallowConvertedValueCache.put(PropertyPath.KEY, keyValue);
        this.pathToIndexValue.put(PropertyPath.KEY, ImmutableSet.of(IndexValueAndRemainder.createForFirestore(indexValueConverter.convertEntityRefIgnoreThreshold(entity.ref()))));
        this.specialProperties = ImmutableList.of(Maps.immutableEntry(ReservedName.KEY.asString(), keyValue));
    }

    @Override
    public EntityRef ref() {
        return this.entity.ref();
    }

    @Override
    public boolean exists(PropertyPath propertyPath) {
        boolean isArrayElements = propertyPath.isArrayElements();
        PropertyPath lookupPath = isArrayElements ? propertyPath.dropLastPathSegment() : propertyPath;
        Value value = this.lookupFromCache(lookupPath);
        return value != null && (!isArrayElements || FirestoreIndexedEntityView.isNonEmptyArray(value));
    }

    @Override
    public ImmutableSet<IndexValueAndRemainder> indexValues(PropertyPath propertyPath) {
        return this.pathToIndexValue.computeIfAbsent(propertyPath, this::lookupAndCreateIndexValues);
    }

    @Override
    public IndexValueAndRemainder parent() {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = IndexValueAndRemainder.createForFirestore(this.indexValueConverter.convertEntityRefIgnoreThreshold(this.entity.ref().parent()));
        return this.parent;
    }

    @Override
    public ImmutableSet<IndexValueAndRemainder> ancestors() {
        if (this.ancestors != null) {
            return this.ancestors;
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        EntityRef ref = this.entity.ref();
        while (!ref.path().isEmpty()) {
            ref = ref.parent();
            result.add(IndexValueAndRemainder.createForFirestore(this.indexValueConverter.convertEntityRefIgnoreThreshold(ref)));
        }
        this.ancestors = result.build();
        return this.ancestors;
    }

    @Override
    public boolean hasNormallyIndexedProperty() {
        return !this.entity.propertyMap().isEmpty();
    }

    @Override
    public IndexedEntityView.PropertyPathIterator iterator() {
        return this.iterator(null);
    }

    public IndexedEntityView.PropertyPathIterator iterator(@Nullable PropertyPath rootPath) {
        if (rootPath == null) {
            return new PropertyPathIterator(null, this.entity.propertyMap(), this.specialProperties.iterator());
        }
        boolean isArrayElements = rootPath.isArrayElements();
        PropertyPath lookupPath = isArrayElements ? rootPath.dropLastPathSegment() : rootPath;
        Value value = this.lookupFromCache(lookupPath);
        if (value == null) {
            return IndexedEntityView.PropertyPathIterator.emptyIterator();
        }
        if (isArrayElements && FirestoreIndexedEntityView.isNonEmptyArray(value)) {
            return new PropertyPathIterator(rootPath, ImmutableMap.of(), Iterators.singletonIterator(ARRAY_CONTAINS_ENTRY));
        }
        if (isArrayElements) {
            return IndexedEntityView.PropertyPathIterator.emptyIterator();
        }
        String propertyName = ((PropertyPathSegment.Member)rootPath.lastSegment()).name().string();
        return new PropertyPathIterator(rootPath.dropLastPathSegment(), ImmutableMap.of(propertyName, value), null);
    }

    @Nullable
    private Value lookupFromCache(PropertyPath path) {
        Preconditions.checkArgument(!path.isArrayElements());
        return this.lookupFromCacheHelper(path, null);
    }

    @Nullable
    private Value lookupFromCacheHelper(PropertyPath current, PropertyPath tail) {
        if (current == null) {
            return this.lookupFromIntermediateValue(null, tail, this.entity.propertyMap());
        }
        Value cachedValue = this.pathToShallowConvertedValueCache.get(current);
        if (cachedValue == null) {
            return this.lookupFromCacheHelper(current.dropLastPathSegment(), PropertyPath.create(current.lastSegment(), tail));
        }
        if (tail == null) {
            return cachedValue;
        }
        if (Value.Type.MAP.equals((Object)cachedValue.type())) {
            return this.lookupFromIntermediateValue(current, tail, cachedValue.asMap());
        }
        return null;
    }

    @Nullable
    private Value lookupFromIntermediateValue(PropertyPath current, PropertyPath tail, ImmutableMap<String, Value> propertyMap) {
        String key = ((PropertyPathSegment.Member)tail.segment()).name().string();
        Value currentValue = propertyMap.get(key);
        if (currentValue == null) {
            return null;
        }
        current = PropertyPath.create(current, tail.segment());
        tail = tail.next();
        currentValue = this.legacyValueConverter.shallowConvertValue(currentValue);
        this.pathToShallowConvertedValueCache.put(current, currentValue);
        if (tail == null) {
            return currentValue;
        }
        if (!this.isNonEmptyMap(currentValue)) {
            return null;
        }
        return this.lookupFromIntermediateValue(current, tail, currentValue.asMap());
    }

    private ImmutableSet<IndexValueAndRemainder> lookupAndCreateIndexValues(PropertyPath propertyPath) {
        boolean isArrayElements = propertyPath.isArrayElements();
        PropertyPath lookupPath = isArrayElements ? propertyPath.dropLastPathSegment() : propertyPath;
        Value value = this.lookupFromCache(lookupPath);
        if (value == null || isArrayElements && !FirestoreIndexedEntityView.isNonEmptyArray(value)) {
            return ImmutableSet.of();
        }
        if (isArrayElements) {
            ImmutableSet.Builder elements = ImmutableSet.builder();
            for (Value element : value.asArray()) {
                elements.add(IndexValueAndRemainder.createForFirestore(this.indexValueConverter.convertValueTruncateIfThresholdExceeded(element)));
            }
            return elements.build();
        }
        return ImmutableSet.of(IndexValueAndRemainder.createForFirestore(this.indexValueConverter.convertValueTruncateIfThresholdExceeded(value)));
    }

    private boolean isNonEmptyMap(Value value) {
        return Value.Type.MAP.equals((Object)value.type()) && !value.asMap().isEmpty() || this.legacyValueConverter.isLegacyValue(value);
    }

    private static boolean isNonEmptyArray(Value value) {
        return Value.Type.ARRAY.equals((Object)value.type()) && !value.asArray().isEmpty();
    }

    private boolean isRecursiveValue(Value value) {
        return this.isNonEmptyMap(value) || FirestoreIndexedEntityView.isNonEmptyArray(value);
    }

    public class PropertyPathIterator
    extends IndexedEntityView.PropertyPathIterator {
        private LevelIterator currentLevel;
        private PropertyPath previousPath;
        private Value previousValue;

        private PropertyPathIterator(PropertyPath prefix, @Nullable ImmutableMap<String, Value> propertyMap, Iterator<Map.Entry<String, Value>> extraProperties) {
            Preconditions.checkArgument(extraProperties == null || extraProperties.hasNext());
            Iterator<Map.Entry<String, Value>> startIterator = null;
            if (!propertyMap.isEmpty() && extraProperties == null) {
                startIterator = ((ImmutableSet)propertyMap.entrySet()).iterator();
            } else if (!propertyMap.isEmpty() && extraProperties.hasNext()) {
                startIterator = Iterators.concat(extraProperties, ((ImmutableSet)propertyMap.entrySet()).iterator());
            } else if (extraProperties != null && extraProperties.hasNext()) {
                startIterator = extraProperties;
            }
            if (startIterator != null) {
                this.currentLevel = new LevelIterator(this, prefix, (Iterator)startIterator);
            }
        }

        @Override
        public boolean hasNext() {
            return this.previousValue != null || this.hasNextSkippingSubPaths();
        }

        @Override
        public PropertyPath next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previousValue != null) {
                this.recurseDownOneLevel(this.previousPath, this.previousValue);
            }
            return this.nextInternal();
        }

        @Override
        public boolean hasNextSkippingSubPaths() {
            return this.currentLevel != null;
        }

        @Override
        public PropertyPath nextSkippingSubPaths() {
            if (!this.hasNextSkippingSubPaths()) {
                this.previousPath = null;
                this.previousValue = null;
                throw new NoSuchElementException();
            }
            return this.nextInternal();
        }

        private PropertyPath nextInternal() {
            PropertyPath next;
            Object entry = this.currentLevel.next();
            if (entry == ARRAY_CONTAINS_ENTRY) {
                next = this.currentLevel.prefix();
                this.previousPath = null;
                this.previousValue = null;
            } else {
                next = PropertyPath.create(this.currentLevel.prefix(), PropertyPathSegment.Member.create(PropertyName.create((String)entry.getKey())));
                if (FirestoreIndexedEntityView.this.isRecursiveValue((Value)entry.getValue())) {
                    this.previousPath = next;
                    this.previousValue = (Value)entry.getValue();
                } else {
                    FirestoreIndexedEntityView.this.pathToShallowConvertedValueCache.put(next, (Value)entry.getValue());
                    this.previousPath = null;
                    this.previousValue = null;
                }
            }
            this.recurseUp();
            return next;
        }

        private void recurseUp() {
            while (!this.currentLevel.hasNext()) {
                this.currentLevel = this.currentLevel.parent;
                if (this.currentLevel != null) continue;
            }
        }

        private void recurseDownOneLevel(PropertyPath path, Value value) {
            if (Value.Type.ARRAY.equals((Object)value.type())) {
                PropertyPath allArrayElementsPath = PropertyPath.create(path, PropertyPathSegment.AllArrayElements.create());
                this.currentLevel = new LevelIterator(this, allArrayElementsPath, Iterators.singletonIterator(ARRAY_CONTAINS_ENTRY), this.currentLevel);
            } else {
                Value convertedLegacyValue = (Value)FirestoreIndexedEntityView.this.pathToShallowConvertedValueCache.get(path);
                if (convertedLegacyValue == null) {
                    convertedLegacyValue = FirestoreIndexedEntityView.this.legacyValueConverter.shallowConvertValue(value);
                    FirestoreIndexedEntityView.this.pathToShallowConvertedValueCache.put(path, value);
                }
                ImmutableMap<String, Value> map = convertedLegacyValue.asMap();
                this.currentLevel = new LevelIterator(this, path, ((ImmutableSet)map.entrySet()).iterator(), this.currentLevel);
            }
        }

        private class LevelIterator
        extends UnmodifiableIterator<Map.Entry<String, Value>> {
            @Nullable
            private final PropertyPath prefix;
            private final Iterator<Map.Entry<String, Value>> inner;
            @Nullable
            private final LevelIterator parent;

            private LevelIterator(@Nullable PropertyPathIterator propertyPathIterator, PropertyPath prefix, Iterator<Map.Entry<String, Value>> inner) {
                Preconditions.checkArgument(inner.hasNext());
                this.prefix = prefix;
                this.inner = inner;
                this.parent = null;
            }

            private LevelIterator(PropertyPathIterator propertyPathIterator, PropertyPath prefix, Iterator<Map.Entry<String, Value>> inner, LevelIterator parent) {
                Preconditions.checkArgument(inner.hasNext());
                this.prefix = prefix;
                this.inner = inner;
                this.parent = parent;
            }

            @Override
            public boolean hasNext() {
                return this.inner.hasNext();
            }

            @Nullable
            public PropertyPath prefix() {
                return this.prefix;
            }

            @Override
            public Map.Entry<String, Value> next() {
                return this.inner.next();
            }
        }
    }
}

