/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.common.UnicodeComparator;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ValueToFirestoreIndexValueConverter {
    public static final ValueToFirestoreIndexValueConverter DEFAULT = new ValueToFirestoreIndexValueConverter(Config.FirestoreV1Constants.getDefaultInstance().getIndexTruncationThresholdBytes(), false);
    protected final int truncationThreshold;
    protected final boolean correctIncompleteKeyTruncation;

    public ValueToFirestoreIndexValueConverter(int truncationThreshold) {
        this(truncationThreshold, false);
    }

    public ValueToFirestoreIndexValueConverter(int truncationThreshold, boolean correctIncompleteKeyTruncation) {
        this.truncationThreshold = truncationThreshold;
        this.correctIncompleteKeyTruncation = correctIncompleteKeyTruncation;
    }

    public IndexValue convertPropertyPathIgnoreThreshold(PropertyPath propertyPath) {
        return this.createConverter(Integer.MAX_VALUE).convertPropertyPath(propertyPath);
    }

    public IndexValue convertStringIgnoreThreshold(String string) {
        return this.createConverter(Integer.MAX_VALUE).convertString(string);
    }

    public IndexValue convertEntityRefIgnoreThreshold(EntityRef entityRef) {
        return IndexValue.createEntityRef(this.partConvertEntityRefIgnoreThreshold(entityRef));
    }

    public IndexValue.EntityRef partConvertEntityRefIgnoreThreshold(EntityRef entityRef) {
        return this.createConverter(Integer.MAX_VALUE).partConvertEntityRef(entityRef);
    }

    public IndexValue convertValueTruncateIfThresholdExceeded(Value value) {
        return this.createConverter(this.truncationThreshold).convertValue(value);
    }

    @Nullable
    public IndexValue convertValueNullIfThresholdExceeded(Value value) {
        Converter converter = this.createConverter(this.truncationThreshold);
        IndexValue indexValue = converter.convertValue(value);
        if (converter.thresholdExceeded()) {
            return null;
        }
        return indexValue;
    }

    public IndexValue convertValueIgnoreThreshold(Value value) {
        return this.createConverter(Integer.MAX_VALUE).convertValue(value);
    }

    private Converter createConverter(int truncationThreshold) {
        return new Converter(truncationThreshold, this.correctIncompleteKeyTruncation);
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PACKAGE_PRIVATE)
    protected static class Converter {
        private static final ValueToLegacyMapValueConverter LEGACY_CONVERTER = new ValueToLegacyMapValueConverter();
        private final boolean correctIncompleteKeyTruncation;
        private boolean thresholdExceeded = false;
        private int remainingSize;

        public Converter(int truncationThreshold, boolean correctIncompleteKeyTruncation) {
            this.remainingSize = truncationThreshold;
            this.correctIncompleteKeyTruncation = correctIncompleteKeyTruncation;
        }

        public boolean thresholdExceeded() {
            return this.thresholdExceeded;
        }

        @VisibleForTesting
        public int remainingSize() {
            return this.remainingSize;
        }

        public IndexValue convertPropertyPath(PropertyPath propertyPath) {
            ImmutableList.Builder elementsBuilder = ImmutableList.builder();
            while (propertyPath != null) {
                IndexValue elementIndexValue;
                PropertyPathSegment segment = propertyPath.segment();
                if (segment instanceof PropertyPathSegment.Member) {
                    PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)segment;
                    elementIndexValue = this.convertString(memberSegment.name().string());
                } else if (segment instanceof PropertyPathSegment.Index) {
                    PropertyPathSegment.Index indexSegment = (PropertyPathSegment.Index)segment;
                    elementIndexValue = this.convertLong(indexSegment.index());
                } else if (segment instanceof PropertyPathSegment.AllArrayElements) {
                    elementIndexValue = IndexValue.NULL;
                } else {
                    throw new IllegalArgumentException("Unknown property path segment type.");
                }
                elementsBuilder.add(elementIndexValue);
                propertyPath = propertyPath.next();
            }
            return IndexValue.createArray(false, (ImmutableList<IndexValue>)elementsBuilder.build());
        }

        public IndexValue convertValue(Value value) {
            value = LEGACY_CONVERTER.shallowConvertValue(value);
            switch (value.type()) {
                case NULL: {
                    --this.remainingSize;
                    return IndexValue.NULL;
                }
                case BOOLEAN: {
                    --this.remainingSize;
                    return IndexValue.createBoolean(value.asBoolean());
                }
                case LONG: {
                    return this.convertLong(value.asLong());
                }
                case DOUBLE: {
                    return this.convertDouble(value.asDouble());
                }
                case TIMESTAMP: {
                    this.remainingSize -= 8;
                    return IndexValue.createTimestamp(value.asTimestamp());
                }
                case STRING: {
                    return this.convertString(value.asString());
                }
                case BYTES: {
                    return this.convertBytes(value.asBytes());
                }
                case ENTITY_REF: {
                    return IndexValue.createEntityRef(this.partConvertEntityRef(value.asEntityRef()));
                }
                case GEO_POINT: {
                    this.remainingSize -= 16;
                    return IndexValue.createGeoPoint(value.asGeoPoint());
                }
                case ARRAY: {
                    return this.convertArray(value.asArray());
                }
                case MAP: {
                    return this.convertMap(value.asMap());
                }
                case RESOURCE_REF: {
                    if (!value.asResourceRef().equals(OtherServiceResourceRef.EMPTY)) break;
                    return IndexValue.createEntityRef(IndexValue.EntityRef.EMPTY);
                }
            }
            String string = String.valueOf((Object)value.type());
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported Value type ").append(string).toString());
        }

        private IndexValue convertLong(long num) {
            this.remainingSize -= 8;
            return IndexValue.createNumberLong(num);
        }

        private IndexValue convertDouble(double num) {
            this.remainingSize -= 8;
            if (num >= -9.223372036854776E18 && num < 9.223372036854776E18 && DoubleMath.isMathematicalInteger(num)) {
                return IndexValue.createNumberLong((long)num);
            }
            return IndexValue.createNumberDouble(num);
        }

        IndexValue convertString(String string) {
            boolean truncated;
            int index;
            --this.remainingSize;
            int stringLength = string.length();
            for (index = 0; index < stringLength && this.remainingSize > 0; ++index) {
                char c = string.charAt(index);
                if (c <= '\u007f') {
                    --this.remainingSize;
                    continue;
                }
                if (c <= '\u07ff') {
                    this.remainingSize -= 2;
                    continue;
                }
                if (!Character.isHighSurrogate(c)) {
                    this.remainingSize -= 3;
                    continue;
                }
                this.remainingSize -= 4;
                ++index;
            }
            boolean bl = truncated = index != stringLength;
            if (truncated) {
                string = string.substring(0, index);
                this.thresholdExceeded = true;
            }
            return IndexValue.createString(truncated, string);
        }

        private IndexValue convertBytes(ByteString bytes) {
            boolean truncated;
            int numBytes = bytes.size();
            boolean bl = truncated = numBytes > this.remainingSize;
            if (truncated) {
                bytes = bytes.substring(0, this.remainingSize);
                this.remainingSize = 0;
                this.thresholdExceeded = true;
            } else {
                this.remainingSize -= numBytes;
            }
            return IndexValue.createBytes(truncated, bytes);
        }

        public IndexValue.EntityRef partConvertEntityRef(EntityRef entityRef) {
            PartitionRef partitionRef = entityRef.partitionRef();
            DatabaseRef databaseRef = partitionRef.databaseRef();
            String namespaceId = partitionRef.namespace();
            this.remainingSize -= 16;
            IndexValue namespaceIdIndexValue = IndexValue.ABSENT;
            IndexValue segmentsIndexValue = IndexValue.ABSENT;
            if (this.remainingSize <= 0) {
                this.thresholdExceeded = true;
            } else if (namespaceId.isEmpty()) {
                namespaceIdIndexValue = IndexValue.EMPTY_STRING;
            } else {
                namespaceIdIndexValue = this.convertString(namespaceId);
                if (this.remainingSize <= 0) {
                    this.thresholdExceeded = true;
                }
            }
            if (this.remainingSize > 0) {
                segmentsIndexValue = this.convertEntityRefPath(entityRef);
            }
            return new IndexValue.EntityRef(databaseRef, namespaceIdIndexValue, segmentsIndexValue);
        }

        private IndexValue convertEntityRefPath(EntityRef entityRef) {
            ImmutableList<EntityRef.PathElement> entityRefPathElements = entityRef.pathElements();
            if (entityRefPathElements.isEmpty()) {
                return IndexValue.EMPTY_ARRAY;
            }
            ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
            boolean truncated = false;
            for (EntityRef.PathElement pathElement : entityRef.pathElements()) {
                IndexValue resourceIdIndexValue;
                byte[] bytes;
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                String collectionId = pathElement.collectionId();
                try {
                    bytes = ConverterHelper.convertStringToBytesIfNonUtf8("collection id", collectionId);
                }
                catch (InvalidConversionException exception) {
                    throw new IllegalArgumentException(exception);
                }
                if (bytes != null) {
                    collectionId = new String(bytes, StandardCharsets.UTF_8);
                }
                IndexValue collectionIdIndexValue = this.convertString(collectionId);
                segmentsBuilder.add(collectionIdIndexValue);
                EntityRef.ResourceId resourceId = pathElement.resourceId();
                if (resourceId == null && this.remainingSize >= 0 && this.correctIncompleteKeyTruncation) break;
                if (this.remainingSize <= 0) {
                    if (this.thresholdExceeded) break;
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                if (resourceId == null && !this.correctIncompleteKeyTruncation) break;
                if (resourceId.isLong()) {
                    resourceIdIndexValue = this.convertLong(resourceId.asLong());
                } else if (resourceId.isString()) {
                    String stringResourceId = resourceId.asString();
                    try {
                        bytes = ConverterHelper.convertStringToBytesIfNonUtf8("resource id", stringResourceId);
                    }
                    catch (InvalidConversionException exception) {
                        throw new IllegalArgumentException(exception);
                    }
                    if (bytes != null) {
                        stringResourceId = new String(bytes, StandardCharsets.UTF_8);
                    }
                    resourceIdIndexValue = this.convertString(stringResourceId);
                } else {
                    throw new IllegalArgumentException();
                }
                segmentsBuilder.add(resourceIdIndexValue);
                if (!this.thresholdExceeded) continue;
                break;
            }
            return IndexValue.createArray(truncated, (ImmutableList<IndexValue>)segmentsBuilder.build());
        }

        private IndexValue convertArray(ImmutableList<Value> array) {
            ImmutableList.Builder elementsBuilder = ImmutableList.builder();
            boolean truncated = false;
            for (Value elementValue : array) {
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                IndexValue elementIndexValue = this.convertValue(elementValue);
                elementsBuilder.add(elementIndexValue);
                if (!this.thresholdExceeded) continue;
                break;
            }
            return IndexValue.createArray(truncated, (ImmutableList<IndexValue>)elementsBuilder.build());
        }

        private IndexValue convertMap(ImmutableMap<String, Value> map) {
            ImmutableMap.Builder<IndexValue, IndexValue> entriesBuilder = ImmutableMap.builder();
            boolean truncated = false;
            for (String key : this.mapKeySetInOrder(map)) {
                IndexValue valueIndexValue;
                Value value = map.get(key);
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                IndexValue keyIndexValue = this.convertString(key);
                if (this.remainingSize <= 0) {
                    valueIndexValue = IndexValue.ABSENT;
                    if (!this.thresholdExceeded) {
                        this.thresholdExceeded = true;
                    }
                } else {
                    valueIndexValue = this.convertValue(value);
                }
                entriesBuilder.put(keyIndexValue, valueIndexValue);
                if (this.thresholdExceeded) break;
            }
            return IndexValue.createMap(truncated, entriesBuilder.build());
        }

        private String[] mapKeySetInOrder(ImmutableMap<String, Value> map) {
            String[] keys = new String[map.size()];
            ((ImmutableCollection)((Object)map.keySet())).toArray(keys);
            Arrays.sort(keys, UnicodeComparator.INSTANCE);
            return keys;
        }
    }
}

