/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.number;

public final class NumberComparisonHelper {
    public static final double LONG_INCLUSIVE_LOWER_BOUND_AS_DOUBLE = -9.223372036854776E18;
    public static final double LONG_EXCLUSIVE_UPPER_BOUND_AS_DOUBLE = 9.223372036854776E18;
    public static final long MAX_SAFE_LONG = 0x20000000000000L;
    public static final long MIN_SAFE_LONG = -9007199254740992L;

    public static int firestoreCompareDoubleWithLong(double doubleValue, long longValue) {
        if (Double.isNaN(doubleValue)) {
            return -1;
        }
        if (doubleValue < -9.223372036854776E18) {
            return -1;
        }
        if (doubleValue >= 9.223372036854776E18) {
            return 1;
        }
        long doubleAsLong = (long)doubleValue;
        int cmp = NumberComparisonHelper.compareLongs(doubleAsLong, longValue);
        if (cmp != 0) {
            return cmp;
        }
        double longAsDouble = longValue;
        return NumberComparisonHelper.firestoreCompareDoubles(doubleValue, longAsDouble);
    }

    public static int compareLongs(long leftLong, long rightLong) {
        return Long.compare(leftLong, rightLong);
    }

    public static int firestoreCompareDoubles(double leftDouble, double rightDouble) {
        if (leftDouble < rightDouble) {
            return -1;
        }
        if (leftDouble > rightDouble) {
            return 1;
        }
        if (leftDouble == rightDouble) {
            return 0;
        }
        if (!Double.isNaN(rightDouble)) {
            return -1;
        }
        if (!Double.isNaN(leftDouble)) {
            return 1;
        }
        return 0;
    }

    private NumberComparisonHelper() {
    }
}

