/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.number;

public final class NumberParts {
    static final int SIGNIFICAND_BITS = 64;
    static final int POSITIVE_INFINITE_EXPONENT = Integer.MAX_VALUE;
    static final int NEGATIVE_INFINITE_EXPONENT = Integer.MIN_VALUE;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int DOUBLE_MIN_EXPONENT = -1022;
    private static final int DOUBLE_SIGNIFICAND_BITS = 52;
    private static final long DOUBLE_SIGN_BIT = Long.MIN_VALUE;
    private final boolean negative;
    private final int exponent;
    private final long significand;

    private NumberParts(boolean negative, int exponent, long significand) {
        this.negative = negative;
        this.exponent = exponent;
        this.significand = significand;
    }

    public boolean negative() {
        return this.negative;
    }

    public int exponent() {
        return this.exponent;
    }

    public long significand() {
        return this.significand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberParts)) {
            return false;
        }
        NumberParts that = (NumberParts)o;
        return this.negative == that.negative && this.exponent == that.exponent && this.significand == that.significand;
    }

    public int hashCode() {
        int result = this.negative ? 1 : 0;
        result = 31 * result + this.exponent;
        result = 31 * result + (int)(this.significand ^ this.significand >>> 32);
        return result;
    }

    public boolean isZero() {
        return this.exponent() == Integer.MIN_VALUE && this.significand() == 0L;
    }

    public boolean isNaN() {
        return this.exponent() == Integer.MAX_VALUE && this.significand() != 0L;
    }

    public boolean isInfinite() {
        return this.exponent() == Integer.MAX_VALUE && this.significand() == 0L;
    }

    public static NumberParts create(boolean negative, int exponent, long significand) {
        if (!(exponent != Integer.MAX_VALUE || significand == 0L || negative && significand == 1L)) {
            throw new IllegalArgumentException("Invalid number parts: non-normalized NaN");
        }
        return new NumberParts(negative, exponent, significand);
    }

    public static NumberParts fromLong(long value) {
        if (value == 0L) {
            return NumberParts.create(false, Integer.MIN_VALUE, 0L);
        }
        boolean negative = false;
        if (value < 0L) {
            negative = true;
            value = -value;
        }
        int leadingZeros = Long.numberOfLeadingZeros(value);
        int binaryExponent = 63 - leadingZeros;
        long significand = value & (1L << binaryExponent ^ 0xFFFFFFFFFFFFFFFFL);
        return NumberParts.create(negative, binaryExponent, significand <<= leadingZeros + 1);
    }

    public static NumberParts fromDouble(double value) {
        long doubleBits = Double.doubleToLongBits(value);
        boolean negative = value < 0.0;
        int exponent = (int)(doubleBits >>> 52 & 0x7FFL) - 1023;
        long significand = doubleBits & 0xFFFFFFFFFFFFFL;
        if (exponent < -1022) {
            if (significand == 0L) {
                return NumberParts.create(false, Integer.MIN_VALUE, 0L);
            }
            int leadingZeros = Long.numberOfLeadingZeros(significand);
            int binaryExponent = 63 - leadingZeros;
            significand &= 1L << binaryExponent ^ 0xFFFFFFFFFFFFFFFFL;
            significand <<= leadingZeros + 1;
            int adjustment = leadingZeros - 12;
            exponent -= adjustment;
        } else {
            if (exponent > 1023) {
                return significand == 0L ? (negative ? NumberParts.create(true, Integer.MAX_VALUE, 0L) : NumberParts.create(false, Integer.MAX_VALUE, 0L)) : NumberParts.create(true, Integer.MAX_VALUE, 1L);
            }
            significand <<= 12;
        }
        return NumberParts.create(negative, exponent, significand);
    }

    public NumberParts negate() {
        if (this.isZero() || this.isNaN()) {
            return this;
        }
        return NumberParts.create(!this.negative(), this.exponent(), this.significand());
    }

    public boolean representableAsDouble() {
        return NumberParts.doubleRepresentationError() == null;
    }

    public boolean representableAsLong() {
        return this.longRepresentationError() == null;
    }

    public double asDouble() {
        String representationError = NumberParts.doubleRepresentationError();
        if (representationError != null) {
            throw new IllegalArgumentException(representationError);
        }
        if (this.isZero()) {
            return 0.0;
        }
        if (this.isInfinite()) {
            return this.negative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        long exponent = this.exponent();
        long significand = this.significand();
        significand >>>= 12;
        if (exponent >= -1022L) {
            exponent += 1023L;
        } else {
            int adjustment = -1022 - this.exponent();
            significand >>>= adjustment;
            significand |= 1L << 52 - adjustment;
            exponent = 0L;
        }
        long result = significand;
        result |= exponent << 52;
        return Double.longBitsToDouble(result |= this.negative() ? Long.MIN_VALUE : 0L);
    }

    public long asLong() {
        String representationError = this.longRepresentationError();
        if (representationError != null) {
            throw new IllegalArgumentException(representationError);
        }
        if (this.isZero()) {
            return 0L;
        }
        if (this.exponent() == 63) {
            return Long.MIN_VALUE;
        }
        long result = this.significand();
        int leadingZeros = 63 - this.exponent();
        result >>>= leadingZeros + 1;
        result ^= 1L << this.exponent();
        if (this.negative()) {
            result = -result;
        }
        return result;
    }

    private static String doubleRepresentationError() {
        return null;
    }

    private String longRepresentationError() {
        if (this.isZero()) {
            return null;
        }
        if (this.isInfinite()) {
            String string = String.valueOf(this);
            return new StringBuilder(45 + String.valueOf(string).length()).append("Invalid encoded long ").append(string).append(": Infinity is not a long").toString();
        }
        if (this.isNaN()) {
            String string = String.valueOf(this);
            return new StringBuilder(40 + String.valueOf(string).length()).append("Invalid encoded long ").append(string).append(": NaN is not a long").toString();
        }
        if (this.exponent() == 63) {
            if (this.significand() != 0L || !this.negative()) {
                String string = String.valueOf(this);
                return new StringBuilder(31 + String.valueOf(string).length()).append("Invalid encoded long ").append(string).append(": overflow").toString();
            }
            return null;
        }
        if (this.exponent() < 0 || this.exponent() > 63) {
            String string = String.valueOf(this);
            int n = this.exponent();
            return new StringBuilder(53 + String.valueOf(string).length()).append("Invalid encoded long ").append(string).append(": exponent ").append(n).append(" too large").toString();
        }
        int trailingZeros = Long.numberOfTrailingZeros(this.significand());
        if (this.exponent() < 64 - trailingZeros) {
            String string = String.valueOf(this);
            return new StringBuilder(47 + String.valueOf(string).length()).append("Invalid encoded long ").append(string).append(": contains fractional part").toString();
        }
        return null;
    }
}

