/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.order;

import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueComparator;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.ValueOrder;
import com.google.cloud.datastore.core.rep.ValueSet;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class FirestoreValueOrder
extends ValueOrder {
    public static final FirestoreValueOrder INSTANCE = new FirestoreValueOrder();
    private static final Value NULL_VALUE = INSTANCE.canonicalizeValue(Value.NULL);
    private static final Value FALSE_VALUE = INSTANCE.canonicalizeValue(Value.FALSE);
    private static final Value NAN_VALUE = INSTANCE.canonicalizeValue(Value.NAN);
    private static final Value NEGATIVE_INFINITY_VALUE = INSTANCE.canonicalizeValue(Value.NEGATIVE_INFINITY);
    private static final Value MIN_VALID_TIMESTAMP_VALUE = INSTANCE.canonicalizeValue(Value.MIN_VALID_TIMESTAMP);
    private static final Value EMPTY_STRING_VALUE = INSTANCE.canonicalizeValue(Value.EMPTY_STRING);
    private static final Value EMPTY_BYTES_VALUE = INSTANCE.canonicalizeValue(Value.EMPTY_BYTES);
    private static final Value EMPTY_RESOURCE_REF_VALUE = INSTANCE.canonicalizeValue(Value.EMPTY_RESOURCE_REF);
    private static final Value MIN_VALID_GEO_POINT_VALUE = INSTANCE.canonicalizeValue(Value.MIN_VALID_GEO_POINT);
    private static final Value EMPTY_ARRAY_VALUE = INSTANCE.canonicalizeValue(Value.EMPTY_ARRAY);
    private static final Value EMPTY_MAP_VALUE = INSTANCE.canonicalizeValue(Value.EMPTY_MAP);
    public static final Value MIN_VALUE = NULL_VALUE;
    private static final Value[] VALUE_TYPE_MIN_VALUE_ARRAY = new Value[]{NULL_VALUE, FALSE_VALUE, NEGATIVE_INFINITY_VALUE, NEGATIVE_INFINITY_VALUE, MIN_VALID_TIMESTAMP_VALUE, EMPTY_STRING_VALUE, EMPTY_BYTES_VALUE, EMPTY_RESOURCE_REF_VALUE, EMPTY_RESOURCE_REF_VALUE, MIN_VALID_GEO_POINT_VALUE, EMPTY_ARRAY_VALUE, EMPTY_MAP_VALUE, EMPTY_MAP_VALUE, EMPTY_MAP_VALUE, EMPTY_MAP_VALUE};
    private static final Value[] VALUE_TYPE_NEXT_CATEGORY_MIN_VALUE_ARRAY = new Value[]{FALSE_VALUE, NAN_VALUE, MIN_VALID_TIMESTAMP_VALUE, MIN_VALID_TIMESTAMP_VALUE, EMPTY_STRING_VALUE, EMPTY_BYTES_VALUE, EMPTY_RESOURCE_REF_VALUE, MIN_VALID_GEO_POINT_VALUE, MIN_VALID_GEO_POINT_VALUE, EMPTY_ARRAY_VALUE, EMPTY_MAP_VALUE, null, null, null, null};

    private FirestoreValueOrder() {
    }

    @Override
    public Value minValue() {
        return MIN_VALUE;
    }

    @Override
    public Value canonicalizeValue(Value value) {
        if ((value = value.withDatastoreIndexing(Value.DatastoreIndexing.AUTO)).type() != Value.Type.DOUBLE) {
            return value;
        }
        double dub = value.asDouble();
        if (!DoubleMath.isMathematicalInteger(dub)) {
            return value;
        }
        if (dub < -9.223372036854776E18 || dub >= 9.223372036854776E18) {
            return value;
        }
        return Value.createLong(DoubleMath.roundToLong(dub, RoundingMode.UNNECESSARY)).withDatastoreIndexing(Value.DatastoreIndexing.AUTO);
    }

    @Override
    public int compare(@Nullable Value leftValue, @Nullable Value rightValue) {
        if (rightValue == null) {
            if (leftValue == null) {
                return 0;
            }
            return -1;
        }
        if (leftValue == null) {
            return 1;
        }
        return FirestoreIndexValueComparator.INSTANCE.compare(ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(leftValue), ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(rightValue));
    }

    @Override
    public Value minValueOfCategory(Value value) {
        int valueTypeOrdinal = value.type().ordinal();
        Preconditions.checkArgument(valueTypeOrdinal < VALUE_TYPE_MIN_VALUE_ARRAY.length);
        if (value.meaning() != Value.Meaning.NONE && value.meaning() != Value.Meaning.OMITTED_BY_MEGASTORE_INDEX) {
            valueTypeOrdinal = Value.Type.MAP.ordinal();
        } else if (value.isNaN()) {
            return NAN_VALUE;
        }
        return VALUE_TYPE_MIN_VALUE_ARRAY[valueTypeOrdinal];
    }

    @Override
    @Nullable
    public Value minValueOfNextCategory(Value value) {
        int valueTypeOrdinal = value.type().ordinal();
        Preconditions.checkArgument(valueTypeOrdinal < VALUE_TYPE_NEXT_CATEGORY_MIN_VALUE_ARRAY.length);
        if (value.meaning() != Value.Meaning.NONE && value.meaning() != Value.Meaning.OMITTED_BY_MEGASTORE_INDEX) {
            valueTypeOrdinal = Value.Type.MAP.ordinal();
        } else if (value.isNaN()) {
            return NEGATIVE_INFINITY_VALUE;
        }
        return VALUE_TYPE_NEXT_CATEGORY_MIN_VALUE_ARRAY[valueTypeOrdinal];
    }

    @Override
    @Nullable
    public Value bottomValueOfCategory(Value value) {
        Value.Type type = value.type();
        if (type == Value.Type.LONG || type == Value.Type.DOUBLE) {
            return NAN_VALUE;
        }
        return null;
    }

    @Override
    public boolean areValuesComparableForRelOp(Value leftValue, Value rightValue) {
        Value rightCategoryMinValue;
        Value leftCategoryMinValue = VALUE_TYPE_MIN_VALUE_ARRAY[leftValue.type().ordinal()];
        return leftCategoryMinValue == (rightCategoryMinValue = VALUE_TYPE_MIN_VALUE_ARRAY[rightValue.type().ordinal()]);
    }

    @Override
    public boolean isValueBottom(Value value) {
        return value.isNaN();
    }

    @Override
    public ValueSet createValueSet() {
        return new ValueSet(this){
            TreeSet<IndexValue> valueTreeSet = new TreeSet<IndexValue>(FirestoreIndexValueComparator.INSTANCE);

            @Override
            public boolean add(Value value) {
                return this.valueTreeSet.add(ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(value));
            }

            @Override
            public boolean contains(Value value) {
                return this.valueTreeSet.contains(ValueToFirestoreIndexValueConverter.DEFAULT.convertValueIgnoreThreshold(value));
            }
        };
    }
}

