/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.query;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ConditionNormalizer {
    private final int maxOrSubConditions;

    public ConditionNormalizer(int maxOrSubConditions) {
        this.maxOrSubConditions = maxOrSubConditions;
    }

    public Condition toDisjunctiveNormalForm(@Nullable Condition condition) throws ValidationException {
        if (condition == null) {
            return null;
        }
        if ((condition = this.toDnfRecursive(false, condition)).op() == Condition.Op.OR && ((LogicalCondition)condition).subConditions().size() > this.maxOrSubConditions) {
            throw new ValidationException("Too many OR sub-clauses after normalization.");
        }
        return condition;
    }

    private Condition toDnfRecursive(boolean not, Condition condition) throws ValidationException {
        switch (condition.op()) {
            case RESERVED_NOT: {
                return this.toDnfNot(not, (LogicalCondition)condition);
            }
            case AND: 
            case OR: {
                return this.toDnfOrAnd(not, (LogicalCondition)condition);
            }
        }
        if (not) {
            return LogicalCondition.create(Condition.Op.RESERVED_NOT, ImmutableList.of(condition));
        }
        return condition;
    }

    private Condition toDnfNot(boolean not, LogicalCondition notCondition) throws ValidationException {
        Condition subCondition = (Condition)notCondition.subConditions().get(0);
        Condition.Op subConditionOp = subCondition.op();
        if (!not && subConditionOp != Condition.Op.RESERVED_NOT && subConditionOp != Condition.Op.AND && subConditionOp != Condition.Op.OR) {
            return notCondition;
        }
        return this.toDnfRecursive(!not, subCondition);
    }

    private Condition toDnfOrAnd(boolean not, LogicalCondition condition) throws ValidationException {
        ImmutableCollection normalizedSubConditions;
        Condition.Op op = condition.op();
        Condition.Op normalizedOp = not ? (op == Condition.Op.AND ? Condition.Op.OR : Condition.Op.AND) : op;
        ImmutableList.Builder<Condition> normalizedSubConditionsBuilder = ImmutableList.builder();
        boolean normalizedSubConditionsMatchesOriginal = this.toDnfOrAndSubConditions(not, normalizedOp, condition, normalizedSubConditionsBuilder);
        ImmutableCollection immutableCollection = normalizedSubConditions = normalizedSubConditionsMatchesOriginal ? condition.subConditions() : normalizedSubConditionsBuilder.build();
        if (normalizedOp == Condition.Op.AND) {
            for (Condition subCondition : normalizedSubConditions) {
                if (subCondition.op() != Condition.Op.OR) continue;
                return this.transformAndOfOrsToOrOfAnds((ImmutableList<Condition>)normalizedSubConditions);
            }
        }
        if (!not && normalizedSubConditionsMatchesOriginal) {
            return condition;
        }
        return LogicalCondition.create(normalizedOp, (ImmutableList<Condition>)normalizedSubConditions);
    }

    private boolean toDnfOrAndSubConditions(boolean not, Condition.Op normalizedOp, LogicalCondition condition, ImmutableList.Builder<Condition> normalizedSubConditionsBuilder) throws ValidationException {
        boolean outputMatchesInput = true;
        for (Condition subCondition : condition.subConditions()) {
            if (subCondition.op() == condition.op()) {
                LogicalCondition logicalSubCondition = (LogicalCondition)subCondition;
                this.toDnfOrAndSubConditions(not, normalizedOp, logicalSubCondition, normalizedSubConditionsBuilder);
                outputMatchesInput = false;
                continue;
            }
            Condition normalizedSubCondition = this.toDnfRecursive(not, subCondition);
            if (normalizedSubCondition.op() == normalizedOp) {
                LogicalCondition orAndSubCondition = (LogicalCondition)subCondition;
                normalizedSubConditionsBuilder.addAll(orAndSubCondition.subConditions());
                outputMatchesInput = false;
                continue;
            }
            normalizedSubConditionsBuilder.add((Object)normalizedSubCondition);
            if (normalizedSubCondition == subCondition) continue;
            outputMatchesInput = false;
        }
        return outputMatchesInput;
    }

    private Condition transformAndOfOrsToOrOfAnds(ImmutableList<Condition> andSubConditions) throws ValidationException {
        ArrayList<List<Condition>> conditionListList = new ArrayList<List<Condition>>();
        conditionListList.add(new ArrayList());
        for (Condition andSubCondition : andSubConditions) {
            if (andSubCondition.op() == Condition.Op.OR) {
                this.addOrSubConditionsToConditionListList((LogicalCondition)andSubCondition, conditionListList);
                continue;
            }
            for (List list : conditionListList) {
                list.add(andSubCondition);
            }
        }
        ImmutableList.Builder andConditionsBuilder = ImmutableList.builder();
        for (List list : conditionListList) {
            LogicalCondition logicalCondition = LogicalCondition.create(Condition.Op.AND, ImmutableList.copyOf(list));
            andConditionsBuilder.add(logicalCondition);
        }
        return LogicalCondition.create(Condition.Op.OR, (ImmutableList<Condition>)andConditionsBuilder.build());
    }

    private void addOrSubConditionsToConditionListList(LogicalCondition orCondition, List<List<Condition>> conditionListList) throws ValidationException {
        int oldNumConditionLists;
        ImmutableList<Condition> orSubConditions = orCondition.subConditions();
        int numOrSubConditions = orSubConditions.size();
        int newNumConditionLists = numOrSubConditions * (oldNumConditionLists = conditionListList.size());
        if (newNumConditionLists > this.maxOrSubConditions) {
            throw new ValidationException("Too many OR sub-clauses after normalization.");
        }
        for (int copyCounter = 1; copyCounter < numOrSubConditions; ++copyCounter) {
            for (int listListIndex = 0; listListIndex < oldNumConditionLists; ++listListIndex) {
                List<Condition> oldConditionList = conditionListList.get(listListIndex);
                ArrayList<Condition> newConditionList = new ArrayList<Condition>(oldConditionList);
                conditionListList.add(newConditionList);
            }
        }
        for (int listListIndex = 0; listListIndex < newNumConditionLists; ++listListIndex) {
            int orSubConditionListIndex = listListIndex % numOrSubConditions;
            Condition orSubCondition = (Condition)orSubConditions.get(orSubConditionListIndex);
            if (orSubCondition.op() == Condition.Op.AND) {
                LogicalCondition andCondition = (LogicalCondition)orSubCondition;
                conditionListList.get(listListIndex).addAll(andCondition.subConditions());
                continue;
            }
            conditionListList.get(listListIndex).add(orSubCondition);
        }
    }
}

