/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.AutoValue_Index;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.internal.StorageFormat;
import com.google.common.base.Optional;
import javax.annotation.Nullable;

abstract class $AutoValue_Index
extends Index {
    private final IndexDef definition;
    private final long id;
    private final Optional<StorageFormat.BuiltinIndexId> builtinIndexId;
    private final Long updateTimeMicros;
    private final WorkflowState workflowState;
    private final boolean error;
    private final Index.StorageVersion storageVersion;

    $AutoValue_Index(IndexDef definition, long id, Optional<StorageFormat.BuiltinIndexId> builtinIndexId, @Nullable Long updateTimeMicros, WorkflowState workflowState, boolean error, Index.StorageVersion storageVersion) {
        if (definition == null) {
            throw new NullPointerException("Null definition");
        }
        this.definition = definition;
        this.id = id;
        if (builtinIndexId == null) {
            throw new NullPointerException("Null builtinIndexId");
        }
        this.builtinIndexId = builtinIndexId;
        this.updateTimeMicros = updateTimeMicros;
        if (workflowState == null) {
            throw new NullPointerException("Null workflowState");
        }
        this.workflowState = workflowState;
        this.error = error;
        if (storageVersion == null) {
            throw new NullPointerException("Null storageVersion");
        }
        this.storageVersion = storageVersion;
    }

    @Override
    public IndexDef definition() {
        return this.definition;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Optional<StorageFormat.BuiltinIndexId> builtinIndexId() {
        return this.builtinIndexId;
    }

    @Override
    @Nullable
    public Long updateTimeMicros() {
        return this.updateTimeMicros;
    }

    @Override
    public WorkflowState workflowState() {
        return this.workflowState;
    }

    @Override
    public boolean error() {
        return this.error;
    }

    @Override
    public Index.StorageVersion storageVersion() {
        return this.storageVersion;
    }

    public String toString() {
        String string = String.valueOf(this.definition);
        long l = this.id;
        String string2 = String.valueOf(this.builtinIndexId);
        String string3 = String.valueOf(this.updateTimeMicros);
        String string4 = String.valueOf((Object)this.workflowState);
        boolean bl = this.error;
        String string5 = String.valueOf((Object)this.storageVersion);
        return new StringBuilder(125 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Index{definition=").append(string).append(", id=").append(l).append(", builtinIndexId=").append(string2).append(", updateTimeMicros=").append(string3).append(", workflowState=").append(string4).append(", error=").append(bl).append(", storageVersion=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Index) {
            Index that = (Index)o;
            return this.definition.equals(that.definition()) && this.id == that.id() && this.builtinIndexId.equals(that.builtinIndexId()) && (this.updateTimeMicros == null ? that.updateTimeMicros() == null : this.updateTimeMicros.equals(that.updateTimeMicros())) && this.workflowState.equals((Object)that.workflowState()) && this.error == that.error() && this.storageVersion.equals((Object)that.storageVersion());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.definition.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.id >>> 32 ^ this.id);
        h$ *= 1000003;
        h$ ^= this.builtinIndexId.hashCode();
        h$ *= 1000003;
        h$ ^= this.updateTimeMicros == null ? 0 : this.updateTimeMicros.hashCode();
        h$ *= 1000003;
        h$ ^= this.workflowState.hashCode();
        h$ *= 1000003;
        h$ ^= this.error ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.storageVersion.hashCode();
    }

    @Override
    protected Index.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Index.Builder {
        private IndexDef definition;
        private Long id;
        private Optional<StorageFormat.BuiltinIndexId> builtinIndexId = Optional.absent();
        private Long updateTimeMicros;
        private WorkflowState workflowState;
        private Boolean error;
        private Index.StorageVersion storageVersion;

        Builder() {
        }

        private Builder(Index source) {
            this.definition = source.definition();
            this.id = source.id();
            this.builtinIndexId = source.builtinIndexId();
            this.updateTimeMicros = source.updateTimeMicros();
            this.workflowState = source.workflowState();
            this.error = source.error();
            this.storageVersion = source.storageVersion();
        }

        @Override
        public Index.Builder definition(IndexDef definition) {
            if (definition == null) {
                throw new NullPointerException("Null definition");
            }
            this.definition = definition;
            return this;
        }

        @Override
        public Index.Builder id(long id) {
            this.id = id;
            return this;
        }

        @Override
        public Index.Builder builtinIndexId(StorageFormat.BuiltinIndexId builtinIndexId) {
            this.builtinIndexId = Optional.of(builtinIndexId);
            return this;
        }

        @Override
        public Index.Builder builtinIndexId(Optional<StorageFormat.BuiltinIndexId> builtinIndexId) {
            if (builtinIndexId == null) {
                throw new NullPointerException("Null builtinIndexId");
            }
            this.builtinIndexId = builtinIndexId;
            return this;
        }

        @Override
        public Index.Builder updateTimeMicros(@Nullable Long updateTimeMicros) {
            this.updateTimeMicros = updateTimeMicros;
            return this;
        }

        @Override
        protected Index.Builder workflowState(WorkflowState workflowState) {
            if (workflowState == null) {
                throw new NullPointerException("Null workflowState");
            }
            this.workflowState = workflowState;
            return this;
        }

        @Override
        protected Index.Builder error(boolean error) {
            this.error = error;
            return this;
        }

        @Override
        public Index.Builder storageVersion(Index.StorageVersion storageVersion) {
            if (storageVersion == null) {
                throw new NullPointerException("Null storageVersion");
            }
            this.storageVersion = storageVersion;
            return this;
        }

        @Override
        Index autoBuild() {
            String missing = "";
            if (this.definition == null) {
                missing = String.valueOf(missing).concat(" definition");
            }
            if (this.id == null) {
                missing = String.valueOf(missing).concat(" id");
            }
            if (this.workflowState == null) {
                missing = String.valueOf(missing).concat(" workflowState");
            }
            if (this.error == null) {
                missing = String.valueOf(missing).concat(" error");
            }
            if (this.storageVersion == null) {
                missing = String.valueOf(missing).concat(" storageVersion");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Index(this.definition, this.id, this.builtinIndexId, this.updateTimeMicros, this.workflowState, this.error, this.storageVersion);
        }
    }
}

