/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.AutoValue_Lookup;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.common.collect.ImmutableList;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

abstract class $AutoValue_Lookup
extends Lookup {
    private final ImmutableList<OnestoreEntity.Reference> keys;
    private final PropertyMask propertyMask;
    private final Long readTimestamp;
    private final boolean isStrong;
    private final boolean allowDefer;
    private final boolean allowFailover;

    $AutoValue_Lookup(ImmutableList<OnestoreEntity.Reference> keys, PropertyMask propertyMask, @Nullable Long readTimestamp, boolean isStrong, boolean allowDefer, boolean allowFailover) {
        if (keys == null) {
            throw new NullPointerException("Null keys");
        }
        this.keys = keys;
        if (propertyMask == null) {
            throw new NullPointerException("Null propertyMask");
        }
        this.propertyMask = propertyMask;
        this.readTimestamp = readTimestamp;
        this.isStrong = isStrong;
        this.allowDefer = allowDefer;
        this.allowFailover = allowFailover;
    }

    @Override
    public ImmutableList<OnestoreEntity.Reference> keys() {
        return this.keys;
    }

    @Override
    public PropertyMask propertyMask() {
        return this.propertyMask;
    }

    @Override
    @Nullable
    public Long readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public boolean isStrong() {
        return this.isStrong;
    }

    @Override
    public boolean allowDefer() {
        return this.allowDefer;
    }

    @Override
    public boolean allowFailover() {
        return this.allowFailover;
    }

    public String toString() {
        String string = String.valueOf(this.keys);
        String string2 = String.valueOf(this.propertyMask);
        String string3 = String.valueOf(this.readTimestamp);
        boolean bl = this.isStrong;
        boolean bl2 = this.allowDefer;
        boolean bl3 = this.allowFailover;
        return new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Lookup{keys=").append(string).append(", propertyMask=").append(string2).append(", readTimestamp=").append(string3).append(", isStrong=").append(bl).append(", allowDefer=").append(bl2).append(", allowFailover=").append(bl3).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Lookup) {
            Lookup that = (Lookup)o;
            return this.keys.equals(that.keys()) && this.propertyMask.equals(that.propertyMask()) && (this.readTimestamp == null ? that.readTimestamp() == null : this.readTimestamp.equals(that.readTimestamp())) && this.isStrong == that.isStrong() && this.allowDefer == that.allowDefer() && this.allowFailover == that.allowFailover();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.keys.hashCode();
        h$ *= 1000003;
        h$ ^= this.propertyMask.hashCode();
        h$ *= 1000003;
        h$ ^= this.readTimestamp == null ? 0 : this.readTimestamp.hashCode();
        h$ *= 1000003;
        h$ ^= this.isStrong ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.allowDefer ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.allowFailover ? 1231 : 1237;
    }

    @Override
    public Lookup.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Lookup.Builder {
        private ImmutableList<OnestoreEntity.Reference> keys;
        private PropertyMask propertyMask;
        private Long readTimestamp;
        private Boolean isStrong;
        private Boolean allowDefer;
        private Boolean allowFailover;

        Builder() {
        }

        private Builder(Lookup source) {
            this.keys = source.keys();
            this.propertyMask = source.propertyMask();
            this.readTimestamp = source.readTimestamp();
            this.isStrong = source.isStrong();
            this.allowDefer = source.allowDefer();
            this.allowFailover = source.allowFailover();
        }

        @Override
        public Lookup.Builder keys(Iterable<OnestoreEntity.Reference> keys) {
            this.keys = ImmutableList.copyOf(keys);
            return this;
        }

        @Override
        public Lookup.Builder propertyMask(PropertyMask propertyMask) {
            if (propertyMask == null) {
                throw new NullPointerException("Null propertyMask");
            }
            this.propertyMask = propertyMask;
            return this;
        }

        @Override
        public Lookup.Builder readTimestamp(@Nullable Long readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public Lookup.Builder isStrong(boolean isStrong) {
            this.isStrong = isStrong;
            return this;
        }

        @Override
        public Lookup.Builder allowDefer(boolean allowDefer) {
            this.allowDefer = allowDefer;
            return this;
        }

        @Override
        public Lookup.Builder allowFailover(boolean allowFailover) {
            this.allowFailover = allowFailover;
            return this;
        }

        @Override
        public Lookup build() {
            String missing = "";
            if (this.keys == null) {
                missing = String.valueOf(missing).concat(" keys");
            }
            if (this.propertyMask == null) {
                missing = String.valueOf(missing).concat(" propertyMask");
            }
            if (this.isStrong == null) {
                missing = String.valueOf(missing).concat(" isStrong");
            }
            if (this.allowDefer == null) {
                missing = String.valueOf(missing).concat(" allowDefer");
            }
            if (this.allowFailover == null) {
                missing = String.valueOf(missing).concat(" allowFailover");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Lookup(this.keys, this.propertyMask, this.readTimestamp, this.isStrong, this.allowDefer, this.allowFailover);
        }
    }
}

