/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.AutoValue_Write;
import com.google.cloud.datastore.core.rep.IdAllocationPolicy;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.rep.WriteStreamContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import javax.annotation.Nullable;

abstract class $AutoValue_Write
extends Write {
    private final WriteStreamContext writeStreamContext;
    private final ImmutableList<Mutation> mutations;
    private final int[] originalMutationsMap;
    private final ImmutableMap<Integer, Integer> originalTransformations;
    private final boolean isTrusted;
    private final boolean markChanges;
    private final IdAllocationPolicy idPolicy;

    $AutoValue_Write(@Nullable WriteStreamContext writeStreamContext, ImmutableList<Mutation> mutations, @Nullable int[] originalMutationsMap, @Nullable ImmutableMap<Integer, Integer> originalTransformations, boolean isTrusted, boolean markChanges, @Nullable IdAllocationPolicy idPolicy) {
        this.writeStreamContext = writeStreamContext;
        if (mutations == null) {
            throw new NullPointerException("Null mutations");
        }
        this.mutations = mutations;
        this.originalMutationsMap = originalMutationsMap;
        this.originalTransformations = originalTransformations;
        this.isTrusted = isTrusted;
        this.markChanges = markChanges;
        this.idPolicy = idPolicy;
    }

    @Override
    @Nullable
    public WriteStreamContext writeStreamContext() {
        return this.writeStreamContext;
    }

    @Override
    public ImmutableList<Mutation> mutations() {
        return this.mutations;
    }

    @Override
    @Nullable
    public int[] originalMutationsMap() {
        return this.originalMutationsMap;
    }

    @Override
    @Nullable
    public ImmutableMap<Integer, Integer> originalTransformations() {
        return this.originalTransformations;
    }

    @Override
    public boolean isTrusted() {
        return this.isTrusted;
    }

    @Override
    public boolean markChanges() {
        return this.markChanges;
    }

    @Override
    @Nullable
    public IdAllocationPolicy idPolicy() {
        return this.idPolicy;
    }

    public String toString() {
        String string = String.valueOf(this.writeStreamContext);
        String string2 = String.valueOf(this.mutations);
        String string3 = Arrays.toString(this.originalMutationsMap);
        String string4 = String.valueOf(this.originalTransformations);
        boolean bl = this.isTrusted;
        boolean bl2 = this.markChanges;
        String string5 = String.valueOf((Object)this.idPolicy);
        return new StringBuilder(134 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Write{writeStreamContext=").append(string).append(", mutations=").append(string2).append(", originalMutationsMap=").append(string3).append(", originalTransformations=").append(string4).append(", isTrusted=").append(bl).append(", markChanges=").append(bl2).append(", idPolicy=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Write) {
            Write that = (Write)o;
            return (this.writeStreamContext == null ? that.writeStreamContext() == null : this.writeStreamContext.equals(that.writeStreamContext())) && this.mutations.equals(that.mutations()) && Arrays.equals(this.originalMutationsMap, that instanceof $AutoValue_Write ? (($AutoValue_Write)that).originalMutationsMap : that.originalMutationsMap()) && (this.originalTransformations == null ? that.originalTransformations() == null : this.originalTransformations.equals(that.originalTransformations())) && this.isTrusted == that.isTrusted() && this.markChanges == that.markChanges() && (this.idPolicy == null ? that.idPolicy() == null : this.idPolicy.equals((Object)that.idPolicy()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.writeStreamContext == null ? 0 : this.writeStreamContext.hashCode();
        h$ *= 1000003;
        h$ ^= this.mutations.hashCode();
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.originalMutationsMap);
        h$ *= 1000003;
        h$ ^= this.originalTransformations == null ? 0 : this.originalTransformations.hashCode();
        h$ *= 1000003;
        h$ ^= this.isTrusted ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.markChanges ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.idPolicy == null ? 0 : this.idPolicy.hashCode();
    }

    @Override
    public Write.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Write.Builder {
        private WriteStreamContext writeStreamContext;
        private ImmutableList<Mutation> mutations;
        private int[] originalMutationsMap;
        private ImmutableMap<Integer, Integer> originalTransformations;
        private Boolean isTrusted;
        private Boolean markChanges;
        private IdAllocationPolicy idPolicy;

        Builder() {
        }

        private Builder(Write source) {
            this.writeStreamContext = source.writeStreamContext();
            this.mutations = source.mutations();
            this.originalMutationsMap = source.originalMutationsMap();
            this.originalTransformations = source.originalTransformations();
            this.isTrusted = source.isTrusted();
            this.markChanges = source.markChanges();
            this.idPolicy = source.idPolicy();
        }

        @Override
        public Write.Builder writeStreamContext(@Nullable WriteStreamContext writeStreamContext) {
            this.writeStreamContext = writeStreamContext;
            return this;
        }

        @Override
        public Write.Builder mutations(Iterable<Mutation> mutations) {
            this.mutations = ImmutableList.copyOf(mutations);
            return this;
        }

        @Override
        public ImmutableList<Mutation> mutations() {
            if (this.mutations == null) {
                throw new IllegalStateException("Property \"mutations\" has not been set");
            }
            return this.mutations;
        }

        @Override
        public Write.Builder originalMutationsMap(int[] originalMutationsMap) {
            this.originalMutationsMap = originalMutationsMap;
            return this;
        }

        @Override
        public Write.Builder originalTransformations(ImmutableMap<Integer, Integer> originalTransformations) {
            this.originalTransformations = originalTransformations;
            return this;
        }

        @Override
        public Write.Builder isTrusted(boolean isTrusted) {
            this.isTrusted = isTrusted;
            return this;
        }

        @Override
        public Write.Builder markChanges(boolean markChanges) {
            this.markChanges = markChanges;
            return this;
        }

        @Override
        public Write.Builder idPolicy(@Nullable IdAllocationPolicy idPolicy) {
            this.idPolicy = idPolicy;
            return this;
        }

        @Override
        protected Write autoBuild() {
            String missing = "";
            if (this.mutations == null) {
                missing = String.valueOf(missing).concat(" mutations");
            }
            if (this.isTrusted == null) {
                missing = String.valueOf(missing).concat(" isTrusted");
            }
            if (this.markChanges == null) {
                missing = String.valueOf(missing).concat(" markChanges");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Write(this.writeStreamContext, this.mutations, this.originalMutationsMap, this.originalTransformations, this.isTrusted, this.markChanges, this.idPolicy);
        }
    }
}

