/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatastoreBuiltinIndex {
    public abstract Mode mode();

    public abstract WorkflowState workflowState();

    @Nullable
    public abstract Long updateTimeMicros();

    public static DatastoreBuiltinIndex create(Mode mode, WorkflowState workflowState) {
        return DatastoreBuiltinIndex.create(mode, workflowState, null);
    }

    public static DatastoreBuiltinIndex create(Mode mode, WorkflowState workflowState, @Nullable Long updateTimeMicros) {
        return new AutoValue_DatastoreBuiltinIndex(mode, workflowState, updateTimeMicros);
    }

    public static DatastoreBuiltinIndex serving(Mode mode) {
        return DatastoreBuiltinIndex.create(mode, WorkflowState.SERVING);
    }

    public static DatastoreBuiltinIndex serving(Mode mode, Long updateTimeMicros) {
        return DatastoreBuiltinIndex.create(mode, WorkflowState.SERVING, updateTimeMicros);
    }

    public static enum Mode {
        KIND(-1L),
        KIND_SCATTER(-8L),
        ASC(-2L),
        DESC(-3L);

        public final long appliedIndexId;
        private static final ImmutableMap<Long, Mode> APPLIED_INDEX_ID_TO_MODE;

        private Mode(long appliedIndexId) {
            this.appliedIndexId = appliedIndexId;
        }

        @Nullable
        public static Mode fromAppliedIndexId(long appliedIndexId) {
            return APPLIED_INDEX_ID_TO_MODE.get(appliedIndexId);
        }

        static {
            ImmutableMap.Builder<Long, Mode> appliedIndexIdToMapBuilder = ImmutableMap.builder();
            for (Mode mode : Mode.values()) {
                appliedIndexIdToMapBuilder.put(mode.appliedIndexId, mode);
            }
            APPLIED_INDEX_ID_TO_MODE = appliedIndexIdToMapBuilder.build();
        }
    }
}

