/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange_Metadata;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityDiff;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@Beta
@AutoValue
public abstract class EntityChange {
    public abstract EntityRef entityRef();

    @Nullable
    public abstract Entity before();

    @Nullable
    public abstract Entity after();

    public abstract Metadata metadata();

    @Nullable
    public abstract EntityDiff diff();

    public static EntityChange of(EntityRef entityRef, @Nullable Entity before, @Nullable Entity after, Metadata metadata, @Nullable EntityDiff diff) {
        Preconditions.checkArgument(before != null || after != null);
        return new AutoValue_EntityChange(entityRef, before, after, metadata, diff);
    }

    public static EntityChange insert(Entity entity, Long createTime) {
        return EntityChange.of(entity.ref(), null, entity, Metadata.forInsert(createTime), null);
    }

    public static EntityChange delete(Entity entity, Metadata metadata) {
        return EntityChange.of(entity.ref(), entity, null, metadata, null);
    }

    @AutoValue
    public static abstract class Metadata {
        public static final Metadata EMPTY = Metadata.of(null, null, null);

        @Nullable
        public abstract Long createTime();

        @Nullable
        public abstract Long beforeUpdateTime();

        @Nullable
        public abstract Long afterUpdateTime();

        public static Metadata of(Long createTime, Long beforeUpdateTime, Long afterUpdateTime) {
            return new AutoValue_EntityChange_Metadata(createTime, beforeUpdateTime, afterUpdateTime);
        }

        public static Metadata forInsert(@Nullable Long createTimestamp) {
            return Metadata.of(createTimestamp, null, createTimestamp);
        }
    }
}

