/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityChange;
import com.google.cloud.datastore.core.rep.EntityDiff;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import javax.annotation.Nullable;

public final class EntityDiffer {
    private EntityDiffer() {
    }

    @Nullable
    public static EntityDiff diff(@Nullable Entity before, @Nullable Entity after) {
        EntityDiffer.validateDiff(before, after);
        return EntityDiffer.uncheckedDiff(before, after);
    }

    public static EntityChange change(@Nullable Entity before, @Nullable Entity after, EntityChange.Metadata metadata) {
        EntityDiffer.validateDiff(before, after);
        return EntityChange.of(before != null ? before.ref() : after.ref(), before, after, metadata, EntityDiffer.uncheckedDiff(before, after));
    }

    @Nullable
    private static EntityDiff uncheckedDiff(@Nullable Entity before, @Nullable Entity after) {
        if (before == null || after == null) {
            return null;
        }
        return EntityDiffer.nestedDiff(before.propertyMap(), after.propertyMap());
    }

    @Nullable
    public static EntityDiff nestedDiff(ImmutableMap<String, Value> as, ImmutableMap<String, Value> bs) {
        ImmutableMap.Builder<String, EntityDiff.PropertyDiff> propertyDiffs = ImmutableMap.builder();
        for (String key : Sets.union(as.keySet(), bs.keySet())) {
            EntityDiff child;
            Value a = as.get(key);
            Value b = bs.get(key);
            if (a == null) {
                propertyDiffs.put(key, EntityDiff.PropertyDiff.create(b));
                continue;
            }
            if (b == null) {
                propertyDiffs.put(key, EntityDiff.PropertyDiff.delete(a));
                continue;
            }
            if (a.type() == Value.Type.MAP && b.type() == Value.Type.MAP) {
                child = EntityDiffer.nestedDiff(a.asMap(), b.asMap());
                if (child == null) continue;
                propertyDiffs.put(key, EntityDiff.PropertyDiff.ofNested(child));
                continue;
            }
            if (a.type() == Value.Type.ENTITY && b.type() == Value.Type.ENTITY) {
                child = EntityDiffer.nestedDiff(EntityDiffer.entityAsMap(a.asEntity()), EntityDiffer.entityAsMap(b.asEntity()));
                if (child == null) continue;
                propertyDiffs.put(key, EntityDiff.PropertyDiff.ofNested(child));
                continue;
            }
            if (a.equals(b)) continue;
            propertyDiffs.put(key, EntityDiff.PropertyDiff.update(a, b));
        }
        return EntityDiff.create(propertyDiffs.build());
    }

    private static void validateDiff(@Nullable Entity before, @Nullable Entity after) {
        Preconditions.checkArgument(before != null || after != null, "change(null, null) is meaningless");
        Preconditions.checkArgument(before == null || after == null || before.ref().equals(after.ref()), "change(a, b) called on different entities");
    }

    private static ImmutableMap<String, Value> entityAsMap(Entity e) {
        return ImmutableMap.builder().putAll(e.propertyMap()).put(SpecialPropertyDescriptor.KEY.asString(), Value.createEntityRef(e.ref())).build();
    }
}

