/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_Path;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_PathElement;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_ResourceId;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityRef
implements ResourceRef {
    public static final EntityRef EMPTY = EntityRef.createEmpty(PartitionRef.EMPTY);
    public static final int MAX_KEY_PATH_LENGTH = 100;

    public abstract PartitionRef partitionRef();

    public abstract ImmutableList<PathElement> pathElements();

    public Path path() {
        return Path.create(this.pathElements());
    }

    public EntityRef parent() {
        Preconditions.checkState(!this.pathElements().isEmpty());
        int pathSize = this.pathElements().size();
        return EntityRef.create(this.partitionRef(), this.pathElements().subList(0, pathSize - 1));
    }

    public PathElement lastPathElement() {
        Preconditions.checkState(!this.pathElements().isEmpty());
        return Iterables.getLast(this.pathElements());
    }

    public String collectionId() {
        return this.lastPathElement().collectionId();
    }

    @Nullable
    public ResourceId resourceId() {
        return this.lastPathElement().resourceId();
    }

    @CheckReturnValue
    public EntityRef append(PathElement element) {
        return EntityRef.create(this.partitionRef(), this.path().append(element));
    }

    @CheckReturnValue
    public EntityRef truncate(int length) {
        return EntityRef.create(this.partitionRef(), this.pathElements().subList(0, length));
    }

    public static EntityRef createEmpty(PartitionRef partitionRef) {
        return EntityRef.create(partitionRef, Path.EMPTY);
    }

    public static EntityRef create(PartitionRef partitionRef, List<PathElement> path) {
        return new AutoValue_EntityRef(partitionRef, ImmutableList.copyOf(path));
    }

    public static EntityRef create(PartitionRef partitionRef, Path path) {
        return new AutoValue_EntityRef(partitionRef, path.elements());
    }

    public static EntityRef create(PartitionRef partitionRef, PathElement element) {
        return EntityRef.create(partitionRef, ImmutableList.of(element));
    }

    @AutoValue
    public static abstract class Path {
        public static final Path EMPTY = Path.create(ImmutableList.of());

        public abstract ImmutableList<PathElement> elements();

        public static Path create(List<PathElement> elements) {
            return new AutoValue_EntityRef_Path(ImmutableList.copyOf(elements));
        }

        public boolean isEmpty() {
            return this.elements().isEmpty();
        }

        public int size() {
            return this.elements().size();
        }

        public PathElement lastElement() {
            return Iterables.getLast(this.elements());
        }

        public String collectionId() {
            return this.lastElement().collectionId();
        }

        @Nullable
        public ResourceId resourceId() {
            return this.lastElement().resourceId();
        }

        @CheckReturnValue
        public Path append(PathElement element) {
            return Path.create((List<PathElement>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.elements())).add(element)).build()));
        }

        @CheckReturnValue
        public Path concat(Path other) {
            return Path.create((List<PathElement>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.elements())).addAll(other.elements())).build()));
        }

        public Path parent() {
            return Path.create(this.elements().subList(0, this.elements().size() - 1));
        }

        @CheckReturnValue
        public Path truncate(int numElements) {
            if (numElements >= this.size()) {
                return this;
            }
            return Path.create(this.elements().subList(0, numElements));
        }

        public boolean isPrefixOf(Path other) {
            Iterator pi = this.elements().iterator();
            Iterator oi = other.elements().iterator();
            while (pi.hasNext()) {
                if (oi.hasNext() && ((PathElement)pi.next()).isPrefixOf((PathElement)oi.next())) continue;
                return false;
            }
            return true;
        }
    }

    @AutoValue
    public static abstract class PathElement {
        public abstract String collectionId();

        @Nullable
        public abstract ResourceId resourceId();

        public static PathElement create(String collectionId, @Nullable ResourceId resourceId) {
            return new AutoValue_EntityRef_PathElement(collectionId, resourceId);
        }

        public boolean isPrefixOf(PathElement other) {
            return this.equals(other) || this.resourceId() == null && this.collectionId().equals(other.collectionId());
        }
    }

    @AutoValue
    public static abstract class ResourceId {
        @Nullable
        public abstract String asString();

        public abstract long asLong();

        public boolean isLong() {
            return 0L != this.asLong();
        }

        public boolean isString() {
            return this.asString() != null;
        }

        public static ResourceId createString(String stringId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(stringId));
            return new AutoValue_EntityRef_ResourceId(stringId, 0L);
        }

        public static ResourceId createLong(long longId) {
            Preconditions.checkArgument(longId != 0L);
            return new AutoValue_EntityRef_ResourceId(null, longId);
        }
    }
}

