/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_PropertyTransformation;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_PropertyTransformationResult;
import com.google.cloud.datastore.core.rep.AutoValue_EntityTransformation_TransformationResult;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityUpdater;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyMaskHelper;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityTransformation {
    public abstract ImmutableList<PropertyTransformation> propertyTransformations();

    public static EntityTransformation create(ImmutableList<PropertyTransformation> propertyTransformations) {
        Preconditions.checkArgument(!propertyTransformations.isEmpty());
        return new AutoValue_EntityTransformation(propertyTransformations);
    }

    public TransformationResult transformWithUpdater(Entity entity) {
        EntityUpdater updater = EntityUpdater.create(entity);
        ImmutableList.Builder results = ImmutableList.builder();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            results.add(updater.apply(propertyTransformation));
        }
        return TransformationResult.create(updater.toEntity(), (ImmutableList<Value>)results.build());
    }

    public TransformationResult transform(Entity entity) {
        Map<PropertyPath, Value> transformValues = this.originalValues(entity);
        ImmutableList.Builder transformResultSequence = ImmutableList.builder();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            Value previousValue = transformValues.get(propertyTransformation.propertyPath());
            PropertyTransformationResult propertyTransformationResult = propertyTransformation.apply(previousValue);
            transformResultSequence.add(propertyTransformationResult.writeResultValue());
            transformValues.put(propertyTransformation.propertyPath(), propertyTransformationResult.newPropertyValue());
        }
        Entity maskEntity = Entity.create(entity.ref(), transformValues);
        PropertyMask mask = PropertyMaskHelper.convertPathsToMask(transformValues.keySet());
        Entity transformedEntity = mask.entityCopyAndMaskReplace(entity, maskEntity);
        return TransformationResult.create(transformedEntity, (ImmutableList<Value>)transformResultSequence.build());
    }

    private Map<PropertyPath, Value> originalValues(Entity entity) {
        HashMap<PropertyPath, Value> result = new HashMap<PropertyPath, Value>();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            PropertyPath path = propertyTransformation.propertyPath();
            if (result.containsKey(path)) continue;
            result.put(path, path.getFrom(entity.propertyMap()));
        }
        return result;
    }

    @AutoValue
    public static abstract class TransformationResult {
        public abstract Entity transformedEntity();

        public abstract ImmutableList<Value> transformedValues();

        public static TransformationResult create(Entity entity, ImmutableList<Value> values) {
            return new AutoValue_EntityTransformation_TransformationResult(entity, values);
        }
    }

    @AutoValue
    public static abstract class PropertyTransformation {
        public abstract PropertyPath propertyPath();

        abstract Function<Value, PropertyTransformationResult> function();

        public PropertyTransformationResult apply(@Nullable Value originalPropertyValue) {
            return this.function().apply(originalPropertyValue);
        }

        public static PropertyTransformation create(PropertyPath propertyPath, Function<Value, PropertyTransformationResult> function) {
            return new AutoValue_EntityTransformation_PropertyTransformation(Preconditions.checkNotNull(propertyPath), Preconditions.checkNotNull(function));
        }
    }

    @AutoValue
    public static abstract class PropertyTransformationResult {
        public abstract Value newPropertyValue();

        abstract Value writeResultValue();

        public static PropertyTransformationResult create(@Nullable Value newPropertyValue, @Nullable Value writeResultValue) {
            return new AutoValue_EntityTransformation_PropertyTransformationResult(newPropertyValue, writeResultValue);
        }

        public static PropertyTransformationResult create(@Nullable Value newPropertyValue) {
            return new AutoValue_EntityTransformation_PropertyTransformationResult(newPropertyValue, newPropertyValue);
        }
    }
}

