/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexConfiguration;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;

@AutoValue
public abstract class IndexConfiguration {
    public static final IndexConfiguration EMPTY = IndexConfiguration.create(ImmutableList.of(), SingleFieldIndexingConfiguration.EMPTY);

    public abstract ImmutableList<DatastoreBuiltinIndex> datastoreBuiltinIndexes();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    public static IndexConfiguration create(SingleFieldIndexingConfiguration singleFieldIndexing) {
        return IndexConfiguration.create(ImmutableList.of(), singleFieldIndexing);
    }

    public static IndexConfiguration create(ImmutableList<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return new AutoValue_IndexConfiguration(datastoreBuiltins, singleFieldIndexing);
    }

    public IndexConfiguration withUpdates(ImmutableMap<DatastoreBuiltinIndex.Mode, WorkflowState> datastoreBuiltins, ImmutableMap<SingleFieldIndex.Mode, WorkflowState> singleFieldIndexUpdates) {
        ArrayList<SingleFieldIndex> dbIndexes = new ArrayList<SingleFieldIndex>();
        for (Map.Entry entry : singleFieldIndexUpdates.entrySet()) {
            dbIndexes.add(SingleFieldIndex.createDatabaseIndex((SingleFieldIndex.Mode)((Object)entry.getKey()), (WorkflowState)((Object)entry.getValue()), null));
        }
        SingleFieldIndexingRule dbRule = this.singleFieldIndexing().databaseDefaults().updateIndexes(dbIndexes);
        SingleFieldIndexingConfiguration config = this.singleFieldIndexing().updateRule(dbRule);
        return IndexConfiguration.create(this.updatedBuiltins(datastoreBuiltins), config);
    }

    private ImmutableList<DatastoreBuiltinIndex> updatedBuiltins(ImmutableMap<DatastoreBuiltinIndex.Mode, WorkflowState> updates) {
        EnumMap<DatastoreBuiltinIndex.Mode, DatastoreBuiltinIndex> indexMap = new EnumMap<DatastoreBuiltinIndex.Mode, DatastoreBuiltinIndex>(DatastoreBuiltinIndex.Mode.class);
        for (DatastoreBuiltinIndex index : this.datastoreBuiltinIndexes()) {
            indexMap.put(index.mode(), index);
        }
        for (Map.Entry update : updates.entrySet()) {
            WorkflowState state = (WorkflowState)((Object)update.getValue());
            DatastoreBuiltinIndex.Mode mode = (DatastoreBuiltinIndex.Mode)((Object)update.getKey());
            switch (state) {
                case ENABLING: 
                case SERVING: 
                case DISABLING: 
                case CREATED: 
                case NON_SERVING: {
                    if (indexMap.containsKey((Object)mode) && state == ((DatastoreBuiltinIndex)indexMap.get((Object)mode)).workflowState()) break;
                    indexMap.put(mode, DatastoreBuiltinIndex.create(mode, state, null));
                    break;
                }
                case DELETED: {
                    indexMap.remove((Object)mode);
                }
            }
        }
        return ImmutableList.copyOf(indexMap.values());
    }
}

