/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_IndexDef;
import com.google.cloud.datastore.core.rep.AutoValue_IndexDef;
import com.google.cloud.datastore.core.rep.AutoValue_IndexDef_PropertyDef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import javax.annotation.Nullable;

@AutoValue
public abstract class IndexDef {
    public static final IndexDef KEY_ASCENDING = IndexDef.createKeyAscendingIndex();

    private static void checkNoPropertyPathPrecedesNamespace(IndexAncestor indexAncestor, ImmutableList<PropertyDef> propertyDefs) {
        boolean propertyPathMayPrecedeNamespace = indexAncestor != IndexAncestor.NONE;
        for (PropertyDef propertyDef : propertyDefs) {
            PropertyPath propertyPath = propertyDef.path();
            if (propertyPath.equals(ReservedName.KIND.asPropertyPath()) || propertyPath.equals(ReservedName.PROPERTY_PATH.asPropertyPath()) || propertyPath.equals(ReservedName.SCATTER.asPropertyPath())) continue;
            if (propertyPath.equals(ReservedName.NAMESPACE.asPropertyPath())) {
                Preconditions.checkArgument(!propertyPathMayPrecedeNamespace);
                return;
            }
            propertyPathMayPrecedeNamespace = true;
        }
    }

    private static IndexDef createKeyAscendingIndex() {
        return new AutoValue_IndexDef(Query.Semantics.DATASTORE, null, IndexAncestor.NONE, ImmutableList.of());
    }

    public static IndexDef create(@Nullable String kind, boolean isAncestor, ImmutableList<PropertyDef> properties) {
        return IndexDef.create(Query.Semantics.DATASTORE, kind, isAncestor ? IndexAncestor.ANCESTOR : IndexAncestor.NONE, properties);
    }

    public static IndexDef create(Query.Semantics semantics, @Nullable String kind, boolean isAncestor, ImmutableList<PropertyDef> properties) {
        return IndexDef.create(semantics, kind, isAncestor ? IndexAncestor.ANCESTOR : IndexAncestor.NONE, properties);
    }

    public static IndexDef create(@Nullable String kind, IndexAncestor indexAncestor, ImmutableList<PropertyDef> properties) {
        return IndexDef.create(Query.Semantics.DATASTORE, kind, indexAncestor, properties);
    }

    public static IndexDef create(Query.Semantics semantics, @Nullable String kind, IndexAncestor indexAncestor, ImmutableList<PropertyDef> properties) {
        if (properties.isEmpty() && kind == null && semantics.equals((Object)Query.Semantics.DATASTORE)) {
            return KEY_ASCENDING;
        }
        return IndexDef.builder().semantics(semantics).kind(kind).indexAncestor(indexAncestor).propertyDefs(properties).build();
    }

    public boolean isKeyAscending() {
        return this.form() == Form.KEY_ASCENDING;
    }

    public boolean isKindAndKeyAscending() {
        return this.form() == Form.KIND_AND_KEY_ASCENDING;
    }

    public boolean isBuiltinSingleProperty() {
        return this.form() == Form.BUILTIN_SINGLE_PROPERTY;
    }

    public boolean isBuiltinFirestoreCollectionSingleProperty() {
        return this.form() == Form.BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY;
    }

    public boolean isBuiltinFirestoreCollectionGroupSingleProperty() {
        return this.form() == Form.BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY;
    }

    public boolean isUserDefined() {
        return this.form() == Form.USER_DEFINED;
    }

    public boolean isStbti() {
        return !this.geospatialPropertyPaths().isEmpty();
    }

    public Form form() {
        int numProperties = this.propertyDefs().size();
        if (this.semantics().equals((Object)Query.Semantics.FIRESTORE)) {
            boolean isPropertyAndKeyDescending;
            boolean isSinglePropertyAscending = numProperties == 1 && Direction.ASCENDING.equals((Object)((PropertyDef)this.propertyDefs().get(0)).direction());
            boolean bl = isPropertyAndKeyDescending = numProperties == 2 && Direction.DESCENDING.equals((Object)((PropertyDef)this.propertyDefs().get(0)).direction()) && PropertyDef.KEY_DESCENDING.equals(this.propertyDefs().get(1));
            if (isSinglePropertyAscending || isPropertyAndKeyDescending) {
                switch (this.indexAncestor()) {
                    case NONE: {
                        return Form.BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY;
                    }
                    case PARENT: {
                        return Form.BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY;
                    }
                }
            }
            return Form.USER_DEFINED;
        }
        if (this.indexAncestor().equals((Object)IndexAncestor.ANCESTOR) || numProperties > 1) {
            return Form.USER_DEFINED;
        }
        if (numProperties == 0) {
            if (this.kind() == null) {
                return Form.KEY_ASCENDING;
            }
            return Form.KIND_AND_KEY_ASCENDING;
        }
        PropertyDef propertyDef = (PropertyDef)this.propertyDefs().get(0);
        if (propertyDef.mode() == PropertyDef.Mode.GEOSPATIAL) {
            return Form.USER_DEFINED;
        }
        PropertyPath propertyPath = propertyDef.path();
        if (propertyPath.isKey() && propertyDef.direction() == Direction.ASCENDING) {
            return Form.USER_DEFINED;
        }
        if (propertyPath.special().legacyIsPropertyIndexedNormally() && this.indexAncestor().equals((Object)IndexAncestor.NONE)) {
            return Form.BUILTIN_SINGLE_PROPERTY;
        }
        return Form.USER_DEFINED;
    }

    public abstract Query.Semantics semantics();

    @Nullable
    public abstract String kind();

    public boolean appliesToKind(String kind) {
        return Strings.isNullOrEmpty(this.kind()) || this.kind().equals(kind);
    }

    @Deprecated
    public boolean isAncestor() {
        return this.indexAncestor().equals((Object)IndexAncestor.ANCESTOR);
    }

    public boolean hasParentOrAncestor() {
        return this.indexAncestor().equals((Object)IndexAncestor.PARENT) || this.indexAncestor().equals((Object)IndexAncestor.ANCESTOR);
    }

    public abstract IndexAncestor indexAncestor();

    public abstract ImmutableList<PropertyDef> propertyDefs();

    public boolean provides(Query.Semantics desiredQuerySemantics) {
        if (this.isStbti()) {
            return desiredQuerySemantics == Query.Semantics.DATASTORE;
        }
        if (this.isKeyAscending() || this.isKindAndKeyAscending()) {
            return true;
        }
        return this.semantics() == desiredQuerySemantics;
    }

    public boolean containsNamespace() {
        return this.containsProperty(ReservedName.NAMESPACE.asPropertyPath());
    }

    public boolean containsKey() {
        return this.containsProperty(PropertyPath.KEY);
    }

    public boolean containsKind() {
        return !Strings.isNullOrEmpty(this.kind()) || this.containsProperty(PropertyPath.KIND);
    }

    public boolean containsParent() {
        return this.indexAncestor().equals((Object)IndexAncestor.PARENT) || this.containsProperty(ReservedName.PARENT_KEY.asPropertyPath());
    }

    private boolean containsProperty(PropertyPath propertyPath) {
        for (PropertyDef propertyDef : this.propertyDefs()) {
            PropertyPath path = propertyDef.path();
            if (!path.equals(propertyPath)) continue;
            return true;
        }
        return false;
    }

    public IndexDef normalized() {
        if (!this.propertyDefs().isEmpty()) {
            PropertyDef last = Iterables.getLast(this.propertyDefs());
            if (last.equals(PropertyDef.KEY_ASCENDING)) {
                return IndexDef.builder().semantics(this.semantics()).kind(this.kind()).indexAncestor(this.indexAncestor()).propertyDefs((ImmutableList<PropertyDef>)this.propertyDefs().subList(0, this.propertyDefs().size() - 1)).build();
            }
            if (this.semantics() == Query.Semantics.FIRESTORE && Direction.DESCENDING.equals((Object)last.direction()) && !last.path().isKey()) {
                return IndexDef.builder().semantics(this.semantics()).kind(this.kind()).indexAncestor(this.indexAncestor()).propertyDefs((ImmutableList<PropertyDef>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.propertyDefs())).add(PropertyDef.KEY_DESCENDING)).build()).build();
            }
        }
        return this;
    }

    public ImmutableSet<PropertyPath> equalityPropertyPaths() {
        ImmutableSet.Builder equalityPropertyPathsBuilder = ImmutableSet.builder();
        for (PropertyDef propertyDef : this.propertyDefs()) {
            if (propertyDef.mode() != PropertyDef.Mode.EQUALITY) continue;
            equalityPropertyPathsBuilder.add(propertyDef.path());
        }
        return equalityPropertyPathsBuilder.build();
    }

    public ImmutableSet<PropertyPath> geospatialPropertyPaths() {
        ImmutableSet.Builder geospatialPropertyPathsBuilder = ImmutableSet.builder();
        for (PropertyDef propertyDef : this.propertyDefs()) {
            if (propertyDef.mode() != PropertyDef.Mode.GEOSPATIAL) continue;
            geospatialPropertyPathsBuilder.add(propertyDef.path());
        }
        return geospatialPropertyPathsBuilder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_IndexDef.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder semantics(Query.Semantics var1);

        public abstract Builder kind(@Nullable String var1);

        public abstract Builder indexAncestor(IndexAncestor var1);

        public abstract ImmutableList.Builder<PropertyDef> propertyDefsBuilder();

        public abstract Builder propertyDefs(ImmutableList<PropertyDef> var1);

        public Builder propertyDefs(PropertyDef ... propertyDefs) {
            return this.propertyDefs(ImmutableList.copyOf(propertyDefs));
        }

        abstract IndexDef autoBuild();

        public IndexDef build() {
            IndexDef indexDef = this.autoBuild();
            IndexDef.checkNoPropertyPathPrecedesNamespace(indexDef.indexAncestor(), indexDef.propertyDefs());
            return indexDef;
        }
    }

    public static enum IndexAncestor {
        NONE,
        ANCESTOR,
        PARENT;

    }

    public static enum Form {
        KEY_ASCENDING,
        KIND_AND_KEY_ASCENDING,
        BUILTIN_SINGLE_PROPERTY,
        BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY,
        BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY,
        USER_DEFINED;

    }

    @AutoValue
    public static abstract class PropertyDef {
        public static final PropertyDef KEY_ASCENDING = PropertyDef.ascending(PropertyPath.KEY);
        public static final PropertyDef KEY_DESCENDING = PropertyDef.descending(PropertyPath.KEY);
        public static final Comparator<PropertyDef> PATH_COMPARATOR = Comparator.comparing(PropertyDef::path);

        public abstract PropertyPath path();

        public abstract Mode mode();

        @Nullable
        public abstract Direction direction();

        public static PropertyDef create(PropertyPath path, Mode mode, @Nullable Direction direction) {
            Preconditions.checkArgument(mode == Mode.ORDERED != (direction == null));
            return new AutoValue_IndexDef_PropertyDef(path, mode, direction);
        }

        public static PropertyDef ordered(PropertyPath path, Direction direction) {
            return PropertyDef.create(path, Mode.ORDERED, direction);
        }

        public static PropertyDef ascending(PropertyPath path) {
            return PropertyDef.create(path, Mode.ORDERED, Direction.ASCENDING);
        }

        public static PropertyDef descending(PropertyPath path) {
            return PropertyDef.create(path, Mode.ORDERED, Direction.DESCENDING);
        }

        public static enum Mode {
            GEOSPATIAL,
            EQUALITY,
            ORDERED;

        }
    }
}

