/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Objects;
import javax.annotation.Nullable;

public final class IndexEntry {
    private final Index index;
    private final ImmutableList<IndexValueAndRemainder> values;
    @Nullable
    private final EntityRef ref;
    @Nullable
    private final OnestoreEntity.CompositeProperty compositeProperty;

    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, EntityRef ref) {
        this.index = Preconditions.checkNotNull(index);
        this.values = Preconditions.checkNotNull(values);
        this.ref = Preconditions.checkNotNull(ref);
        this.compositeProperty = null;
    }

    @Deprecated
    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, @Nullable EntityRef ref, @Nullable OnestoreEntity.CompositeProperty compositeProperty) {
        this.index = index;
        this.values = values;
        this.ref = ref;
        this.compositeProperty = compositeProperty;
    }

    public Index index() {
        return this.index;
    }

    public ImmutableList<IndexValueAndRemainder> values() {
        return this.values;
    }

    @Nullable
    public OnestoreEntity.CompositeProperty compositeProperty() {
        return this.compositeProperty;
    }

    @Nullable
    public EntityRef entityRef() {
        return this.ref;
    }

    @Deprecated
    @Nullable
    public ImmutableList<IndexValueAndRemainder> getSingleFieldIndexValue() {
        if (this.index.isFirestoreSingleField()) {
            return ImmutableList.of(IndexEntry.dropContainsMark((IndexValueAndRemainder)this.values.get(1)), (IndexValueAndRemainder)this.values.get(3), (IndexValueAndRemainder)this.values.get(4));
        }
        return null;
    }

    private static IndexValueAndRemainder dropContainsMark(IndexValueAndRemainder value) {
        int lastIndexArrayElementIndex;
        IndexValue last;
        ImmutableList<IndexValue> indexArray;
        UnifiedIndexValue unifiedIndexValue = value.unifiedIndexValue();
        if (unifiedIndexValue.isAppEngV3()) {
            return value;
        }
        IndexValue indexValue = unifiedIndexValue.indexValue();
        if (indexValue.type() == IndexValue.Type.ARRAY && !(indexArray = indexValue.asArray()).isEmpty() && (last = (IndexValue)indexArray.get(lastIndexArrayElementIndex = indexArray.size() - 1)).equals(IndexValue.NULL)) {
            IndexValue newIndexValue = IndexValue.createArray(false, ImmutableList.copyOf(indexArray.subList(0, lastIndexArrayElementIndex)));
            return IndexValueAndRemainder.createForFirestore(newIndexValue);
        }
        return value;
    }

    public int billedSize() {
        switch (this.index.definition().form()) {
            case KEY_ASCENDING: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize();
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize();
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(false, false, false);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(false, false, false);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public int storageSize() {
        switch (this.index.definition().form()) {
            case KEY_ASCENDING: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize();
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize();
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(true, true, true);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(true, true, true);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private int builtinKindNaturalSize() {
        Preconditions.checkState(this.index.definition().isKindAndKeyAscending());
        return 32 + EntitySize.entityRefSize(this.ref) + EntitySize.stringSize(this.ref.collectionId());
    }

    private int builtinPropertyNaturalSize() {
        Preconditions.checkState(this.index.definition().isBuiltinSingleProperty());
        IndexDef.PropertyDef builtinPropertyDef = (IndexDef.PropertyDef)this.index.definition().propertyDefs().get(0);
        IndexValueAndRemainder builtinIndexValueAndRemainder = (IndexValueAndRemainder)this.values().get(0);
        return 32 + EntitySize.entityRefSize(this.ref) + EntitySize.stringSize(this.ref.collectionId()) + EntitySize.propertyPathSize(builtinPropertyDef.path()) + builtinIndexValueAndRemainder.naturalSize();
    }

    private int firestoreCollectionNaturalSize(boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState(this.index.definition().isBuiltinFirestoreCollectionSingleProperty());
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index.definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(this.ref.collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(this.ref.partitionRef().namespace()) : 0) + EntitySize.entityRefSize(this.ref) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + EntitySize.entityRefSize(this.ref.parent()) + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValueAndRemainder)this.values().get(1)).naturalSize();
    }

    private int firestoreCollectionGroupNaturalSize(boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState(this.index.definition().isBuiltinFirestoreCollectionGroupSingleProperty());
        int rootAncestorSize = EntitySize.entityRefSize(EntityRef.createEmpty(this.ref.partitionRef()));
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index.definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(this.ref.collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(this.ref.partitionRef().namespace()) : 0) + EntitySize.entityRefSize(this.ref) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + rootAncestorSize + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValueAndRemainder)this.values().get(0)).naturalSize();
    }

    private int userDefinedNaturalSize(boolean includeKeyDescending) {
        Preconditions.checkState(this.index.definition().isUserDefined());
        int indexFieldValueSum = 0;
        boolean hasKeyDescending = IndexDef.PropertyDef.KEY_DESCENDING.equals(Iterables.getLast(this.index.definition().propertyDefs(), null));
        int numIndexValues = hasKeyDescending && !includeKeyDescending ? this.values().size() - 1 : this.values.size();
        for (IndexValueAndRemainder indexValueAndRemainder : this.values().subList(0, numIndexValues)) {
            indexFieldValueSum += indexValueAndRemainder.naturalSize();
        }
        return 32 + EntitySize.entityRefSize(this.ref) + indexFieldValueSum;
    }

    @Deprecated
    public int naturalSize() {
        int resultSize = 0;
        ImmutableList<IndexValueAndRemainder> indexValueAndRemainders = this.getSingleFieldIndexValue();
        if (indexValueAndRemainders == null) {
            indexValueAndRemainders = this.values;
        }
        for (IndexValueAndRemainder indexValueAndRemainder : indexValueAndRemainders) {
            resultSize += indexValueAndRemainder.naturalSize();
        }
        return resultSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("values", this.values).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IndexEntry)) {
            return false;
        }
        IndexEntry that = (IndexEntry)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.values, that.values) && Objects.equals(this.ref, that.ref);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.values, this.ref);
    }
}

