/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.util.Map;
import javax.annotation.Nullable;

public class IndexValue {
    public static final int NULL_NATURAL_SIZE = 1;
    public static final int BOOLEAN_NATURAL_SIZE = 1;
    public static final int NUMBER_NATURAL_SIZE = 8;
    public static final int TIMESTAMP_NATURAL_SIZE = 8;
    public static final int GEO_POINT_NATURAL_SIZE = 16;
    public static final int STRING_BASE_NATURAL_SIZE = 1;
    public static final int ENTITY_REF_BASE_NATURAL_SIZE = 16;
    private static final Object NO_BOXED_OBJECT = new Object();
    public static final IndexValue ABSENT = new IndexValue();
    public static final IndexValue NULL = new IndexValue(Type.NULL, -2401018188504514833L, false, 1);
    public static final IndexValue NAN = new IndexValue(Type.NUMBER, Double.doubleToRawLongBits(Double.NaN), true, 8);
    public static final IndexValue FALSE = new IndexValue(Type.BOOLEAN, 0L, false, 1);
    public static final IndexValue TRUE = new IndexValue(Type.BOOLEAN, 1L, false, 1);
    public static final IndexValue EMPTY_STRING = IndexValue.createString(false, "");
    public static final IndexValue EMPTY_ARRAY = IndexValue.createArray(false, ImmutableList.of());
    public static final IndexValue EMPTY_MAP = IndexValue.createMap(false, ImmutableMap.of());
    private final boolean isDeepTruncated;
    private final boolean isShallowTruncated;
    private final boolean isNumberDouble;
    private final int naturalSize;
    private final Type type;
    private final long unboxed;
    private final Object boxed;

    public static IndexValue createBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static IndexValue createNumberLong(long x) {
        return new IndexValue(Type.NUMBER, x, false, 8);
    }

    public static IndexValue createNumberDouble(double x) {
        return new IndexValue(Type.NUMBER, Double.doubleToRawLongBits(x), true, 8);
    }

    public static IndexValue createTimestamp(Timestamp x) {
        return new IndexValue(Type.TIMESTAMP, x, 8);
    }

    public static IndexValue createString(boolean isTruncated, String x) {
        return new IndexValue(isTruncated, Type.STRING, x, IndexValue.computeStringNaturalSize(x));
    }

    private static int computeStringNaturalSize(String string) {
        return 1 + Utf8.encodedLength(string);
    }

    public static IndexValue createBytes(boolean isTruncated, ByteString x) {
        Preconditions.checkArgument(!isTruncated || !x.isEmpty());
        return new IndexValue(isTruncated, Type.BYTES, x, x.size());
    }

    public static IndexValue createEntityRef(EntityRef x) {
        return new IndexValue(x.namespaceId.isDeepTruncated() || x.segments.isDeepTruncated(), false, Type.ENTITY_REF, x, IndexValue.computeEntityRefNaturalSize(x));
    }

    private static int computeEntityRefNaturalSize(EntityRef indexValueEntityRef) {
        int namespaceIdNaturalSize = indexValueEntityRef.namespaceId.equals(EMPTY_STRING) ? 0 : indexValueEntityRef.namespaceId.naturalSize();
        return 16 + namespaceIdNaturalSize + indexValueEntityRef.segments.naturalSize();
    }

    public static IndexValue createGeoPoint(LatLng x) {
        return new IndexValue(Type.GEO_POINT, x, 16);
    }

    public static IndexValue createArray(boolean isShallowTruncated, ImmutableList<IndexValue> x) {
        ImmutableList<IndexValue> elements = x;
        int numElements = elements.size();
        int naturalSize = 0;
        Preconditions.checkArgument(!isShallowTruncated || numElements != 0);
        boolean isDeepTruncated = isShallowTruncated;
        for (int index = 0; index < numElements; ++index) {
            IndexValue element = (IndexValue)elements.get(index);
            if (element.isDeepTruncated()) {
                Preconditions.checkArgument(index == numElements - 1);
                Preconditions.checkArgument(!isShallowTruncated);
                Preconditions.checkArgument(!element.isAbsent());
                isDeepTruncated = true;
            }
            naturalSize += element.naturalSize();
        }
        return new IndexValue(isDeepTruncated, isShallowTruncated, Type.ARRAY, x, naturalSize);
    }

    public static IndexValue createMap(boolean isShallowTruncated, ImmutableMap<IndexValue, IndexValue> x) {
        ImmutableMap<IndexValue, IndexValue> map = x;
        int naturalSize = 0;
        IndexValue prevKeyIndexValue = null;
        IndexValue prevValueIndexValue = null;
        for (Map.Entry entry : map.entrySet()) {
            IndexValue keyIndexValue = (IndexValue)entry.getKey();
            IndexValue valueIndexValue = (IndexValue)entry.getValue();
            naturalSize += keyIndexValue.naturalSize() + valueIndexValue.naturalSize();
            if (prevKeyIndexValue != null) {
                Preconditions.checkArgument(!prevKeyIndexValue.isDeepTruncated());
                Preconditions.checkArgument(!prevValueIndexValue.isDeepTruncated());
            }
            prevKeyIndexValue = keyIndexValue;
            prevValueIndexValue = valueIndexValue;
        }
        boolean isDeepTruncated = isShallowTruncated;
        if (prevKeyIndexValue == null) {
            Preconditions.checkArgument(!isShallowTruncated);
        } else if (isShallowTruncated) {
            Preconditions.checkArgument(!prevKeyIndexValue.isDeepTruncated());
            Preconditions.checkArgument(!prevValueIndexValue.isDeepTruncated());
        } else if (prevKeyIndexValue.isDeepTruncated()) {
            Preconditions.checkArgument(prevValueIndexValue.isAbsent());
            isDeepTruncated = true;
        } else {
            isDeepTruncated = prevValueIndexValue.isDeepTruncated();
        }
        return new IndexValue(isDeepTruncated, isShallowTruncated, Type.MAP, x, naturalSize);
    }

    public static IndexValue createLegacyUser(Value.LegacyUser x) {
        int naturalSize = EntitySize.legacyUserSize(x);
        return new IndexValue(Type.LEGACY_USER, x, naturalSize);
    }

    private IndexValue() {
        this.isDeepTruncated = true;
        this.isShallowTruncated = true;
        this.type = Type.ABSENT_TYPE;
        this.unboxed = -2401053088876216593L;
        this.boxed = NO_BOXED_OBJECT;
        this.isNumberDouble = false;
        this.naturalSize = 0;
    }

    private IndexValue(Type type, long unboxed, boolean isNumberDouble, int naturalSize) {
        this.isDeepTruncated = false;
        this.isShallowTruncated = false;
        this.type = type;
        this.unboxed = unboxed;
        this.boxed = NO_BOXED_OBJECT;
        this.isNumberDouble = isNumberDouble;
        this.naturalSize = naturalSize;
    }

    private IndexValue(Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = false;
        this.isShallowTruncated = false;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    private IndexValue(boolean isTruncated, Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = isTruncated;
        this.isShallowTruncated = isTruncated;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    private IndexValue(boolean isDeepTruncated, boolean isShallowTruncated, Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = isDeepTruncated;
        this.isShallowTruncated = isShallowTruncated;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    public Type type() {
        return this.type;
    }

    public boolean isAbsent() {
        return this == ABSENT;
    }

    public boolean isShallowTruncated() {
        return this.isShallowTruncated;
    }

    public boolean isDeepTruncated() {
        return this.isDeepTruncated;
    }

    public int naturalSize() {
        return this.naturalSize;
    }

    public boolean asBoolean() {
        Preconditions.checkState(this.type == Type.BOOLEAN);
        return this.unboxed != 0L;
    }

    public boolean isNumberDouble() {
        return this.isNumberDouble;
    }

    public long asNumberLong() {
        Preconditions.checkState(this.type == Type.NUMBER);
        Preconditions.checkState(!this.isNumberDouble);
        return this.unboxed;
    }

    public double asNumberDouble() {
        Preconditions.checkState(this.type == Type.NUMBER);
        Preconditions.checkState(this.isNumberDouble);
        return Double.longBitsToDouble(this.unboxed);
    }

    public Timestamp asTimestamp() {
        return (Timestamp)this.boxed;
    }

    public String asString() {
        return (String)this.boxed;
    }

    public ByteString asBytes() {
        return (ByteString)this.boxed;
    }

    public EntityRef asEntityRef() {
        return (EntityRef)this.boxed;
    }

    public LatLng asGeoPoint() {
        return (LatLng)this.boxed;
    }

    public ImmutableList<IndexValue> asArray() {
        return (ImmutableList)this.boxed;
    }

    public ImmutableMap<IndexValue, IndexValue> asMap() {
        return (ImmutableMap)this.boxed;
    }

    public Value.LegacyUser asLegacyUser() {
        return (Value.LegacyUser)this.boxed;
    }

    @VisibleForTesting
    public IndexValue truncate() {
        Preconditions.checkState(!this.isDeepTruncated());
        switch (this.type) {
            case STRING: {
                return IndexValue.createString(true, this.asString());
            }
            case BYTES: {
                return IndexValue.createBytes(true, this.asBytes());
            }
            case ARRAY: {
                ImmutableList<IndexValue> array = this.asArray();
                Preconditions.checkState(!array.isEmpty());
                return IndexValue.createArray(true, array);
            }
            case MAP: {
                ImmutableMap<IndexValue, IndexValue> map = this.asMap();
                Preconditions.checkState(!map.isEmpty());
                return IndexValue.createMap(true, map);
            }
            case ENTITY_REF: {
                EntityRef entityRef = this.asEntityRef();
                IndexValue truncatedSegments = entityRef.segments.asArray().isEmpty() ? ABSENT : entityRef.segments.truncate();
                EntityRef truncatedEntityRef = new EntityRef(entityRef.databaseRef, entityRef.namespaceId, truncatedSegments);
                return IndexValue.createEntityRef(truncatedEntityRef);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof IndexValue)) {
            return false;
        }
        IndexValue other = (IndexValue)otherObject;
        return this.type == other.type && this.isDeepTruncated == other.isDeepTruncated && this.isShallowTruncated == other.isShallowTruncated && this.isNumberDouble == other.isNumberDouble && this.unboxed == other.unboxed && this.boxed.equals(other.boxed);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.isDeepTruncated, this.isShallowTruncated, this.type, this.isNumberDouble, this.unboxed, this.boxed});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{IndexValue: ");
        if (this.type != null) {
            switch (this.type) {
                case ABSENT_TYPE: {
                    return "<absent>";
                }
                case NULL: {
                    stringBuilder.append("null");
                    break;
                }
                case BOOLEAN: {
                    stringBuilder.append(this.asBoolean());
                    break;
                }
                case NUMBER: {
                    if (this.isNumberDouble) {
                        stringBuilder.append(this.asNumberDouble());
                        break;
                    }
                    stringBuilder.append(this.asNumberLong());
                    break;
                }
                case TIMESTAMP: {
                    stringBuilder.append(this.asTimestamp());
                    break;
                }
                case ENTITY_REF: {
                    stringBuilder.append(this.asEntityRef());
                    break;
                }
                case STRING: {
                    stringBuilder.append(this.asString());
                    break;
                }
                case BYTES: {
                    stringBuilder.append(this.asBytes());
                    break;
                }
                case GEO_POINT: {
                    stringBuilder.append(this.asGeoPoint());
                    break;
                }
                case ARRAY: {
                    stringBuilder.append(this.asArray());
                    break;
                }
                case MAP: {
                    stringBuilder.append(this.asMap());
                    break;
                }
                case LEGACY_USER: {
                    stringBuilder.append(this.asLegacyUser());
                }
            }
        }
        if (this.isShallowTruncated) {
            stringBuilder.append(" (truncated)");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class EntityRef {
        public static final EntityRef EMPTY = new EntityRef(DatabaseRef.EMPTY, EMPTY_STRING, EMPTY_ARRAY);
        public final DatabaseRef databaseRef;
        public final IndexValue namespaceId;
        public final IndexValue segments;

        public EntityRef(DatabaseRef databaseRef, IndexValue namespaceId, IndexValue segments) {
            if (!segments.isAbsent()) {
                Preconditions.checkArgument(!namespaceId.isShallowTruncated());
                EntityRef.checkSegments(segments);
            }
            this.databaseRef = databaseRef;
            this.namespaceId = namespaceId;
            this.segments = Preconditions.checkNotNull(segments);
        }

        private static void checkSegments(IndexValue segments) {
            Preconditions.checkArgument(segments.type() == Type.ARRAY);
            ImmutableList<IndexValue> segmentsList = segments.asArray();
            int numSegments = segmentsList.size();
            block4: for (int index = 0; index < numSegments; ++index) {
                IndexValue segment = (IndexValue)segmentsList.get(index);
                switch (segment.type()) {
                    case NUMBER: {
                        Preconditions.checkArgument(index % 2 == 1);
                        Preconditions.checkArgument(!segment.isNumberDouble());
                        continue block4;
                    }
                    case STRING: {
                        if (!segment.isShallowTruncated()) continue block4;
                        Preconditions.checkArgument(index == numSegments - 1);
                        Preconditions.checkArgument(!segments.isShallowTruncated());
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }

        @Nullable
        public IndexValue collectionId() {
            if (this.segments.isAbsent()) {
                return null;
            }
            ImmutableList<IndexValue> segmentsList = this.segments.asArray();
            if (segmentsList.isEmpty()) {
                return null;
            }
            int collectionIdIndex = segmentsList.size() - 1 & 0xFFFFFFFE;
            return (IndexValue)segmentsList.get(collectionIdIndex);
        }

        public EntityRef parent() {
            Preconditions.checkArgument(!this.namespaceId.isDeepTruncated());
            Preconditions.checkArgument(!this.segments.isDeepTruncated());
            ImmutableList<IndexValue> segmentsList = this.segments.asArray();
            int numSegments = segmentsList.size();
            Preconditions.checkArgument(numSegments % 2 == 0);
            int numParentSegments = numSegments - 2;
            Preconditions.checkArgument(numParentSegments >= 0);
            IndexValue parentSegments = numParentSegments == 0 ? EMPTY_ARRAY : IndexValue.createArray(false, (ImmutableList<IndexValue>)segmentsList.subList(0, numParentSegments));
            return new EntityRef(this.databaseRef, this.namespaceId, parentSegments);
        }

        public boolean equals(Object otherObject) {
            if (!(otherObject instanceof EntityRef)) {
                return false;
            }
            EntityRef other = (EntityRef)otherObject;
            return this.databaseRef.equals(other.databaseRef) && this.namespaceId.equals(other.namespaceId) && this.segments.equals(other.segments);
        }

        public int hashCode() {
            return Objects.hashCode(this.databaseRef, this.namespaceId, this.segments);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("index-entity-ref: {databaseRef: ");
            stringBuilder.append(this.databaseRef);
            if (!this.namespaceId.isAbsent()) {
                stringBuilder.append(", namespaceId: ");
                stringBuilder.append(this.namespaceId);
            }
            if (!this.segments.isAbsent()) {
                stringBuilder.append(", segments: ");
                stringBuilder.append(this.segments);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static enum Type {
        ABSENT_TYPE,
        NULL,
        BOOLEAN,
        NUMBER,
        TIMESTAMP,
        STRING,
        BYTES,
        ENTITY_REF,
        GEO_POINT,
        ARRAY,
        MAP,
        LEGACY_USER;


        public int firestoreOrderNum() {
            return this.ordinal();
        }
    }
}

