/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_KindIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.KindIndexGroupSubset;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.internal.StorageFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@AutoValue
public abstract class KindIndexGroup {
    public static final KindIndexGroup EMPTY = KindIndexGroup.create(null, ImmutableList.of());
    @GuardedBy(value="this")
    private final Map<IndexSubsetSpec, ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>> compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap = new EnumMap<IndexSubsetSpec, ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>>(IndexSubsetSpec.class);

    public static boolean workflowStateInSubsetSpec(IndexSubsetSpec subsetSpec, @Nullable WorkflowState state) {
        if (state == null) {
            return false;
        }
        switch (subsetSpec) {
            case READ: {
                return state == WorkflowState.SERVING;
            }
            case WRITE: {
                return state.write();
            }
            case REPORT: {
                return state != WorkflowState.DELETED;
            }
            case FULLY_APPLIED: {
                return state == WorkflowState.SERVING || state == WorkflowState.NON_SERVING;
            }
            case PARTIALLY_OR_FULLY_APPLIED: {
                return state.write() || state.finalizing();
            }
        }
        throw new IllegalArgumentException("Unknown IndexSubsetSpec.");
    }

    public static ImmutableList<Index> extractScannerWriteIndexes(ImmutableList<Index> indexes) {
        ImmutableList.Builder scannerWriteIndexesBuilder = ImmutableList.builder();
        for (Index index : indexes) {
            IndexDef indexDef = index.definition();
            if (!index.writing() || indexDef.isBuiltinSingleProperty() || indexDef.isStbti()) continue;
            scannerWriteIndexesBuilder.add(index);
        }
        return scannerWriteIndexesBuilder.build();
    }

    @Nullable
    public abstract String kind();

    public abstract ImmutableList<Index> allCompositeIndexes();

    public abstract ImmutableList<DatastoreBuiltinIndex> datastoreBuiltinIndexes();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    protected abstract ImmutableMap<IndexSubsetSpec, KindIndexGroupSubset> subsets();

    public KindIndexGroupSubset subset(IndexSubsetSpec spec) {
        return this.subsets().get((Object)spec);
    }

    public ImmutableList<Index> firestoreScannerIndexes(IndexSubsetSpec spec) {
        return this.subset(spec).firestoreCompositeIndexes().asList();
    }

    public ImmutableList<Index> datastoreScannerIndexes(IndexSubsetSpec spec) {
        return this.subset(spec).datastoreCompositeIndexes().asList();
    }

    public ImmutableList<Index> scannerIndexes(IndexSubsetSpec subsetSpec) {
        return this.scannerIndexes(subsetSpec, ImmutableSet.of());
    }

    private ImmutableList<Index> scannerIndexes(IndexSubsetSpec subsetSpec, Set<DatastoreBuiltinIndex.Mode> builtinIndexes) {
        KindIndexGroupSubset subset = this.subset(subsetSpec);
        if (!builtinIndexes.contains((Object)DatastoreBuiltinIndex.Mode.KIND_SCATTER)) {
            return subset.compositeIndexes().asList();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(subset.compositeIndexes());
        result.add(KindIndexGroup.makeMaterializedKindScatterIndex(this.kind()));
        return result.build();
    }

    public ImmutableList<Index> scannerIndexesWithScatter(IndexSubsetSpec subsetSpec) {
        return this.scannerIndexes(subsetSpec, this.datastoreBuiltins(IndexSubsetSpec.READ));
    }

    public ImmutableList<Index> stbtiIndexes(IndexSubsetSpec subsetSpec) {
        return this.subset(subsetSpec).stbtiIndexes().asList();
    }

    public ImmutableSet<DatastoreBuiltinIndex.Mode> datastoreBuiltins(IndexSubsetSpec spec) {
        return this.subset(spec).datastoreBuiltins();
    }

    @Nullable
    public ImmutableMap<PropertyPath, ImmutableMap<SingleFieldIndex.Mode, IndexState>> predeterminedPropertyPathToSinglePropertyIndexModes(IndexSubsetSpec indexSubsetSpec) {
        return null;
    }

    public synchronized ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode> compositeIndexPropertyPathToSinglePropertyIndexModes(IndexSubsetSpec indexSubsetSpec) {
        ImmutableMultimap result = this.compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap.get((Object)indexSubsetSpec);
        if (result != null) {
            return result;
        }
        ImmutableSetMultimap.Builder multimapBuilder = ImmutableSetMultimap.builder();
        for (Index index : this.scannerIndexes(indexSubsetSpec)) {
            if (index.id() < 0L) continue;
            block4: for (IndexDef.PropertyDef indexPropertyDef : index.definition().propertyDefs()) {
                if (indexPropertyDef.mode() != IndexDef.PropertyDef.Mode.ORDERED) continue;
                PropertyPath propertyPath = indexPropertyDef.path();
                switch (propertyPath.special()) {
                    case KEY: 
                    case KIND: {
                        continue block4;
                    }
                }
                if (propertyPath.isArrayElements()) {
                    PropertyPath effectivePropertyPath = propertyPath.dropLastPathSegment();
                    multimapBuilder.put(effectivePropertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_CONTAINS);
                    continue;
                }
                multimapBuilder.put(propertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_ASC);
                multimapBuilder.put(propertyPath, (Object)SingleFieldIndex.Mode.COLLECTION_DESC);
            }
        }
        result = multimapBuilder.build();
        this.compositeIndexPropertyPathToSinglePropertyIndexModesMemoMap.put(indexSubsetSpec, (ImmutableSetMultimap<PropertyPath, SingleFieldIndex.Mode>)result);
        return result;
    }

    private static Index makeMaterializedKindScatterIndex(String kind) {
        IndexDef indexDef = IndexDef.create(Query.Semantics.DATASTORE, kind, IndexDef.IndexAncestor.NONE, ImmutableList.of(IndexDef.PropertyDef.ascending(PropertyPath.SCATTER)));
        return Index.builder().id(0L).builtinIndexId(Optional.of(StorageFormat.BuiltinIndexId.KIND_SCATTER)).workflowState(WorkflowState.SERVING, false).definition(indexDef).storageVersion(Index.StorageVersion.V1).build();
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableList<Index> compositeIndexes) {
        return KindIndexGroup.create(kind, compositeIndexes, ImmutableList.of(), SingleFieldIndexingConfiguration.EMPTY);
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableList<Index> compositeIndexes, ImmutableList<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        ImmutableMap.Builder<IndexSubsetSpec, KindIndexGroupSubset> subspecViews = ImmutableMap.builder();
        for (IndexSubsetSpec subsetSpec : IndexSubsetSpec.values()) {
            subspecViews.put(subsetSpec, KindIndexGroupSubset.precompute(kind, subsetSpec, singleFieldIndexing, datastoreBuiltins, compositeIndexes));
        }
        return new AutoValue_KindIndexGroup(kind, compositeIndexes, datastoreBuiltins, singleFieldIndexing, subspecViews.build());
    }

    public static enum IndexSubsetSpec {
        REPORT,
        WRITE,
        READ,
        FULLY_APPLIED,
        PARTIALLY_OR_FULLY_APPLIED;

    }
}

