/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class MutationHelper {
    static final ImmutableTable<Mutation.Op, Mutation.Op, Mutation.Op> OPERATION_COLLAPSES;

    private static Mutation.ExistencePrecondition existenceAfter(Mutation.Op op) {
        switch (op.operation) {
            case WRITE: {
                return Mutation.ExistencePrecondition.MUST_EXIST;
            }
            case DELETE: {
                return Mutation.ExistencePrecondition.MUST_NOT_EXIST;
            }
            case VERIFY: {
                return op.existence;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static Mutation collapse(Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        Mutation.Op op1 = mutation1.op();
        Mutation.Op op2 = mutation2.op();
        OnestoreEntity.Reference key1 = mutation1.key();
        OnestoreEntity.Reference key2 = mutation2.key();
        List<Mutation> subMutations1 = mutation1.subMutations();
        List<Mutation> subMutations2 = mutation2.subMutations();
        ArrayList<Mutation> newSubMutations = new ArrayList<Mutation>();
        newSubMutations.addAll(subMutations1);
        newSubMutations.addAll(subMutations2);
        EntityTransformation entityTransformation1 = mutation1.transformation();
        EntityTransformation entityTransformation2 = mutation2.transformation();
        Long baseVersion1 = mutation1.baseVersion();
        Long baseVersion2 = mutation2.baseVersion();
        Mutation.ConflictResolutionStrategy resolutionStrategy1 = mutation1.conflictResolutionStrategy();
        Mutation.ConflictResolutionStrategy resolutionStrategy2 = mutation2.conflictResolutionStrategy();
        Preconditions.checkArgument(!V3Paths.hasIncompleteLastElement(key1), "cannot collapse mutation with incomplete key");
        Preconditions.checkArgument(!V3Paths.hasIncompleteLastElement(key2), "cannot collapse mutation with incomplete key");
        Preconditions.checkArgument(key1.equals(key2), "cannot collapse mutations with different keys");
        EntityTransformation newEntityTransformation = mutation2.transformation();
        if (entityTransformation1 != null) {
            if (entityTransformation2 == null) {
                newEntityTransformation = mutation1.transformation();
            } else {
                ImmutableList.Builder newTransformations = ImmutableList.builder();
                newTransformations.addAll(mutation1.transformation().propertyTransformations());
                newTransformations.addAll(mutation2.transformation().propertyTransformations());
                newEntityTransformation = EntityTransformation.create((ImmutableList<EntityTransformation.PropertyTransformation>)newTransformations.build());
            }
        }
        InvalidConversionException.checkConversion(mutation1.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        InvalidConversionException.checkConversion(mutation2.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        Mutation.Op collapsedOp = (Mutation.Op)((Object)OPERATION_COLLAPSES.get((Object)op1, (Object)op2));
        InvalidConversionException.checkConversion(collapsedOp != null, "Cannot %s then %s an entity in the same request.", MutationHelper.opNameForErrorMessage(mutation1), MutationHelper.opNameForErrorMessage(mutation2));
        InvalidConversionException.checkConversion(baseVersion2 == null || Objects.equals(baseVersion1, baseVersion2), "Cannot collapse mutations with different base versions (%s and %s)", baseVersion1, baseVersion2);
        InvalidConversionException.checkConversion(resolutionStrategy2 == null || resolutionStrategy1 == resolutionStrategy2, "Cannot collapse mutations with different resolution strategies (%s and %s)", new Object[]{resolutionStrategy1, resolutionStrategy2});
        Mutation.Builder mutationBuilder = Mutation.builder().op(collapsedOp).key(key1).subMutationsInternal(newSubMutations).baseVersion(baseVersion1).conflictResolutionStrategy(resolutionStrategy1);
        if (collapsedOp.operation.equals((Object)Mutation.Operation.WRITE)) {
            mutationBuilder.transformation(newEntityTransformation).transformationOnly(!(!mutation1.transformationOnly() && !mutation1.isVerify() || !mutation2.transformationOnly() && !mutation2.isVerify()));
        }
        switch (op1.operation) {
            case WRITE: {
                return MutationHelper.writeThen(mutationBuilder, mutation1, mutation2);
            }
            case DELETE: {
                return MutationHelper.deleteThen(mutationBuilder, mutation2);
            }
            case VERIFY: {
                return MutationHelper.verifyThen(mutationBuilder, mutation2);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation writeThen(Mutation.Builder mutationBuilder, Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        switch (mutation2.op().operation) {
            case WRITE: {
                InvalidConversionException.checkConversion(Objects.equals(mutation1.readPropertyMask(), mutation2.readPropertyMask()), "Cannot collapse mutations with different read mask.", new Object[0]);
                return mutationBuilder.entity(mutation2.writePropertyMask().maskInto(mutation2.entity(), mutation1.entity())).writePropertyMask(mutation2.writePropertyMask().merge(mutation1.writePropertyMask())).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(mutation1.recreateEntity()).build();
            }
            case DELETE: {
                return mutationBuilder.build();
            }
            case VERIFY: {
                return mutationBuilder.entity(mutation1.entity()).writePropertyMask(mutation1.writePropertyMask()).readPropertyMask(mutation1.readPropertyMask()).recreateEntity(mutation1.recreateEntity()).build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation deleteThen(Mutation.Builder mutationBuilder, Mutation mutation2) {
        switch (mutation2.op().operation) {
            case WRITE: {
                return mutationBuilder.entity(mutation2.writePropertyMask().mask(mutation2.entity())).writePropertyMask(PropertyMask.FULL).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(true).build();
            }
            case DELETE: 
            case VERIFY: {
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation verifyThen(Mutation.Builder mutationBuilder, Mutation mutation2) {
        switch (mutation2.op().operation) {
            case WRITE: {
                return mutationBuilder.entity(mutation2.entity()).writePropertyMask(mutation2.writePropertyMask()).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(mutation2.recreateEntity()).build();
            }
            case DELETE: 
            case VERIFY: {
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static String opNameForErrorMessage(Mutation mutation) {
        return Ascii.toLowerCase(mutation.op().operation.equals((Object)Mutation.Operation.WRITE) ? mutation.op().name() : mutation.op().operation.name());
    }

    static {
        ImmutableTable.Builder<Mutation.Op, Mutation.Op, Mutation.Op> collapses = ImmutableTable.builder();
        for (Mutation.Op op1 : Mutation.Op.values()) {
            for (Mutation.Op op2 : Mutation.Op.values()) {
                if (!op2.existence.equals((Object)Mutation.ExistencePrecondition.NONE) && !op2.existence.equals((Object)MutationHelper.existenceAfter(op1))) continue;
                Mutation.Operation collapsedOperation = op2.operation.equals((Object)Mutation.Operation.VERIFY) ? op1.operation : op2.operation;
                collapses.put(op1, op2, Mutation.Op.from(collapsedOperation, op1.existence));
            }
        }
        OPERATION_COLLAPSES = collapses.build();
    }
}

