/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingRule;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class NeedIndexException
extends DatastoreException {
    public NeedIndexException(String message) {
        super(message, DatastoreV3Pb.Error.ErrorCode.NEED_INDEX, null);
    }

    public static Recommend recommend(String message, IndexDef indexDef) {
        return new Recommend(message, indexDef, null);
    }

    public static Recommend recommend(String message, SingleFieldIndex.Def indexDef) {
        return new Recommend(message, null, indexDef);
    }

    public static NonServing nonServing(String message, Index index) {
        return new NonServing(message, index, null, null);
    }

    public static NonServing nonServing(String message, SingleFieldIndex singleFieldIndex, SingleFieldIndexingRule rule) {
        return new NonServing(message, null, singleFieldIndex, rule);
    }

    public static class NonServing
    extends NeedIndexException {
        @Nullable
        public final Index index;
        @Nullable
        public final SingleFieldIndex singleFieldIndex;
        @Nullable
        public final SingleFieldIndexingRule rule;

        private NonServing(String message, @Nullable Index index, @Nullable SingleFieldIndex singleFieldIndex, @Nullable SingleFieldIndexingRule rule) {
            super(message);
            Preconditions.checkArgument(index != null ^ rule != null);
            Preconditions.checkArgument(rule == null == (singleFieldIndex == null));
            this.index = index;
            this.singleFieldIndex = singleFieldIndex;
            this.rule = rule;
        }
    }

    public static class Recommend
    extends NeedIndexException {
        @Nullable
        public final IndexDef indexDef;
        @Nullable
        public final SingleFieldIndex.Def singleFieldIndexDef;

        private Recommend(String message, @Nullable IndexDef indexDef, @Nullable SingleFieldIndex.Def singleFieldIndexDef) {
            super(message);
            Preconditions.checkArgument(indexDef != null ^ singleFieldIndexDef != null);
            this.indexDef = indexDef;
            this.singleFieldIndexDef = singleFieldIndexDef;
        }
    }
}

