/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.Nullable;

public class PropertyName
implements Comparable<PropertyName> {
    private static final Comparator<byte[]> UTF8_BYTE_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private static final ImmutableMap<String, SpecialPropertyName> NAME_TO_SPECIAL_PROPERTY_NAME_MAP = PropertyName.makeNameToSpecialPropertyNameMap();
    public static final PropertyName KEY = PropertyName.create(SpecialPropertyDescriptor.KEY.asString());
    private final byte[] nameAsByteArray;
    private final String name;

    private static ImmutableMap<String, SpecialPropertyName> makeNameToSpecialPropertyNameMap() {
        HashMap<String, SpecialPropertyName> map = new HashMap<String, SpecialPropertyName>();
        for (SpecialPropertyDescriptor special : SpecialPropertyDescriptor.values()) {
            if (special == SpecialPropertyDescriptor.NOT_SPECIAL) continue;
            String propertyName = special.asString();
            SpecialPropertyName previousName = map.put(propertyName, new SpecialPropertyName(special, propertyName));
            Preconditions.checkState(previousName == null, "duplicate special property name");
        }
        return ImmutableMap.copyOf(map);
    }

    public static PropertyName create(String name) {
        PropertyName specialPropertyName = PropertyName.specialLookup(name);
        if (specialPropertyName != null) {
            return specialPropertyName;
        }
        return new PropertyName(name);
    }

    @Nullable
    private static PropertyName specialLookup(String name) {
        if (!Names.isNameReserved(name)) {
            return null;
        }
        SpecialPropertyName specialPropertyName = NAME_TO_SPECIAL_PROPERTY_NAME_MAP.get(name);
        if (specialPropertyName == null) {
            return null;
        }
        return specialPropertyName;
    }

    private PropertyName(String name) {
        this.nameAsByteArray = name.getBytes(StandardCharsets.UTF_8);
        this.name = name;
    }

    public String string() {
        return this.name;
    }

    public SpecialPropertyDescriptor special() {
        return SpecialPropertyDescriptor.NOT_SPECIAL;
    }

    public boolean isKey() {
        return this.special() == SpecialPropertyDescriptor.KEY;
    }

    public boolean isReserved() {
        return Names.isNameReserved(this.string());
    }

    @Override
    public int compareTo(PropertyName other) {
        return UTF8_BYTE_COMPARATOR.compare(this.nameAsByteArray, other.nameAsByteArray);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PropertyName)) {
            return false;
        }
        PropertyName other = (PropertyName)otherObject;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.string();
    }

    private static class SpecialPropertyName
    extends PropertyName {
        private final SpecialPropertyDescriptor descriptor;

        public SpecialPropertyName(SpecialPropertyDescriptor descriptor, String name) {
            super(name);
            this.descriptor = descriptor;
        }

        @Override
        public SpecialPropertyDescriptor special() {
            return this.descriptor;
        }
    }
}

