/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Query;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.ConditionVisitor;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

@AutoValue
public abstract class Query {
    public boolean isQuerySearch() {
        return new ConditionVisitor(this){

            @Override
            protected boolean visit(Condition condition) {
                return condition.op() == Condition.Op.GEO_IN;
            }
        }.visitLeafConditions(this.condition());
    }

    public int queryMaxResultsWithOffsetLimitAndPeek() {
        int actualLimit;
        Integer limitInteger = this.limit();
        if (limitInteger == null) {
            actualLimit = Integer.MAX_VALUE;
        } else {
            actualLimit = this.offset() + limitInteger;
            if (actualLimit > 0) {
                ++actualLimit;
            }
            if (actualLimit < 0) {
                actualLimit = Integer.MAX_VALUE;
            }
        }
        return actualLimit;
    }

    public abstract QueryScope scope();

    public abstract Semantics semantics();

    @Nullable
    public abstract String kind();

    @Nullable
    public abstract EntityRef ancestor();

    public abstract boolean isShallow();

    @Nullable
    public abstract Condition condition();

    public abstract ImmutableList<PropertyPathWithDirection> orderBy();

    public abstract ImmutableList<PropertyPath> groupBy();

    public abstract ImmutableList<PropertyPath> projection();

    public abstract boolean selectOnlyKeys();

    public abstract boolean allowDuplicateResults();

    @Nullable
    public abstract Cursor startCursor();

    @Nullable
    public abstract Cursor endCursor();

    public abstract int offset();

    @Nullable
    public abstract Integer limit();

    public abstract PropertyMask propertyMask();

    @Nullable
    public abstract Cursor resumeCursor();

    public static Builder builder() {
        return new AutoValue_Query.Builder().semantics(Semantics.DATASTORE).isShallow(false).orderBy(ImmutableList.of()).groupBy(ImmutableList.of()).projection(ImmutableList.of()).selectOnlyKeys(false).allowDuplicateResults(false).offset(0).propertyMask(PropertyMask.FULL);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder scope(QueryScope var1);

        public abstract QueryScope.Builder scopeBuilder();

        public abstract Builder semantics(Semantics var1);

        public abstract Builder kind(@Nullable String var1);

        public abstract Builder ancestor(@Nullable EntityRef var1);

        public abstract Builder isShallow(boolean var1);

        @Nullable
        protected abstract Condition condition();

        public abstract Builder condition(@Nullable Condition var1);

        public Builder addCondition(Condition newCondition) {
            if (this.condition() == null) {
                this.condition(newCondition);
            } else {
                this.condition(LogicalCondition.create(Condition.Op.AND, this.condition(), newCondition));
            }
            return this;
        }

        public abstract Builder orderBy(ImmutableList<PropertyPathWithDirection> var1);

        public abstract Builder groupBy(ImmutableList<PropertyPath> var1);

        public abstract Builder projection(ImmutableList<PropertyPath> var1);

        public abstract Builder selectOnlyKeys(boolean var1);

        public abstract Builder allowDuplicateResults(boolean var1);

        public abstract Builder startCursor(@Nullable Cursor var1);

        public abstract Builder endCursor(Cursor var1);

        public abstract Builder offset(int var1);

        public abstract Builder limit(Integer var1);

        public abstract Builder propertyMask(PropertyMask var1);

        public abstract Builder resumeCursor(Cursor var1);

        public abstract Query build();
    }

    public static enum Semantics {
        DATASTORE,
        FIRESTORE;

    }
}

