/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.QueryInfo;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.common.base.MoreObjects;
import com.google.datastore.v1.QueryResultBatch;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class QueryResults {
    private final QueryInfo queryInfo;
    private int skippedResults = 0;
    @Nullable
    private Cursor skippedCursor = null;
    private final List<ReadResult> readResults = new ArrayList<ReadResult>();
    @Nullable
    protected Cursor endCursor = null;
    @Nullable
    protected Cursor resultSetCursor = null;
    private QueryResultBatch.MoreResultsType moreResults = QueryResultBatch.MoreResultsType.NOT_FINISHED;
    @Nullable
    private DatastoreException exception = null;
    private boolean progress = false;

    public QueryResults(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public QueryInfo query() {
        return this.queryInfo;
    }

    @Nullable
    public Cursor skippedCursor() {
        return this.skippedCursor;
    }

    public int skippedResults() {
        return this.skippedResults;
    }

    public List<ReadResult> readResults() {
        return this.readResults;
    }

    @Nullable
    public Cursor resultSetCursor() {
        return this.resultSetCursor;
    }

    @Nullable
    public Cursor endCursor() {
        return this.endCursor;
    }

    public QueryResultBatch.MoreResultsType moreResults() {
        return this.moreResults;
    }

    @Nullable
    public DatastoreException exception() {
        return this.exception;
    }

    public boolean madeProgress() {
        return this.progress;
    }

    public boolean madeResultSetProgress() {
        return this.madeProgress() && (this.resultSetCursor() != null || this.moreResults() != QueryResultBatch.MoreResultsType.NOT_FINISHED);
    }

    public void addSkippedResult(ReadResult result) {
        this.progress = true;
        this.resultSetCursor = this.endCursor = result.cursor();
        this.skippedCursor = this.endCursor;
        ++this.skippedResults;
    }

    public void addQueryResult(ReadResult readResult) {
        this.progress = true;
        this.resultSetCursor = this.endCursor = readResult.cursor();
        this.readResults.add(readResult);
    }

    public void setEndCursor(Cursor endCursor) {
        this.endCursor = endCursor;
    }

    public void setMoreResults(QueryResultBatch.MoreResultsType moreResults) {
        this.progress = true;
        this.moreResults = moreResults;
    }

    public synchronized void setException(DatastoreException cause) {
        this.exception = cause;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("skippedResults", this.skippedResults).add("skippedCursor", this.skippedCursor).add("readResults", this.readResults).add("resultSetCursor", this.resultSetCursor).add("endCursor", this.endCursor).add("moreResults", this.moreResults).add("exception", this.exception).toString();
    }
}

