/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ReadResult;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class ReadResult {
    public static ReadResult create(EntityRef entityRef, OnestoreEntity.EntityProto entity, @Nullable Entity repEntity, @Nullable Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.create(entityRef, entity, repEntity, cursor, createVersion, updateVersion, null);
    }

    public static ReadResult create(EntityRef entityRef, OnestoreEntity.EntityProto entity, @Nullable Entity repEntity, @Nullable Cursor cursor, long createVersion, long updateVersion, @Nullable Long readTimestamp) {
        return ReadResult.builder().reference(entity.getKey()).entityRef(Preconditions.checkNotNull(entityRef)).entity(entity).repEntity(repEntity).cursor(cursor).createVersion(createVersion).updateVersion(updateVersion).readTimestamp(readTimestamp).build();
    }

    public static ReadResult createNoVersion(EntityRef entityRef, OnestoreEntity.EntityProto entity, @Nullable Entity repEntity, @Nullable Cursor cursor) {
        return ReadResult.create(entityRef, entity, repEntity, cursor, -1L, -1L);
    }

    public static ReadResult createCursor(Cursor cursor) {
        return ReadResult.createCursor(cursor, -1L, -1L);
    }

    public static ReadResult createCursor(Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.builder().cursor(Preconditions.checkNotNull(cursor)).createVersion(createVersion).updateVersion(updateVersion).build();
    }

    public static ReadResult createMissing(EntityRef entityRef, OnestoreEntity.Reference reference, long version) {
        return ReadResult.createMissing(entityRef, reference, version, null);
    }

    public static ReadResult createMissing(EntityRef entityRef, OnestoreEntity.Reference reference, long version, @Nullable Long readTimestamp) {
        return ReadResult.builder().reference(Preconditions.checkNotNull(reference)).entityRef(Preconditions.checkNotNull(entityRef)).missingEntityReason(MissingEntityReason.MISSING).createVersion(-1L).updateVersion(version).readTimestamp(readTimestamp).build();
    }

    public static ReadResult createMissingNoVersion(EntityRef entityRef, OnestoreEntity.Reference reference) {
        return ReadResult.createMissing(entityRef, reference, -1L);
    }

    public static ReadResult createDeferred(EntityRef entityRef, OnestoreEntity.Reference reference) {
        return ReadResult.builder().reference(Preconditions.checkNotNull(reference)).entityRef(Preconditions.checkNotNull(entityRef)).createVersion(-1L).updateVersion(-1L).missingEntityReason(MissingEntityReason.DEFERRED).build();
    }

    public ReadResult withMask(PropertyMask propertyMask) {
        Preconditions.checkState(this.exists());
        if (propertyMask.equals(PropertyMask.FULL)) {
            return this;
        }
        Entity repEntity = this.repEntity() == null ? null : propertyMask.entityMaskCopy(this.repEntity());
        return this.toBuilder().entity(propertyMask.mask(this.entity())).repEntity(repEntity).build();
    }

    @Nullable
    public abstract OnestoreEntity.Reference reference();

    @Nullable
    public abstract EntityRef entityRef();

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    public boolean exists() {
        return this.entity() != null;
    }

    @Nullable
    public abstract Entity repEntity();

    @Nullable
    public abstract MissingEntityReason missingEntityReason();

    public abstract long createVersion();

    public abstract long updateVersion();

    @Nullable
    public abstract Long readTimestamp();

    @Nullable
    public abstract Cursor cursor();

    static Builder builder() {
        return new AutoValue_ReadResult.Builder();
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract ReadResult build();

        public abstract Builder reference(@Nullable OnestoreEntity.Reference var1);

        public abstract Builder entityRef(@Nullable EntityRef var1);

        public abstract Builder entity(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder repEntity(@Nullable Entity var1);

        public abstract Builder missingEntityReason(@Nullable MissingEntityReason var1);

        public abstract Builder createVersion(long var1);

        public abstract Builder updateVersion(long var1);

        public abstract Builder readTimestamp(@Nullable Long var1);

        public abstract Builder cursor(@Nullable Cursor var1);
    }

    public static enum MissingEntityReason {
        MISSING,
        DEFERRED;

    }
}

