/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldIndexingRule {
    private static final long DATABASE_RULE_ID = 0L;
    public static final SingleFieldIndexingRule EMPTY_DATABASE_RULE = SingleFieldIndexingRule.createDatabaseRule(ImmutableMap.of(), 0L);

    public abstract SingleFieldRef ref();

    @Nullable
    public abstract Long id();

    public abstract WorkflowState state();

    @Nullable
    public abstract Long updateTimeMicros();

    public abstract ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes();

    public abstract boolean error();

    public ImmutableMap<SingleFieldIndex.Mode, WorkflowState> indexStates() {
        ImmutableMap.Builder<SingleFieldIndex.Mode, WorkflowState> results = ImmutableMap.builder();
        for (SingleFieldIndex index : this.indexes().values()) {
            results.put(index.mode(), index.workflowState());
        }
        return results.build();
    }

    public static SingleFieldIndexingRule createDatabaseRule(Map<SingleFieldIndex.Mode, WorkflowState> modes, @Nullable Long updateTimeMicros) {
        ImmutableMap.Builder<SingleFieldIndex.Mode, SingleFieldIndex> indexes = ImmutableMap.builder();
        for (Map.Entry<SingleFieldIndex.Mode, WorkflowState> entry : modes.entrySet()) {
            SingleFieldIndex.Mode mode = entry.getKey();
            WorkflowState state = entry.getValue();
            indexes.put(mode, SingleFieldIndex.createDatabaseIndex(mode, state, updateTimeMicros));
        }
        return SingleFieldIndexingRule.create(SingleFieldRef.database(), 0L, WorkflowState.SERVING, updateTimeMicros, indexes.build());
    }

    public static SingleFieldIndexingRule createDatabaseRuleFromIndexes(ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes, @Nullable Long updateTimeMicros) {
        return SingleFieldIndexingRule.create(SingleFieldRef.database(), 0L, WorkflowState.SERVING, updateTimeMicros, indexes);
    }

    public static SingleFieldIndexingRule create(SingleFieldRef ref, @Nullable Long id, WorkflowState state, @Nullable Long updateTimeMicros, ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes) {
        return SingleFieldIndexingRule.create(ref, id, state, updateTimeMicros, indexes, false);
    }

    public static SingleFieldIndexingRule create(SingleFieldRef ref, @Nullable Long id, WorkflowState state, @Nullable Long updateTimeMicros, ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes, boolean error) {
        Preconditions.checkArgument(!error || state.finalizing(), "rules must not have errors unless they are in a finalizing state");
        if (ref.isDatabase()) {
            Preconditions.checkArgument(Preconditions.checkNotNull(id) == 0L, "database-level rule must have id set to 0");
            Preconditions.checkArgument(state == WorkflowState.SERVING, "database-level rule must be in SERVING state");
            for (SingleFieldIndex index : indexes.values()) {
                Preconditions.checkArgument(Preconditions.checkNotNull(index.id()) == index.mode().idWhenDatabaseDefault, "database-level rule must use fixed IDs for indexes");
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            Preconditions.checkArgument(entry.getKey() == ((SingleFieldIndex)entry.getValue()).mode(), "incorrect index map key");
            Preconditions.checkArgument(((SingleFieldIndex)entry.getValue()).ref().equals(ref), "incorrect index field ref");
        }
        return new AutoValue_SingleFieldIndexingRule(ref, id, state, updateTimeMicros, indexes, error);
    }

    public SingleFieldIndexingRule updateIndexes(Iterable<SingleFieldIndex> newIndexes) {
        EnumMap<SingleFieldIndex.Mode, SingleFieldIndex> updatedIndexes = new EnumMap<SingleFieldIndex.Mode, SingleFieldIndex>(SingleFieldIndex.Mode.class);
        HashSet<SingleFieldIndex.Mode> deletedIndexes = new HashSet<SingleFieldIndex.Mode>();
        for (SingleFieldIndex index : newIndexes) {
            if (index.equals(this.indexes().get((Object)index.mode()))) continue;
            if (index.workflowState() == WorkflowState.DELETED) {
                deletedIndexes.add(index.mode());
                continue;
            }
            updatedIndexes.put(index.mode(), index);
        }
        if (updatedIndexes.isEmpty() && deletedIndexes.isEmpty()) {
            return this;
        }
        for (SingleFieldIndex index : this.indexes().values()) {
            if (updatedIndexes.containsKey((Object)index.mode()) || deletedIndexes.contains((Object)index.mode())) continue;
            updatedIndexes.put(index.mode(), index);
        }
        return this.withIndexes(ImmutableMap.copyOf(updatedIndexes));
    }

    SingleFieldIndexingRule withIndexes(ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes) {
        return SingleFieldIndexingRule.create(this.ref(), this.id(), this.state(), this.updateTimeMicros(), indexes, this.error());
    }

    @Nullable
    public Long lastUpdated() {
        long maxUpdateTime = 0L;
        if (this.updateTimeMicros() == null || this.updateTimeMicros() == 0L) {
            return null;
        }
        maxUpdateTime = Math.max(maxUpdateTime, this.updateTimeMicros());
        for (SingleFieldIndex index : this.indexes().values()) {
            if (index.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, index.updateTimeMicros());
        }
        return maxUpdateTime;
    }
}

