/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.common.base.Ascii;

public enum SpecialPropertyDescriptor {
    NOT_SPECIAL(null),
    KEY,
    KIND,
    SCATTER,
    SPLITS,
    UNAPPLIED_LOG_TIMESTAMP_US;

    private final String propertyName;

    private SpecialPropertyDescriptor(Object object) {
        this.propertyName = "";
    }

    private SpecialPropertyDescriptor() {
        String string2 = Ascii.toLowerCase(this.name());
        this.propertyName = new StringBuilder(4 + String.valueOf(string2).length()).append("__").append(string2).append("__").toString();
    }

    public String asString() {
        return this.propertyName;
    }

    public final boolean isComputed() {
        switch (this) {
            case KEY: 
            case KIND: 
            case SCATTER: {
                return true;
            }
            case SPLITS: 
            case UNAPPLIED_LOG_TIMESTAMP_US: 
            case NOT_SPECIAL: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public final boolean isStoredComputed() {
        switch (this) {
            case SCATTER: {
                return true;
            }
            case KEY: 
            case KIND: 
            case SPLITS: 
            case UNAPPLIED_LOG_TIMESTAMP_US: 
            case NOT_SPECIAL: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public final boolean mayValueBeList() {
        switch (this) {
            case NOT_SPECIAL: {
                return true;
            }
            case KEY: 
            case KIND: 
            case SCATTER: 
            case SPLITS: 
            case UNAPPLIED_LOG_TIMESTAMP_US: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public final boolean isConfigDependent() {
        switch (this) {
            case SCATTER: {
                return true;
            }
            case KEY: 
            case KIND: 
            case SPLITS: 
            case UNAPPLIED_LOG_TIMESTAMP_US: 
            case NOT_SPECIAL: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public final boolean legacyIsPropertyIndexedNormally() {
        switch (this) {
            case SCATTER: 
            case NOT_SPECIAL: {
                return true;
            }
            case KEY: 
            case KIND: 
            case SPLITS: 
            case UNAPPLIED_LOG_TIMESTAMP_US: {
                return false;
            }
        }
        throw new AssertionError();
    }
}

