/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.apphosting.datastore.shared.Config;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Value_LegacyUser;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.GeoRegion;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.ValueRange;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import java.util.Objects;
import javax.annotation.Nullable;

public class Value {
    private static final Object BOXED_UNUSED = new Object();
    public static final Value NULL = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.NULL, -1L, BOXED_UNUSED, null);
    public static final Value TRUE = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BOOLEAN, 1L, BOXED_UNUSED, null);
    public static final Value FALSE = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BOOLEAN, 0L, BOXED_UNUSED, null);
    public static final Value MIN_LONG = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, Long.MIN_VALUE, BOXED_UNUSED, null);
    public static final Value MAX_LONG = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, Long.MAX_VALUE, BOXED_UNUSED, null);
    public static final Value NAN = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NaN), BOXED_UNUSED, null);
    public static final Value NEGATIVE_INFINITY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY), BOXED_UNUSED, null);
    public static final Value POSITIVE_INFINITY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.POSITIVE_INFINITY), BOXED_UNUSED, null);
    public static final Value MIN_VALID_TIMESTAMP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, Timestamp.newBuilder().setSeconds(-62135596800L).build(), null);
    public static final Value MAX_VALID_TIMESTAMP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, Timestamp.newBuilder().setSeconds(253402300799L).setNanos(999999999).build(), null);
    public static final Value EMPTY_STRING = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.STRING, -1L, "", null);
    public static final Value EMPTY_BYTES = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BYTES, -1L, ByteString.EMPTY, null);
    public static final Value EMPTY_RESOURCE_REF = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.RESOURCE_REF, -1L, OtherServiceResourceRef.EMPTY, null);
    public static final Value MIN_VALID_GEO_POINT = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, LatLng.newBuilder().setLatitude(Double.NEGATIVE_INFINITY).setLongitude(Double.NEGATIVE_INFINITY).build(), null);
    public static final Value MAX_VALID_GEO_POINT = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, LatLng.newBuilder().setLatitude(Double.POSITIVE_INFINITY).setLongitude(Double.POSITIVE_INFINITY).build(), null);
    public static final Value EMPTY_ARRAY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ARRAY, -1L, ImmutableList.of(), null);
    public static final Value EMPTY_MAP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.MAP, -1L, ImmutableMap.of(), null);
    public static final ImmutableMap<Meaning, Type> SUPPORTED_MEANING_TO_TYPE_MAP = ImmutableMap.builder().put(Meaning.ATOM_CATEGORY, Type.STRING).put(Meaning.ATOM_LINK, Type.STRING).put(Meaning.ATOM_TITLE, Type.STRING).put(Meaning.ATOM_CONTENT, Type.STRING).put(Meaning.ATOM_SUMMARY, Type.STRING).put(Meaning.ATOM_AUTHOR, Type.STRING).put(Meaning.GD_EMAIL, Type.STRING).put(Meaning.GD_IM, Type.STRING).put(Meaning.GD_PHONENUMBER, Type.STRING).put(Meaning.GD_POSTALADDRESS, Type.STRING).put(Meaning.GD_RATING, Type.LONG).put(Meaning.TEXT, Type.STRING).put(Meaning.BYTESTRING, Type.BYTES).put(Meaning.INVALID_ENTITY_PROTO_BYTES, Type.BYTES).put(Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE, Type.BYTES).put(Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT, Type.BYTES).put(Meaning.BLOBKEY, Type.STRING).put(Meaning.URI_MEANING_ZLIB, Type.BYTES).put(Meaning.GEO_POINT_WITHOUT_APP_ENG_V3_MEANING, Type.GEO_POINT).build();
    private final DatastoreIndexing datastoreIndexing;
    private final Meaning meaning;
    private final Type type;
    private final long unboxed;
    private final Object boxed;
    @Nullable
    private final UnknownFieldSet unknownFieldSet;

    public static Value createBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static Value createLong(long x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, x, BOXED_UNUSED, null);
    }

    public static Value createDouble(double x) {
        if (Double.isNaN(x)) {
            x = Double.NaN;
        }
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(x), BOXED_UNUSED, null);
    }

    public static Value createTimestamp(Timestamp x) {
        long nanoseconds = x.getNanos();
        Preconditions.checkArgument(RepHelper.isSecondsInTimestampBounds(x.getSeconds()) && nanoseconds >= 0L && nanoseconds < 1000000000L);
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, x, null);
    }

    public static Value createEntityRef(EntityRef x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ENTITY_REF, -1L, x, null);
    }

    public static Value createResourceRef(ResourceRef x) {
        Preconditions.checkArgument(!(x instanceof EntityRef));
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.RESOURCE_REF, -1L, x, null);
    }

    public static Value createString(String x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.STRING, -1L, x, null);
    }

    public static Value createBytes(ByteString x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BYTES, -1L, x, null);
    }

    public static Value createGeoPoint(LatLng x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, x, null);
    }

    public static Value createGeoRegion(GeoRegion x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_REGION, -1L, x, null);
    }

    public static Value createArray(ImmutableList<Value> x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ARRAY, -1L, x, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x) {
        return Value.createMap(x, DatastoreIndexing.INCLUDE, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x, DatastoreIndexing datastoreIndexing) {
        return Value.createMap(x, datastoreIndexing, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x, UnknownFieldSet unknownFieldSet) {
        return Value.createMap(x, DatastoreIndexing.INCLUDE, Preconditions.checkNotNull(unknownFieldSet));
    }

    private static Value createMap(ImmutableMap<String, Value> x, DatastoreIndexing datastoreIndexing, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(datastoreIndexing, Meaning.NONE, Type.MAP, -1L, x, unknownFieldSet);
    }

    public static Value createEntity(Entity x) {
        return Value.createEntity(x, DatastoreIndexing.INCLUDE, null);
    }

    public static Value createEntity(Entity x, DatastoreIndexing datastoreIndexing) {
        return Value.createEntity(x, datastoreIndexing, null);
    }

    public static Value createEntity(Entity x, UnknownFieldSet unknownFieldSet) {
        return Value.createEntity(x, DatastoreIndexing.INCLUDE, Preconditions.checkNotNull(unknownFieldSet));
    }

    private static Value createEntity(Entity x, DatastoreIndexing datastoreIndexing, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(datastoreIndexing, Meaning.NONE, Type.ENTITY, -1L, x, unknownFieldSet);
    }

    public static Value createLegacyUser(LegacyUser x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LEGACY_USER, -1L, x, null);
    }

    public static Value createLegacyTimestampMicroseconds(long x) {
        Preconditions.checkArgument(!RepHelper.isMicrosecondsInTimestampBounds(x));
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LEGACY_TIMESTAMP_MICROSECONDS, x, BOXED_UNUSED, null);
    }

    private Value(DatastoreIndexing datastoreIndexing, Meaning meaning, Type type, long unboxed, Object boxed, @Nullable UnknownFieldSet unknownFieldSet) {
        Preconditions.checkArgument(datastoreIndexing != DatastoreIndexing.EXCLUDE || type != Type.ARRAY);
        this.datastoreIndexing = datastoreIndexing;
        this.meaning = meaning;
        this.type = type;
        this.unboxed = unboxed;
        this.boxed = boxed;
        this.unknownFieldSet = unknownFieldSet;
    }

    public DatastoreIndexing datastoreIndexing() {
        return this.datastoreIndexing;
    }

    public Meaning meaning() {
        return this.meaning;
    }

    public Type type() {
        return this.type;
    }

    public UnknownFieldSet unknownFieldSet() {
        return this.unknownFieldSet;
    }

    public boolean asBoolean() {
        this.assertType(Type.BOOLEAN);
        return this.unboxed != 0L;
    }

    public long asLong() {
        this.assertType(Type.LONG);
        return this.unboxed;
    }

    public double asDouble() {
        this.assertType(Type.DOUBLE);
        return Double.longBitsToDouble(this.unboxed);
    }

    public Timestamp asTimestamp() {
        return (Timestamp)this.boxed;
    }

    public EntityRef asEntityRef() {
        return (EntityRef)this.boxed;
    }

    public ResourceRef asResourceRef() {
        return (ResourceRef)this.boxed;
    }

    public String asString() {
        return (String)this.boxed;
    }

    public ByteString asBytes() {
        return (ByteString)this.boxed;
    }

    public LatLng asGeoPoint() {
        return (LatLng)this.boxed;
    }

    public GeoRegion asGeoRegion() {
        return (GeoRegion)this.boxed;
    }

    public ValueRange asRange() {
        return (ValueRange)this.boxed;
    }

    public ImmutableList<Value> asArray() {
        return (ImmutableList)this.boxed;
    }

    public ImmutableMap<String, Value> asMap() {
        return (ImmutableMap)this.boxed;
    }

    public Entity asEntity() {
        return (Entity)this.boxed;
    }

    public LegacyUser asLegacyUser() {
        return (LegacyUser)this.boxed;
    }

    public long asLegacyTimestampMicroseconds() {
        this.assertType(Type.LEGACY_TIMESTAMP_MICROSECONDS);
        return this.unboxed;
    }

    public boolean isNull() {
        return this.type() == Type.NULL;
    }

    public boolean isNaN() {
        return this.type() == Type.DOUBLE && Double.isNaN(this.asDouble());
    }

    public boolean isDatastoreIndexable() {
        switch (this.type) {
            case NULL: 
            case BOOLEAN: 
            case LONG: 
            case DOUBLE: 
            case TIMESTAMP: 
            case ENTITY_REF: 
            case GEO_POINT: 
            case LEGACY_TIMESTAMP_MICROSECONDS: 
            case LEGACY_USER: 
            case ARRAY: 
            case MAP: 
            case ENTITY: {
                return true;
            }
            case STRING: {
                if (this.meaning.equals((Object)Meaning.TEXT)) {
                    return false;
                }
                int maxUtf8Bytes = this.meaning.equals((Object)Meaning.ATOM_LINK) ? Config.DatastoreConfig.getDefaultInstance().getMaxAtomLinkBytes() : Config.DatastoreConfig.getDefaultInstance().getMaxIndexedValueBytes();
                int numUtf16Chars = this.asString().length();
                return numUtf16Chars <= maxUtf8Bytes && (3 * numUtf16Chars <= maxUtf8Bytes || Utf8.encodedLength(this.asString()) <= maxUtf8Bytes);
            }
            case BYTES: {
                return !this.meaning.equals((Object)Meaning.INVALID_ENTITY_PROTO_BYTES) && !this.meaning.equals((Object)Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT) && this.asBytes().size() <= Config.DatastoreConfig.getDefaultInstance().getMaxIndexedValueBytes();
            }
        }
        String string = String.valueOf((Object)this.type());
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported value type ").append(string).toString());
    }

    public boolean isDatastoreIndexed() {
        switch (this.datastoreIndexing) {
            case INCLUDE: {
                return true;
            }
            case EXCLUDE: {
                return false;
            }
            case AUTO: {
                return this.isDatastoreIndexable();
            }
        }
        throw new AssertionError();
    }

    public Value withMeaning(Meaning meaning) {
        return this.withMeaningAux(true, meaning);
    }

    @Nullable
    public Value withMeaningIfValid(Meaning meaning) {
        return this.withMeaningAux(false, meaning);
    }

    @Nullable
    private Value withMeaningAux(boolean throwIfInvalidMeaning, Meaning meaning) {
        if (meaning == this.meaning) {
            return this;
        }
        if (meaning != Meaning.NONE && meaning != Meaning.OMITTED_BY_MEGASTORE_INDEX && SUPPORTED_MEANING_TO_TYPE_MAP.get((Object)meaning) != this.type()) {
            Preconditions.checkArgument(!throwIfInvalidMeaning, "Value type %s cannot have meaning %s.", (Object)this.type(), (Object)meaning);
            return null;
        }
        return new Value(this.datastoreIndexing, meaning, this.type, this.unboxed, this.boxed, this.unknownFieldSet);
    }

    public Value withDatastoreIndexing(DatastoreIndexing datastoreIndexing) {
        if (datastoreIndexing == this.datastoreIndexing) {
            return this;
        }
        return new Value(datastoreIndexing, this.meaning, this.type, this.unboxed, this.boxed, this.unknownFieldSet);
    }

    @Nullable
    public Value get(PropertyPath propertyPath) {
        switch (this.type()) {
            case ARRAY: {
                return propertyPath.getFrom(this.asArray());
            }
            case MAP: {
                return propertyPath.getFrom(this.asMap());
            }
            case ENTITY: {
                return propertyPath.getFrom(this.asEntity().propertyMap());
            }
        }
        return null;
    }

    private void assertType(Type requiredType) {
        Preconditions.checkState(this.type == requiredType);
    }

    public boolean equals(Object valueObject) {
        if (!(valueObject instanceof Value)) {
            return false;
        }
        Value value = (Value)valueObject;
        return this.unboxed == value.unboxed && this.type == value.type && this.datastoreIndexing == value.datastoreIndexing && this.meaning == value.meaning && this.boxed.equals(value.boxed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.datastoreIndexing, this.meaning, this.type, this.unboxed, this.boxed});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{value: ");
        switch (this.type) {
            case NULL: {
                stringBuilder.append("null");
                break;
            }
            case BOOLEAN: {
                stringBuilder.append(this.asBoolean());
                break;
            }
            case LONG: {
                stringBuilder.append(this.asLong());
                break;
            }
            case DOUBLE: {
                stringBuilder.append(this.asDouble());
                break;
            }
            case TIMESTAMP: {
                stringBuilder.append(this.asTimestamp());
                break;
            }
            case ENTITY_REF: {
                stringBuilder.append(this.asEntityRef());
                break;
            }
            case RESOURCE_REF: {
                stringBuilder.append(this.asResourceRef());
                break;
            }
            case STRING: {
                stringBuilder.append(this.asString());
                break;
            }
            case BYTES: {
                stringBuilder.append(this.asBytes());
                break;
            }
            case GEO_POINT: {
                stringBuilder.append(this.asGeoPoint());
                break;
            }
            case GEO_REGION: {
                stringBuilder.append(this.asGeoRegion());
                break;
            }
            case RANGE: {
                stringBuilder.append(this.asRange());
                break;
            }
            case ARRAY: {
                stringBuilder.append(this.asArray());
                break;
            }
            case MAP: {
                stringBuilder.append(this.asMap());
                break;
            }
            case ENTITY: {
                stringBuilder.append(this.asEntity());
                break;
            }
            case LEGACY_USER: {
                stringBuilder.append(this.asLegacyUser());
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                stringBuilder.append("{legacy timestamp microseconds: ");
                stringBuilder.append(this.asLegacyTimestampMicroseconds());
                stringBuilder.append("}");
            }
        }
        if (this.datastoreIndexing != DatastoreIndexing.INCLUDE) {
            stringBuilder.append(", indexing: ");
            stringBuilder.append((Object)this.datastoreIndexing);
        }
        if (this.meaning != Meaning.NONE) {
            stringBuilder.append(", meaning: ");
            stringBuilder.append((Object)this.meaning);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static enum Meaning {
        NONE,
        ATOM_CATEGORY,
        ATOM_LINK,
        ATOM_TITLE,
        ATOM_CONTENT,
        ATOM_SUMMARY,
        ATOM_AUTHOR,
        GD_WHEN,
        GD_EMAIL,
        GEORSS_POINT,
        GD_IM,
        GD_PHONENUMBER,
        GD_POSTALADDRESS,
        GD_RATING,
        BLOB,
        TEXT,
        BYTESTRING,
        BLOBKEY,
        OMITTED_BY_MEGASTORE_INDEX,
        INVALID_ENTITY_PROTO_BYTES,
        LEGACY_USER_ENTITY,
        DEPRECATED_LEGACY_GEO_POINT_ENTITY,
        URI_MEANING_ZLIB,
        GEO_POINT_WITHOUT_APP_ENG_V3_MEANING,
        EMPTY_LIST,
        NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE,
        NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT;

        private static final Meaning[] ordinalToEnumArray;

        @Nullable
        public static Meaning createFromOrdinal(long ordinal) {
            if (ordinal < 0L || ordinal >= (long)ordinalToEnumArray.length) {
                return null;
            }
            return ordinalToEnumArray[(int)ordinal];
        }

        static {
            ordinalToEnumArray = Meaning.values();
        }
    }

    @AutoValue
    public static abstract class LegacyUser {
        public abstract String email();

        public abstract String authDomain();

        public abstract long gaiaId();

        public abstract String obfuscatedGaiaId();

        @Nullable
        public abstract String federatedIdentity();

        @Nullable
        public abstract String federatedProvider();

        public static LegacyUser create(String email, String authDomain, long gaiaId, String obfuscatedGaiaId, @Nullable String federatedIdentity, @Nullable String federatedProvider) {
            return new AutoValue_Value_LegacyUser(email, authDomain, gaiaId, obfuscatedGaiaId, federatedIdentity, federatedProvider);
        }
    }

    public static enum DatastoreIndexing {
        INCLUDE,
        EXCLUDE,
        AUTO;

    }

    public static enum Type {
        NULL,
        BOOLEAN,
        LONG,
        DOUBLE,
        TIMESTAMP,
        STRING,
        BYTES,
        ENTITY_REF,
        RESOURCE_REF,
        GEO_POINT,
        ARRAY,
        MAP,
        ENTITY,
        LEGACY_USER,
        LEGACY_TIMESTAMP_MICROSECONDS,
        GEO_REGION,
        RANGE;

    }
}

