/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ValueRange;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.ValueInterval;
import com.google.cloud.datastore.core.rep.ValueOrder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

@AutoValue
public abstract class ValueRange {
    public abstract ValueOrder valueOrder();

    public abstract ImmutableList<ValueInterval> trueIntervals();

    public static ValueRange createNoneTrue(ValueOrder order) {
        return new AutoValue_ValueRange(order, ImmutableList.of());
    }

    public static ValueRange createAllTrue(ValueOrder order) {
        ValueInterval interval = ValueInterval.create(order, order.minValue(), true, null, false);
        return new AutoValue_ValueRange(order, ImmutableList.of(interval));
    }

    public static ValueRange createForConditionOpAndValue(ValueOrder order, boolean not, Condition.Op op, Value value) {
        Condition.Op effectiveOp;
        value = order.canonicalizeValue(value);
        boolean isOpReallyEquals = op == Condition.Op.REALLY_EQUALS;
        Value bottomValue = order.bottomValueOfCategory(value);
        if (value.equals(bottomValue)) {
            if (not) {
                Value minValueOfCategoryForWhichItIsBottom = order.minValueOfNextCategory(bottomValue);
                Value minValueOfNextCategory = order.minValueOfNextCategory(minValueOfCategoryForWhichItIsBottom);
                return ValueRange.createForTrueInterval(order, ValueInterval.create(order, isOpReallyEquals ? minValueOfCategoryForWhichItIsBottom : bottomValue, true, minValueOfNextCategory, false));
            }
            if (isOpReallyEquals) {
                return ValueRange.createForTrueValue(order, bottomValue);
            }
            return ValueRange.createNoneTrue(order);
        }
        boolean includeValue = true;
        switch (op) {
            case REALLY_EQUALS: 
            case EQ: {
                if (not) {
                    effectiveOp = Condition.Op.RESERVED_NE;
                    break;
                }
                effectiveOp = Condition.Op.EQ;
                break;
            }
            case RESERVED_NE: {
                if (not) {
                    effectiveOp = Condition.Op.EQ;
                    break;
                }
                effectiveOp = Condition.Op.RESERVED_NE;
                break;
            }
            case LT: {
                if (not) {
                    effectiveOp = Condition.Op.GT;
                    includeValue = true;
                    break;
                }
                effectiveOp = Condition.Op.LT;
                includeValue = false;
                break;
            }
            case LE: {
                if (not) {
                    effectiveOp = Condition.Op.GT;
                    includeValue = false;
                    break;
                }
                effectiveOp = Condition.Op.LT;
                includeValue = true;
                break;
            }
            case GT: {
                if (not) {
                    effectiveOp = Condition.Op.LT;
                    includeValue = true;
                    break;
                }
                effectiveOp = Condition.Op.GT;
                includeValue = false;
                break;
            }
            case GE: {
                if (not) {
                    effectiveOp = Condition.Op.LT;
                    includeValue = false;
                    break;
                }
                effectiveOp = Condition.Op.GT;
                includeValue = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't create value range for property value condition.");
            }
        }
        boolean hasNotAndBottom = not && bottomValue != null;
        ImmutableList.Builder<ValueInterval> trueIntervalsBuilder = ImmutableList.builder();
        switch (effectiveOp) {
            case EQ: {
                if (hasNotAndBottom) {
                    ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, bottomValue, true, bottomValue, true);
                }
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, value, true, value, true);
                break;
            }
            case RESERVED_NE: {
                Value minValue = order.minValue();
                if (hasNotAndBottom) {
                    ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, minValue, true, bottomValue, false);
                    ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, bottomValue, false, value, false);
                } else {
                    ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, minValue, true, value, false);
                }
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, value, false, null, false);
                break;
            }
            case LT: {
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, hasNotAndBottom ? bottomValue : order.minValueOfCategory(value), true, value, includeValue);
                break;
            }
            case GT: {
                if (hasNotAndBottom) {
                    ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, bottomValue, true, bottomValue, true);
                }
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, value, includeValue, order.minValueOfNextCategory(value), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected effective operation.");
            }
        }
        return new AutoValue_ValueRange(order, (ImmutableList<ValueInterval>)trueIntervalsBuilder.build());
    }

    public static ValueRange createForTrueInterval(ValueOrder order, ValueInterval interval) {
        Preconditions.checkArgument(order == interval.valueOrder());
        return new AutoValue_ValueRange(order, ImmutableList.of(interval));
    }

    public static ValueRange createForTrueValue(ValueOrder order, Value value) {
        value = order.canonicalizeValue(value);
        return new AutoValue_ValueRange(order, ImmutableList.of(ValueInterval.create(order, value, true, value, true)));
    }

    public boolean isNoneTrue() {
        return this.trueIntervals().isEmpty();
    }

    public boolean isAllTrue() {
        ImmutableList<ValueInterval> trueIntervals = this.trueIntervals();
        if (trueIntervals.size() != 1) {
            return false;
        }
        ValueInterval interval = (ValueInterval)trueIntervals.get(0);
        return interval.endValue() == null && interval.startsAtMin();
    }

    @Nullable
    public Value uniqueTrueValue() {
        ValueInterval interval = this.uniqueTrueInterval();
        if (interval == null) {
            return null;
        }
        return interval.uniqueValue();
    }

    @Nullable
    public ValueInterval uniqueTrueInterval() {
        ImmutableList<ValueInterval> trueIntervals = this.trueIntervals();
        if (trueIntervals.size() != 1) {
            return null;
        }
        return (ValueInterval)trueIntervals.get(0);
    }

    public boolean isValueTrue(Value value) {
        ValueOrder order = this.valueOrder();
        ImmutableList<ValueInterval> trueIntervals = this.trueIntervals();
        int lowerIntervalIndex = 0;
        int upperIntervalIndex = trueIntervals.size();
        while (upperIntervalIndex - lowerIntervalIndex > 0) {
            int midIntervalIndex = (lowerIntervalIndex + upperIntervalIndex) / 2;
            ValueInterval midInterval = (ValueInterval)trueIntervals.get(midIntervalIndex);
            int startComparison = order.compare(value, midInterval.startValue());
            if (startComparison < 0) {
                upperIntervalIndex = midIntervalIndex;
                continue;
            }
            int endComparison = order.compare(value, midInterval.endValue());
            if (endComparison > 0) {
                lowerIntervalIndex = midIntervalIndex + 1;
                continue;
            }
            return !(startComparison <= 0 && !midInterval.includeStart() || endComparison >= 0 && !midInterval.includeEnd());
        }
        return false;
    }

    public ValueRange intersect(ValueRange other) {
        ValueOrder order = this.valueOrder();
        Preconditions.checkArgument(other.valueOrder() == order);
        ImmutableList.Builder<ValueInterval> trueIntervalsBuilder = ImmutableList.builder();
        ImmutableList<ValueInterval> leftIntervals = this.trueIntervals();
        ImmutableList<ValueInterval> rightIntervals = other.trueIntervals();
        int leftNumIntervals = leftIntervals.size();
        int rightNumIntervals = rightIntervals.size();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftNumIntervals && rightIndex < rightNumIntervals) {
            boolean combinedIsEndIncluded;
            Value combinedEndValue;
            boolean combinedIsStartIncluded;
            Value combinedStartValue;
            Value rightStartValue;
            ValueInterval rightInterval;
            ValueInterval leftInterval = (ValueInterval)leftIntervals.get(leftIndex);
            if (this.isDisjointFromAndLessThan(leftInterval, rightInterval = (ValueInterval)rightIntervals.get(rightIndex))) {
                ++leftIndex;
                continue;
            }
            if (this.isDisjointFromAndLessThan(rightInterval, leftInterval)) {
                ++rightIndex;
                continue;
            }
            Value leftStartValue = leftInterval.startValue();
            int startComparison = order.compare(leftStartValue, rightStartValue = rightInterval.startValue());
            if (startComparison > 0 || startComparison == 0 && rightInterval.includeStart()) {
                combinedStartValue = leftStartValue;
                combinedIsStartIncluded = leftInterval.includeStart();
            } else {
                combinedStartValue = rightStartValue;
                combinedIsStartIncluded = rightInterval.includeStart();
            }
            Value leftEndValue = leftInterval.endValue();
            Value rightEndValue = rightInterval.endValue();
            int endComparison = order.compare(leftEndValue, rightEndValue);
            if (endComparison < 0 || endComparison == 0 && rightInterval.includeEnd()) {
                combinedEndValue = leftEndValue;
                combinedIsEndIncluded = leftInterval.includeEnd();
                ++leftIndex;
            } else {
                combinedEndValue = rightEndValue;
                combinedIsEndIncluded = rightInterval.includeEnd();
                ++rightIndex;
            }
            ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, combinedStartValue, combinedIsStartIncluded, combinedEndValue, combinedIsEndIncluded);
        }
        return new AutoValue_ValueRange(order, (ImmutableList<ValueInterval>)trueIntervalsBuilder.build());
    }

    private boolean isDisjointFromAndLessThan(ValueInterval left, ValueInterval right) {
        int comparison = this.valueOrder().compare(left.endValue(), right.startValue());
        return comparison < 0 || comparison == 0 && (!left.includeEnd() || !right.includeStart());
    }

    public ValueRange union(ValueRange other) {
        ValueOrder order = this.valueOrder();
        Preconditions.checkArgument(other.valueOrder() == order);
        ValueInterval[] intervalsOrderedByStart = this.mergeOrderedIntervalsListsByStart(this.trueIntervals(), other.trueIntervals());
        return new AutoValue_ValueRange(order, this.combineOverlappingIntervals(intervalsOrderedByStart));
    }

    private ValueInterval[] mergeOrderedIntervalsListsByStart(ImmutableList<ValueInterval> leftIntervals, ImmutableList<ValueInterval> rightIntervals) {
        int unfinishedNumIntervals;
        int unfinishedIndex;
        ImmutableList<ValueInterval> unfinishedIntervals;
        ValueOrder order = this.valueOrder();
        int leftNumIntervals = leftIntervals.size();
        int rightNumIntervals = rightIntervals.size();
        int combinedNumIntervals = leftNumIntervals + rightNumIntervals;
        ValueInterval[] combinedIntervals = new ValueInterval[combinedNumIntervals];
        int leftIndex = 0;
        int rightIndex = 0;
        int combinedIndex = 0;
        while (leftIndex < leftNumIntervals && rightIndex < rightNumIntervals) {
            ValueInterval leftInterval = (ValueInterval)leftIntervals.get(leftIndex);
            ValueInterval rightInterval = (ValueInterval)rightIntervals.get(rightIndex);
            int startValueComparison = order.compare(leftInterval.startValue(), rightInterval.startValue());
            if (startValueComparison < 0 || startValueComparison == 0 && (leftInterval.includeStart() || !rightInterval.includeStart())) {
                combinedIntervals[combinedIndex] = leftInterval;
                ++leftIndex;
            } else {
                combinedIntervals[combinedIndex] = rightInterval;
                ++rightIndex;
            }
            ++combinedIndex;
        }
        if (leftIndex < leftNumIntervals) {
            unfinishedIntervals = leftIntervals;
            unfinishedIndex = leftIndex;
            unfinishedNumIntervals = leftNumIntervals;
        } else {
            unfinishedIntervals = rightIntervals;
            unfinishedIndex = rightIndex;
            unfinishedNumIntervals = rightNumIntervals;
        }
        while (unfinishedIndex < unfinishedNumIntervals) {
            combinedIntervals[combinedIndex] = (ValueInterval)unfinishedIntervals.get(unfinishedIndex);
            ++combinedIndex;
            ++unfinishedIndex;
        }
        return combinedIntervals;
    }

    private ImmutableList<ValueInterval> combineOverlappingIntervals(ValueInterval[] intervalsOrderedByStart) {
        ValueOrder order = this.valueOrder();
        ImmutableList.Builder<ValueInterval> trueIntervalsBuilder = ImmutableList.builder();
        ValueInterval minStartMergeInterval = null;
        ValueInterval maxEndMergeInterval = null;
        int numIntervals = intervalsOrderedByStart.length;
        for (int intervalIndex = 0; intervalIndex < numIntervals; ++intervalIndex) {
            ValueInterval nextInterval;
            int overlapComparison;
            ValueInterval interval = intervalsOrderedByStart[intervalIndex];
            int nextIntervalIndex = intervalIndex + 1;
            if (nextIntervalIndex < numIntervals && ((overlapComparison = order.compare((nextInterval = intervalsOrderedByStart[nextIntervalIndex]).startValue(), interval.endValue())) < 0 || overlapComparison == 0 && (interval.includeEnd() || nextInterval.includeStart()))) {
                int endValueComparison;
                if (minStartMergeInterval == null) {
                    minStartMergeInterval = interval;
                    maxEndMergeInterval = interval;
                }
                if ((endValueComparison = order.compare(maxEndMergeInterval.endValue(), nextInterval.endValue())) >= 0 && (endValueComparison != 0 || maxEndMergeInterval.includeEnd())) continue;
                maxEndMergeInterval = nextInterval;
                continue;
            }
            if (minStartMergeInterval != null) {
                this.addMergedIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, minStartMergeInterval, maxEndMergeInterval);
                minStartMergeInterval = null;
                maxEndMergeInterval = null;
                continue;
            }
            trueIntervalsBuilder.add((Object)interval);
        }
        if (minStartMergeInterval != null) {
            this.addMergedIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, minStartMergeInterval, maxEndMergeInterval);
        }
        return trueIntervalsBuilder.build();
    }

    private void addMergedIntervalToTrueIntervalsBuilder(ImmutableList.Builder<ValueInterval> trueIntervalsBuilder, ValueInterval minStartMergeInterval, ValueInterval maxEndMergeInterval) {
        ValueInterval continuousSequenceInterval = ValueInterval.create(this.valueOrder(), minStartMergeInterval.startValue(), minStartMergeInterval.includeStart(), maxEndMergeInterval.endValue(), maxEndMergeInterval.includeEnd());
        trueIntervalsBuilder.add((Object)continuousSequenceInterval);
    }

    @Nullable
    public ValueRange constrainWithCursorValue(boolean constrainToBefore, @Nullable Value value, boolean includeValue) {
        int splitIntervalIndex;
        ValueOrder order = this.valueOrder();
        if (value != null) {
            value = order.canonicalizeValue(value);
        }
        ImmutableList<ValueInterval> trueIntervals = this.trueIntervals();
        int numIntervals = trueIntervals.size();
        int lowerIntervalIndex = 0;
        int upperIntervalIndex = numIntervals;
        while (upperIntervalIndex - lowerIntervalIndex > 0) {
            int midIntervalIndex = (lowerIntervalIndex + upperIntervalIndex) / 2;
            ValueInterval midInterval = (ValueInterval)trueIntervals.get(midIntervalIndex);
            int startComparison = order.compare(value, midInterval.startValue());
            if (startComparison < 0) {
                upperIntervalIndex = midIntervalIndex;
                continue;
            }
            int endComparison = order.compare(value, midInterval.endValue());
            if (endComparison > 0) {
                lowerIntervalIndex = midIntervalIndex + 1;
                continue;
            }
            if (constrainToBefore) {
                if (endComparison == 0) {
                    boolean midIntervalIncludesEnd = midInterval.includeEnd();
                    if (midIntervalIndex == numIntervals - 1) {
                        if (includeValue == midIntervalIncludesEnd) {
                            return this;
                        }
                        if (includeValue && !midIntervalIncludesEnd) {
                            return null;
                        }
                    }
                    if (!midIntervalIncludesEnd) {
                        includeValue = false;
                    }
                }
            } else if (startComparison == 0) {
                boolean midIntervalIncludesStart = midInterval.includeStart();
                if (midIntervalIndex == 0) {
                    if (includeValue == midIntervalIncludesStart) {
                        return this;
                    }
                    if (includeValue && !midIntervalIncludesStart) {
                        return null;
                    }
                }
                if (!midIntervalIncludesStart) {
                    includeValue = false;
                }
            }
            return this.constrainWithCursorValueHelper(constrainToBefore, value, includeValue, true, midIntervalIndex);
        }
        if (lowerIntervalIndex >= numIntervals) {
            if (constrainToBefore) {
                return null;
            }
            return ValueRange.createNoneTrue(order);
        }
        if (upperIntervalIndex <= 0) {
            if (constrainToBefore) {
                return ValueRange.createNoneTrue(order);
            }
            return null;
        }
        if (constrainToBefore ? (splitIntervalIndex = lowerIntervalIndex) == numIntervals : (splitIntervalIndex = upperIntervalIndex - 1) == -1) {
            return this;
        }
        return this.constrainWithCursorValueHelper(constrainToBefore, value, includeValue, false, splitIntervalIndex);
    }

    private ValueRange constrainWithCursorValueHelper(boolean constrainToBefore, Value value, boolean includeValue, boolean splitIntervalAtSplitIndex, int splitIntervalIndex) {
        ValueOrder order = this.valueOrder();
        ImmutableList<ValueInterval> trueIntervals = this.trueIntervals();
        ImmutableList.Builder<ValueInterval> trueIntervalsBuilder = ImmutableList.builder();
        ValueInterval splitInterval = (ValueInterval)trueIntervals.get(splitIntervalIndex);
        if (constrainToBefore) {
            for (int index = 0; index < splitIntervalIndex; ++index) {
                trueIntervalsBuilder.add((Object)((ValueInterval)trueIntervals.get(index)));
            }
            if (splitIntervalAtSplitIndex) {
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, splitInterval.startValue(), splitInterval.includeStart(), value, includeValue);
            }
        } else {
            if (splitIntervalAtSplitIndex) {
                ValueRange.addIntervalToTrueIntervalsBuilder(trueIntervalsBuilder, order, value, includeValue, splitInterval.endValue(), splitInterval.includeEnd());
            }
            int numTrueIntervals = trueIntervals.size();
            for (int index = splitIntervalIndex + 1; index < numTrueIntervals; ++index) {
                trueIntervalsBuilder.add((Object)((ValueInterval)trueIntervals.get(index)));
            }
        }
        return new AutoValue_ValueRange(this.valueOrder(), (ImmutableList<ValueInterval>)trueIntervalsBuilder.build());
    }

    private static void addIntervalToTrueIntervalsBuilder(ImmutableList.Builder<ValueInterval> trueIntervalsBuilder, ValueOrder order, Value startValue, boolean includeStart, @Nullable Value endValue, boolean includeEnd) {
        if (!(endValue == null || includeStart && includeEnd || !startValue.equals(endValue))) {
            return;
        }
        ValueInterval interval = ValueInterval.create(order, startValue, includeStart, endValue, includeEnd);
        trueIntervalsBuilder.add((Object)interval);
    }

    public final String toString() {
        return this.trueIntervals().toString();
    }
}

