/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlUnescaper;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;

public class GoogleSqlPropertyPathToRepConverter {
    public static final GoogleSqlPropertyPathToRepConverter NAME_INSTANCE = new GoogleSqlPropertyPathToRepConverter(ReservedName.NAME.asString());
    private final String entityKeyPropertyName;
    private static final String ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE = "Invalid property path \"%s\".";
    private static final String EMPTY_PROPERTY_PATH_STRING_ERROR_MESSAGE = "Invalid empty property path string.";
    private static final String UNQUOTED_NAME_REGEX_STRING = "([a-zA-Z_][a-zA-Z_0-9]*)";
    private static final String QUOTED_NAME_REGEX_STRING = "(`(?:[^`\\\\]|(?:\\\\.))+`)";
    private static final String INDEX_REGEX_STRING = "(?:\\[(\\d+)\\])";
    private static final String PROPERTY_PATH_FIRST_SEGMENT_REGEX_STRING = String.format("(?:%s|%s)", "([a-zA-Z_][a-zA-Z_0-9]*)", "(`(?:[^`\\\\]|(?:\\\\.))+`)");
    private static final String PROPERTY_PATH_REMAINING_SEGMENT_REGEX_STRING = String.format("(?:(?:\\.(?:%s|%s))|%s)", "([a-zA-Z_][a-zA-Z_0-9]*)", "(`(?:[^`\\\\]|(?:\\\\.))+`)", "(?:\\[(\\d+)\\])");
    static final Pattern UNQUOTED_PROPERTY_NAME_REGEX = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)");
    public static final String PROPERTY_PATH_REGEX_STRING = String.format("(?:%s%s*)", PROPERTY_PATH_FIRST_SEGMENT_REGEX_STRING, PROPERTY_PATH_REMAINING_SEGMENT_REGEX_STRING);
    private static final Pattern PROPERTY_PATH_FIRST_OPERATION_REGEX = Pattern.compile(PROPERTY_PATH_FIRST_SEGMENT_REGEX_STRING, 2);
    private static final Pattern PROPERTY_PATH_REST_OPERATION_REGEX = Pattern.compile(PROPERTY_PATH_REMAINING_SEGMENT_REGEX_STRING, 2);
    private static final int PROPERTY_PATH_UNQUOTED_NAME_GROUP = 1;
    private static final int PROPERTY_PATH_QUOTED_NAME_GROUP = 2;

    private GoogleSqlPropertyPathToRepConverter(String entityKeyPropertyName) {
        this.entityKeyPropertyName = entityKeyPropertyName;
    }

    public PropertyPath convertPropertyPath(String stringPath) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!stringPath.isEmpty(), EMPTY_PROPERTY_PATH_STRING_ERROR_MESSAGE, new Object[0]);
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>();
        int endPathStringIndex = stringPath.length();
        Matcher segmentMatcher = PROPERTY_PATH_FIRST_OPERATION_REGEX.matcher(stringPath);
        boolean foundMatch = segmentMatcher.lookingAt();
        InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
        segments.add(this.makeSegmentFromSegmentMatcher(stringPath, segmentMatcher));
        int startNextOpPathIndex = segmentMatcher.end();
        if (startNextOpPathIndex < endPathStringIndex) {
            segmentMatcher = PROPERTY_PATH_REST_OPERATION_REGEX.matcher(stringPath);
            do {
                foundMatch = segmentMatcher.find(startNextOpPathIndex) && segmentMatcher.start() == startNextOpPathIndex;
                InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
                PropertyPathSegment segment = this.makeSegmentFromSegmentMatcher(stringPath, segmentMatcher);
                segments.add(segment);
            } while ((startNextOpPathIndex = segmentMatcher.end()) < endPathStringIndex);
        }
        return PropertyPath.createFromSegments(segments);
    }

    private PropertyPathSegment makeSegmentFromSegmentMatcher(String stringPath, Matcher segmentMatcher) throws InvalidConversionException {
        String nameString = segmentMatcher.group(1);
        if (nameString != null) {
            return PropertyPathSegment.Member.create(this.convertPropertyName(nameString));
        }
        nameString = segmentMatcher.group(2);
        if (nameString != null) {
            String unescapedText = GoogleSqlUnescaper.unescapeIdentifier(nameString);
            InvalidConversionException.checkConversion(unescapedText != null, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
            return PropertyPathSegment.Member.create(this.convertPropertyName(unescapedText));
        }
        throw new InvalidConversionException(String.format(ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath));
    }

    private PropertyName convertPropertyName(String nameString) throws InvalidConversionException {
        if (nameString.equals(this.entityKeyPropertyName)) {
            return PropertyName.KEY;
        }
        PropertyName propertyName = PropertyName.create(nameString);
        InvalidConversionException.checkConversion(!propertyName.isKey(), "Invalid property path member name \"%s\".", PropertyName.KEY.string());
        return propertyName;
    }
}

