/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.admininternal.ExternalIndexResource;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.InvalidProtocolBufferException;

public class IndexResourceConverterHelper {
    public static long indexResourceIdToIndexId(String stringIndexId) throws InvalidConversionException {
        try {
            ExternalIndexResource indexResource = ExternalIndexResource.parseFrom((byte[])BaseEncoding.base64Url().decode(stringIndexId));
            return indexResource.getIndexId();
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            throw new InvalidConversionException(String.format("Invalid index resource id \"%s\".", stringIndexId), e);
        }
    }

    public static String indexIdToIndexResourceId(long indexId) {
        ExternalIndexResource indexResource = ExternalIndexResource.newBuilder().setIndexId(indexId).build();
        return BaseEncoding.base64Url().omitPadding().encode(indexResource.toByteArray());
    }
}

