/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.common.base.Utf8;
import com.google.protobuf.TimestampOrBuilder;

public final class ValidationUtils {
    public static final ValidationUtils INSTANCE = new ValidationUtils();

    private ValidationUtils() {
    }

    public void validateStringUtf8(byte[] bytes, String desc) throws ValidationException {
        ValidationException.validateAssertion(Utf8.isWellFormed(bytes), "The %s is not valid UTF-8.", desc);
    }

    public void validateTimestamp(TimestampOrBuilder timestamp) throws ValidationException {
        ValidationException.validateAssertion(timestamp.getNanos() >= 0 && timestamp.getNanos() < 1000000000, "Timestamp nanos exceeds limit for field", new Object[0]);
        ValidationException.validateAssertion(RepHelper.isSecondsInTimestampBounds(timestamp.getSeconds()), "Timestamp seconds exceeds limit for field", new Object[0]);
    }

    public String toPathString(EntityRef.Path path) {
        if (path.size() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (EntityRef.PathElement element : path.elements()) {
            String kind = element.collectionId();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.resourceId() != null) {
                if (element.resourceId().isLong()) {
                    stringBuilder.append(element.resourceId().asLong());
                } else if (element.resourceId().isString()) {
                    stringBuilder.append(element.resourceId().asString());
                }
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

