/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.stats;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.common.math.LongMath;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class GenericStats {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/core/stats/GenericStats");
    private final CategoryTypeMismatchReporter mismatchReporter;
    private final Map<Class<?>, Stats<?, ?>> statsByEnum = new HashMap();
    protected final Function<Enum<?>, SummingStat> summingBuilder = c -> new SummingStat((Enum<?>)c);
    public static final Function<Enum<?>, Supplier<Duration>> SYSTEM_TIMING = GenericStats.simpleTiming(System::nanoTime);
    protected final Function<Enum<?>, LabelStat> labelBuilder = c -> new LabelStat((Enum<?>)c);
    protected final Function<Enum<?>, MultiStat> multiBuilder = c -> new MultiStat((Enum)c);

    protected Function<Enum<?>, DurationStat> durationBuilder(Function<Enum<?>, Supplier<Duration>> timing) {
        return c -> new DurationStat(timing, (Enum<?>)c);
    }

    public static final Function<Enum<?>, Supplier<Duration>> simpleTiming(Supplier<Long> nanoTimeSupplier) {
        return unused -> {
            long startTimeNanos = (Long)nanoTimeSupplier.get();
            return () -> GenericStats.lambda$simpleTiming$2((Supplier)nanoTimeSupplier, startTimeNanos);
        };
    }

    protected GenericStats(CategoryTypeMismatchReporter mismatchReporter) {
        this.mismatchReporter = Preconditions.checkNotNull(mismatchReporter);
    }

    @CheckReturnValue
    protected <C extends Enum<C>, F extends RawStat> Stats<C, F> register(Class<C> clazz, Function<? super C, ? extends F> categoryBuilder) {
        Stats<? super C, ? extends F> foos = new Stats<C, F>(clazz, categoryBuilder);
        this.statsByEnum.put(clazz, foos);
        return foos;
    }

    @CheckReturnValue
    public Set<Class<?>> enums() {
        return this.statsByEnum.keySet();
    }

    @CheckReturnValue
    public Object rawStat(Enum<?> category) {
        return this.statsByEnum.get(category.getDeclaringClass()).rawStat(category);
    }

    public void combine(GenericStats moreStats) {
        for (Map.Entry<Class<?>, Stats<?, ?>> moreEntries : moreStats.statsByEnum.entrySet()) {
            this.statsByEnum.get(moreEntries.getKey()).combine(moreEntries.getValue());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(1024);
        boolean commaNeeded = false;
        for (Stats<?, ?> stats : this.statsByEnum.values()) {
            commaNeeded = stats.buildString(builder, commaNeeded);
        }
        return builder.toString();
    }

    public void reportTypeMismatch(Enum<?> category, Object value, Class<?> expectedType) {
        String string = String.valueOf(expectedType);
        this.reportTypeMismatch(category, value, new StringBuilder(5 + String.valueOf(string).length()).append("type ").append(string).toString());
    }

    public void reportTypeMismatch(Enum<?> category, Object value, String expected) {
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).atMostEvery(30, TimeUnit.SECONDS)).withInjectedLogSite("com/google/cloud/datastore/core/stats/GenericStats", "reportTypeMismatch", 523, "GenericStats.java")).log("incorrect value %s in stats category %s - expected %s", value, category, expected);
        this.mismatchReporter.report(category);
    }

    private static /* synthetic */ Duration lambda$simpleTiming$2(Supplier nanoTimeSupplier, long startTimeNanos) {
        return Duration.ofNanos((Long)nanoTimeSupplier.get() - startTimeNanos);
    }

    protected static abstract class RawStat {
        protected final Enum<?> category;

        protected RawStat(Enum<?> category) {
            this.category = Preconditions.checkNotNull(category);
        }

        protected abstract void combine(Object var1);

        @Nullable
        protected abstract Object raw();
    }

    public static interface CategoryTypeMismatchReporter {
        public static final CategoryTypeMismatchReporter NOP = category -> {};

        public void report(Enum<?> var1);
    }

    protected static class Stats<C extends Enum<C>, F extends RawStat> {
        private static final AtomicLong uniqueIds = new AtomicLong();
        private final long uniqueId;
        @GuardedBy(value="this")
        private final EnumMap<C, F> stats;
        private final Function<? super C, ? extends F> categoryBuilder;

        protected Stats(Class<C> clazz, Function<? super C, ? extends F> categoryBuilder) {
            this.stats = new EnumMap(clazz);
            this.categoryBuilder = categoryBuilder;
            this.uniqueId = uniqueIds.incrementAndGet();
        }

        public synchronized F stat(C category) {
            if (!this.stats.containsKey(category)) {
                this.stats.put(category, (F)((RawStat)this.categoryBuilder.apply(category)));
            }
            return (F)((RawStat)this.stats.get(category));
        }

        Object rawStat(Enum<?> category) {
            Enum<?> realCategory = category;
            return ((RawStat)this.stat(realCategory)).raw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void combine(Stats<?, ?> other) {
            Stats<?, ?> high;
            Stats<?, ?> low;
            if (this.uniqueId < other.uniqueId) {
                low = this;
                high = other;
            } else {
                low = other;
                high = this;
            }
            Stats<?, ?> stats = low;
            synchronized (stats) {
                Stats<?, ?> stats2 = high;
                synchronized (stats2) {
                    EnumMap<C, F> otherStats = other.stats;
                    for (Map.Entry<C, F> otherStat : otherStats.entrySet()) {
                        ((RawStat)this.stat((Enum)otherStat.getKey())).combine(((RawStat)otherStat.getValue()).raw());
                    }
                }
            }
        }

        synchronized boolean buildString(StringBuilder builder, boolean commaNeeded) {
            for (Map.Entry<C, F> stat : this.stats.entrySet()) {
                Object raw = ((RawStat)stat.getValue()).raw();
                if (raw == null) continue;
                if (commaNeeded) {
                    builder.append(", ");
                }
                String statName = Ascii.toLowerCase(((Enum)stat.getKey()).name());
                builder.append(statName).append("=").append(raw);
                commaNeeded = true;
            }
            return commaNeeded;
        }
    }

    public class MultiStat
    extends RawStat {
        @GuardedBy(value="this")
        List<Object> values;

        private MultiStat(Enum<?> category) {
            super(category);
        }

        public synchronized void add(Object value) {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            this.values.add(value);
        }

        @CheckReturnValue
        public synchronized <T> List<T> get(Class<T> clazz) {
            if (this.values == null) {
                return ImmutableList.of();
            }
            for (Object entry : this.values) {
                if (clazz.isInstance(entry)) continue;
                GenericStats.this.reportTypeMismatch(this.category, entry, clazz);
                return ImmutableList.of();
            }
            List<Object> result = this.values;
            return result;
        }

        @CheckReturnValue
        public <T> ImmutableSet<T> asSet(Class<T> clazz) {
            return ImmutableSet.copyOf(this.get(clazz));
        }

        @Override
        @Nullable
        protected synchronized Object raw() {
            return this.values;
        }

        @Override
        protected synchronized void combine(Object newValue) {
            if (newValue instanceof List) {
                if (this.values == null) {
                    this.values = new ArrayList<Object>();
                }
                List newValues = (List)newValue;
                this.values.addAll(newValues);
            } else if (newValue != null) {
                GenericStats.this.reportTypeMismatch(this.category, newValue, List.class);
            }
        }
    }

    public class LabelStat
    extends RawStat {
        @Nullable
        @GuardedBy(value="this")
        Object value;

        LabelStat(Enum<?> category) {
            super(category);
        }

        public synchronized void set(Object value) {
            this.value = value;
        }

        public void set(long value) {
            this.set((Object)value);
        }

        @CheckReturnValue
        @Nullable
        public <T> T getIfPresent(Class<T> clazz) {
            return this.get(null, clazz);
        }

        @CheckReturnValue
        public <T> T get(T defaultValue) {
            Class<?> clazz = defaultValue.getClass();
            return this.get(defaultValue, clazz);
        }

        @CheckReturnValue
        public long get() {
            return this.get(0L);
        }

        private synchronized <T> T get(T defaultValue, Class<T> clazz) {
            if (this.value == null) {
                return defaultValue;
            }
            if (clazz.isInstance(this.value)) {
                return clazz.cast(this.value);
            }
            GenericStats.this.reportTypeMismatch(this.category, this.value, clazz);
            return defaultValue;
        }

        @Override
        @Nullable
        protected synchronized Object raw() {
            return this.value;
        }

        @Override
        protected void combine(Object newValue) {
            this.set(newValue);
        }
    }

    public class DurationStat
    extends RawStat {
        private final Function<Enum<?>, Supplier<Duration>> timing;
        @Nullable
        Duration value;

        DurationStat(Function<Enum<?>, Supplier<Duration>> timing, Enum<?> category) {
            super(category);
            this.timing = Preconditions.checkNotNull(timing);
        }

        public Duration get() {
            return this.value != null ? this.value : Duration.ZERO;
        }

        public StatsAutoCloseable enter() {
            Supplier<Duration> closer = this.timing.apply(this.category);
            return () -> this.accumulate((Duration)closer.get());
        }

        private synchronized void accumulate(Duration duration) {
            this.value = this.value != null ? this.value.plus(duration) : duration;
        }

        @Override
        @Nullable
        protected synchronized Object raw() {
            return this.value;
        }

        @Override
        protected void combine(Object newValue) {
            if (newValue instanceof Duration) {
                this.accumulate((Duration)newValue);
            } else {
                GenericStats.this.reportTypeMismatch(this.category, newValue, Duration.class);
            }
        }
    }

    public static interface StatsAutoCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public class SummingStat
    extends RawStat {
        @GuardedBy(value="this")
        long value;
        @GuardedBy(value="this")
        boolean set;

        SummingStat(Enum<?> category) {
            super(category);
            this.set = false;
        }

        @CheckReturnValue
        public synchronized long get() {
            return this.value;
        }

        public synchronized void accumulate(long add) {
            if (add < 0L) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).atMostEvery(1, TimeUnit.HOURS)).withInjectedLogSite("com/google/cloud/datastore/core/stats/GenericStats$SummingStat", "accumulate", 87, "GenericStats.java")).log("negative accumulate");
                add = 0L;
            }
            this.value = LongMath.saturatedAdd(this.value, add);
            this.set = true;
        }

        @Override
        @Nullable
        protected synchronized Object raw() {
            return this.set ? Long.valueOf(this.value) : null;
        }

        @Override
        protected void combine(Object newValue) {
            if (newValue instanceof Long) {
                this.accumulate((Long)newValue);
            } else {
                GenericStats.this.reportTypeMismatch(this.category, newValue, Long.class);
            }
        }
    }
}

