/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.util.ComparingSupplier;
import com.google.cloud.datastore.core.util.DatastoreSupplier;
import java.util.function.BiPredicate;

final class AutoValue_ComparingSupplier<T>
extends ComparingSupplier<T> {
    private final DatastoreSupplier<T> currentSupplier;
    private final DatastoreSupplier<T> newSupplier;
    private final boolean useNewSupplier;
    private final boolean compareSuppliers;
    private final BiPredicate<T, T> comparator;
    private final BiPredicate<DatastoreException, DatastoreException> exceptionComparator;
    private final ComparingSupplier.DifferenceHandler<T> onDifferenceHandler;

    private AutoValue_ComparingSupplier(DatastoreSupplier<T> currentSupplier, DatastoreSupplier<T> newSupplier, boolean useNewSupplier, boolean compareSuppliers, BiPredicate<T, T> comparator, BiPredicate<DatastoreException, DatastoreException> exceptionComparator, ComparingSupplier.DifferenceHandler<T> onDifferenceHandler) {
        this.currentSupplier = currentSupplier;
        this.newSupplier = newSupplier;
        this.useNewSupplier = useNewSupplier;
        this.compareSuppliers = compareSuppliers;
        this.comparator = comparator;
        this.exceptionComparator = exceptionComparator;
        this.onDifferenceHandler = onDifferenceHandler;
    }

    @Override
    DatastoreSupplier<T> currentSupplier() {
        return this.currentSupplier;
    }

    @Override
    DatastoreSupplier<T> newSupplier() {
        return this.newSupplier;
    }

    @Override
    boolean useNewSupplier() {
        return this.useNewSupplier;
    }

    @Override
    boolean compareSuppliers() {
        return this.compareSuppliers;
    }

    @Override
    BiPredicate<T, T> comparator() {
        return this.comparator;
    }

    @Override
    BiPredicate<DatastoreException, DatastoreException> exceptionComparator() {
        return this.exceptionComparator;
    }

    @Override
    ComparingSupplier.DifferenceHandler<T> onDifferenceHandler() {
        return this.onDifferenceHandler;
    }

    public String toString() {
        String string = String.valueOf(this.currentSupplier);
        String string2 = String.valueOf(this.newSupplier);
        boolean bl = this.useNewSupplier;
        boolean bl2 = this.compareSuppliers;
        String string3 = String.valueOf(this.comparator);
        String string4 = String.valueOf(this.exceptionComparator);
        String string5 = String.valueOf(this.onDifferenceHandler);
        return new StringBuilder(152 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("ComparingSupplier{currentSupplier=").append(string).append(", newSupplier=").append(string2).append(", useNewSupplier=").append(bl).append(", compareSuppliers=").append(bl2).append(", comparator=").append(string3).append(", exceptionComparator=").append(string4).append(", onDifferenceHandler=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ComparingSupplier) {
            ComparingSupplier that = (ComparingSupplier)o;
            return this.currentSupplier.equals(that.currentSupplier()) && this.newSupplier.equals(that.newSupplier()) && this.useNewSupplier == that.useNewSupplier() && this.compareSuppliers == that.compareSuppliers() && this.comparator.equals(that.comparator()) && this.exceptionComparator.equals(that.exceptionComparator()) && this.onDifferenceHandler.equals(that.onDifferenceHandler());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.currentSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.newSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.useNewSupplier ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.compareSuppliers ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.comparator.hashCode();
        h$ *= 1000003;
        h$ ^= this.exceptionComparator.hashCode();
        h$ *= 1000003;
        return h$ ^= this.onDifferenceHandler.hashCode();
    }

    static final class Builder<T>
    extends ComparingSupplier.Builder<T> {
        private DatastoreSupplier<T> currentSupplier;
        private DatastoreSupplier<T> newSupplier;
        private Boolean useNewSupplier;
        private Boolean compareSuppliers;
        private BiPredicate<T, T> comparator;
        private BiPredicate<DatastoreException, DatastoreException> exceptionComparator;
        private ComparingSupplier.DifferenceHandler<T> onDifferenceHandler;

        Builder() {
        }

        @Override
        public ComparingSupplier.Builder<T> currentSupplier(DatastoreSupplier<T> currentSupplier) {
            if (currentSupplier == null) {
                throw new NullPointerException("Null currentSupplier");
            }
            this.currentSupplier = currentSupplier;
            return this;
        }

        @Override
        public ComparingSupplier.Builder<T> newSupplier(DatastoreSupplier<T> newSupplier) {
            if (newSupplier == null) {
                throw new NullPointerException("Null newSupplier");
            }
            this.newSupplier = newSupplier;
            return this;
        }

        @Override
        public ComparingSupplier.Builder<T> useNewSupplier(boolean useNewSupplier) {
            this.useNewSupplier = useNewSupplier;
            return this;
        }

        @Override
        public ComparingSupplier.Builder<T> compareSuppliers(boolean compareSuppliers) {
            this.compareSuppliers = compareSuppliers;
            return this;
        }

        @Override
        public ComparingSupplier.Builder<T> comparator(BiPredicate<T, T> comparator) {
            if (comparator == null) {
                throw new NullPointerException("Null comparator");
            }
            this.comparator = comparator;
            return this;
        }

        @Override
        public ComparingSupplier.Builder<T> exceptionComparator(BiPredicate<DatastoreException, DatastoreException> exceptionComparator) {
            if (exceptionComparator == null) {
                throw new NullPointerException("Null exceptionComparator");
            }
            this.exceptionComparator = exceptionComparator;
            return this;
        }

        @Override
        protected ComparingSupplier.Builder<T> onDifferenceHandler(ComparingSupplier.DifferenceHandler<T> onDifferenceHandler) {
            if (onDifferenceHandler == null) {
                throw new NullPointerException("Null onDifferenceHandler");
            }
            this.onDifferenceHandler = onDifferenceHandler;
            return this;
        }

        @Override
        protected ComparingSupplier.DifferenceHandler<T> onDifferenceHandler() {
            if (this.onDifferenceHandler == null) {
                throw new IllegalStateException("Property \"onDifferenceHandler\" has not been set");
            }
            return this.onDifferenceHandler;
        }

        @Override
        public ComparingSupplier<T> build() {
            String missing = "";
            if (this.currentSupplier == null) {
                missing = String.valueOf(missing).concat(" currentSupplier");
            }
            if (this.newSupplier == null) {
                missing = String.valueOf(missing).concat(" newSupplier");
            }
            if (this.useNewSupplier == null) {
                missing = String.valueOf(missing).concat(" useNewSupplier");
            }
            if (this.compareSuppliers == null) {
                missing = String.valueOf(missing).concat(" compareSuppliers");
            }
            if (this.comparator == null) {
                missing = String.valueOf(missing).concat(" comparator");
            }
            if (this.exceptionComparator == null) {
                missing = String.valueOf(missing).concat(" exceptionComparator");
            }
            if (this.onDifferenceHandler == null) {
                missing = String.valueOf(missing).concat(" onDifferenceHandler");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ComparingSupplier(this.currentSupplier, this.newSupplier, this.useNewSupplier, this.compareSuppliers, this.comparator, this.exceptionComparator, this.onDifferenceHandler);
        }
    }
}

