/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.util.DatastoreSupplier;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.flogger.GoogleLogger;
import java.util.function.Function;
import java.util.function.Supplier;

public class DatastoreSuppliers {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/core/util/DatastoreSuppliers");

    private DatastoreSuppliers() {
    }

    public static <K, T> Supplier<T> memoizeForKey(Supplier<K> key, Function<K, T> value) {
        LoadingCache singleValue = CacheBuilder.newBuilder().maximumSize(1L).build(CacheLoader.from(k -> {
            Object result = value.apply(k);
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/core/util/DatastoreSuppliers", "lambda$memoizeForKey$0", 38, "DatastoreSuppliers.java")).log("Recalculating with %s to get %s", k, (Object)result.getClass().getSimpleName());
            return result;
        }));
        return () -> singleValue.getUnchecked(key.get());
    }

    public static <T> DatastoreSupplier.SingletonDatastoreSupplier<T> memoize(DatastoreSupplier<T> delegate) {
        if (delegate instanceof DatastoreSupplier.SingletonDatastoreSupplier) {
            return (DatastoreSupplier.SingletonDatastoreSupplier)delegate;
        }
        return new MemoizingSupplier<T>(delegate);
    }

    public static <T> DatastoreSupplier.SingletonDatastoreSupplier<T> ofInstance(T t) {
        return new InstanceSupplier<T>(t);
    }

    private static class MemoizingSupplier<T>
    implements DatastoreSupplier.SingletonDatastoreSupplier<T> {
        private final DatastoreSupplier<T> delegate;
        private boolean initialized = false;
        private T value;

        MemoizingSupplier(DatastoreSupplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        public synchronized T get() throws DatastoreException {
            if (!this.initialized) {
                this.value = this.delegate.get();
                this.initialized = true;
            }
            return this.value;
        }
    }

    private static class InstanceSupplier<T>
    implements DatastoreSupplier.SingletonDatastoreSupplier<T> {
        private final T instance;

        InstanceSupplier(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }
}

