/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.cloud.datastore.core.util.DatastoreSuppliers;
import java.util.ArrayDeque;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public abstract class ReplaceableGlobalSupplier<K, T> {
    @Nullable
    private ArrayDeque<T> mocked = new ArrayDeque();
    private Supplier<T> value;

    @CheckReturnValue
    public static <K, T> ReplaceableGlobalSupplier<K, T> create(final Supplier<K> getKey, final Function<K, T> makeValue) {
        return new ReplaceableGlobalSupplier<K, T>(){

            @Override
            public K getKey() {
                return getKey.get();
            }

            @Override
            protected T buildWithKey(K key) {
                return makeValue.apply(key);
            }
        };
    }

    public abstract K getKey();

    protected abstract T buildWithKey(K var1);

    public ReplaceableGlobalSupplier() {
        this.reset();
    }

    public T get() {
        if (!this.mocked.isEmpty()) {
            return this.mocked.getLast();
        }
        return this.value.get();
    }

    @CheckReturnValue
    public AutoCloseable replaceForTestingWith(T mockT) {
        this.mocked.push(mockT);
        return () -> {
            T out = this.mocked.pop();
            if (out != mockT) {
                throw new IllegalArgumentException("Must pop in order.");
            }
        };
    }

    public void reset() {
        this.value = DatastoreSuppliers.memoizeForKey(() -> this.getKey(), k -> this.buildWithKey(k));
    }
}

