/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.cli;

import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import com.google.cloud.datastore.emulator.cli.EmulatorCli;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class EmulatorAction
extends Action {
    private final String command;
    private final String usage;

    public EmulatorAction(String command, String name, String shortDescription, String usage) {
        super(name);
        this.command = command;
        this.usage = usage;
        this.setShortDescription(shortDescription);
        this.setOptions(ImmutableList.of());
    }

    @Override
    protected List<String> getHelpLines() {
        LinkedList<String> helpLines = Lists.newLinkedList();
        helpLines.add(this.getNameString());
        helpLines.add("");
        helpLines.addAll(EmulatorCli.wrap(this.getShortDescription(), 80, 0));
        helpLines.add("");
        String string = this.command;
        String string2 = this.getNameString();
        String string3 = this.usage;
        helpLines.add(new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Usage: ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        if (!this.getOptions().isEmpty()) {
            helpLines.add("");
            helpLines.add("Options:");
            for (Option option : this.getOptions()) {
                for (String optionHelpLine : option.getHelpLines()) {
                    String string4 = String.valueOf(Strings.repeat(" ", 2));
                    String string5 = String.valueOf(optionHelpLine);
                    helpLines.add(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
            }
        }
        helpLines.add("");
        return helpLines;
    }

    protected final String consumeLastArg() {
        List<String> args = this.getArgs();
        if (args.isEmpty()) {
            this.printCommandUsageAndExit();
        }
        String arg = Iterables.getLast(args);
        this.setArgs(args.subList(0, args.size() - 1));
        return arg;
    }

    protected final void printCommandUsageAndExit() {
        System.out.println(this.getHelpString());
        throw new IllegalArgumentException();
    }

    protected final void checkValidProjectDirectory(String projectDirPath) {
        File projectDir = new File(projectDirPath);
        if (!(projectDir.exists() || projectDir.getParentFile() != null && projectDir.getParentFile().isDirectory())) {
            throw new IllegalArgumentException(String.format("Invalid project directory: %s", projectDir.getParent()));
        }
        if (projectDir.exists() && !projectDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Invalid project directory: %s", projectDir));
        }
    }

    protected final void checkArgsEmpty() {
        if (!this.getArgs().isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected option(s): %s.", Joiner.on(" ").join(this.getArgs())));
        }
    }
}

