/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulator;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1Router;
import com.google.cloud.datastore.emulator.impl.util.WrappedStreamObserver;
import com.google.firestore.emulator.v1.ClearDataRequest;
import com.google.firestore.emulator.v1.CreateTriggerRequest;
import com.google.firestore.emulator.v1.CreateTriggerResponse;
import com.google.firestore.emulator.v1.FirestoreEmulatorGrpc;
import com.google.firestore.emulator.v1.GetRuleCoverageRequest;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.firestore.emulator.v1.SetSecurityRulesRequest;
import com.google.firestore.emulator.v1.SetSecurityRulesResponse;
import com.google.protobuf.Empty;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;

public final class EmulatorAuxiliaryGrpcAdapter {
    private final CloudFirestoreV1Router router;
    private final FirestoreEmulatorGrpc.FirestoreEmulatorImplBase auxiliaryImpl = new FirestoreEmulatorGrpc.FirestoreEmulatorImplBase(){

        @Override
        public void setSecurityRules(SetSecurityRulesRequest request, StreamObserver<SetSecurityRulesResponse> responseObserver) {
            EmulatorAuxiliaryGrpcAdapter.unary(responseObserver, () -> EmulatorAuxiliaryGrpcAdapter.this.router.setSecurityRules(request));
        }

        @Override
        public void clearData(ClearDataRequest request, StreamObserver<Empty> responseObserver) {
            EmulatorAuxiliaryGrpcAdapter.unary(responseObserver, () -> {
                EmulatorAuxiliaryGrpcAdapter.this.router.clearData(request);
                return Empty.getDefaultInstance();
            });
        }

        @Override
        public void getRuleCoverage(GetRuleCoverageRequest request, StreamObserver<RuleCoverageReport> responseObserver) {
            EmulatorAuxiliaryGrpcAdapter.unary(responseObserver, () -> EmulatorAuxiliaryGrpcAdapter.this.router.getRuleCoverage(request));
        }

        @Override
        public void createTrigger(CreateTriggerRequest request, StreamObserver<CreateTriggerResponse> responseObserver) {
            EmulatorAuxiliaryGrpcAdapter.unary(responseObserver, () -> EmulatorAuxiliaryGrpcAdapter.this.router.createTrigger(request));
        }
    };

    private EmulatorAuxiliaryGrpcAdapter(CloudFirestoreV1Router router) {
        this.router = router;
    }

    public static ServerServiceDefinition build(FirestoreEmulator emulator) {
        EmulatorAuxiliaryGrpcAdapter adapter = new EmulatorAuxiliaryGrpcAdapter(emulator.firestoreV1Router());
        return adapter.auxiliaryImpl.bindService();
    }

    private static <T> void unary(StreamObserver<T> responseObserver, UnaryRpc<T> supplier) {
        WrappedStreamObserver<T> wrapped = new WrappedStreamObserver<T>(responseObserver);
        try {
            wrapped.onNext(supplier.process());
            wrapped.onCompleted();
        }
        catch (Throwable t) {
            wrapped.onError(t);
        }
    }

    private static interface UnaryRpc<T> {
        public T process() throws DatastoreException;
    }
}

