/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore;

import com.google.common.base.Ascii;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.gapi.emulators.grpc.HttpAdapter;
import io.gapi.emulators.grpc.JsonFormat;
import io.gapi.emulators.util.Observer;
import io.grpc.Status;
import io.grpc.StatusException;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;

@ChannelHandler.Sharable
public abstract class HttpHtmlAdapter<T>
extends HttpAdapter {
    private static final String HTML_CONTENT_TYPE = "text/html";
    private final JsonFormat.Parser parser;

    public HttpHtmlAdapter() {
        this(JsonFormat.TypeRegistry.getEmptyTypeRegistry());
    }

    public HttpHtmlAdapter(JsonFormat.TypeRegistry registry) {
        this.parser = JsonFormat.parser().usingTypeRegistry(registry);
    }

    @Override
    public void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        if (!Ascii.toLowerCase(request.uri()).endsWith(".html")) {
            observer.onValue(null);
            return;
        }
        String uri = request.uri();
        FullHttpRequest strippedRequest = request.copy().setUri(uri.substring(0, uri.length() - 5));
        super.handleRequest(strippedRequest, observer);
    }

    @Override
    protected boolean canHandleRequest(FullHttpRequest request) {
        String contentType = HttpHtmlAdapter.getContentType(request);
        return contentType.isEmpty() || contentType.contains(HTML_CONTENT_TYPE);
    }

    @Override
    protected void postprocessResponse(FullHttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HTML_CONTENT_TYPE);
    }

    @Override
    protected ByteString toResponse(Message message) throws StatusException {
        return ByteString.copyFromUtf8(this.generateHtml(this.checkedCast(message)));
    }

    @Override
    protected ByteString toResponse(Status status) {
        return ByteString.copyFromUtf8(this.formatError(status));
    }

    private T checkedCast(Message message) throws StatusException {
        try {
            return (T)message;
        }
        catch (ClassCastException e) {
            throw Status.INTERNAL.withCause(e).asException();
        }
    }

    @Override
    protected void merge(ByteString input, Message.Builder builder) throws InvalidProtocolBufferException {
        this.parser.merge(input.toStringUtf8(), builder);
    }

    protected abstract String generateHtml(T var1) throws StatusException;

    protected String formatError(Status status) {
        String string = String.valueOf(status);
        return new StringBuilder(96 + String.valueOf(string).length()).append("<!DOCTYPE html><html><head><meta charset=\"utf-8\"><title>Error</title></head><body>").append(string).append("</body></html>").toString();
    }
}

