/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore.v1;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulator;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1Router;
import com.google.cloud.datastore.emulator.impl.util.WrappedStreamObserver;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.GetOrListDocumentsRequest;
import com.google.firestore.v1.GetOrListDocumentsResponse;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.Empty;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;
import java.util.List;

public class FirestoreV1GrpcAdapter {
    private final CloudFirestoreV1Router router;
    private final FirestoreGrpc.FirestoreImplBase firestoreImpl = new FirestoreGrpc.FirestoreImplBase(){

        @Override
        public void getOrListDocuments(GetOrListDocumentsRequest request, StreamObserver<GetOrListDocumentsResponse> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.getOrListDocuments(request));
        }

        @Override
        public void getDocument(GetDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.getDocument(request));
        }

        @Override
        public void listDocuments(ListDocumentsRequest request, StreamObserver<ListDocumentsResponse> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.listDocuments(request));
        }

        @Override
        public void createDocument(CreateDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.createDocument(request));
        }

        @Override
        public void updateDocument(UpdateDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.updateDocument(request));
        }

        @Override
        public void deleteDocument(DeleteDocumentRequest request, StreamObserver<Empty> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> {
                FirestoreV1GrpcAdapter.this.router.deleteDocument(request);
                return Empty.getDefaultInstance();
            });
        }

        @Override
        public void batchGetDocuments(BatchGetDocumentsRequest request, StreamObserver<BatchGetDocumentsResponse> responseObserver) {
            FirestoreV1GrpcAdapter.streaming(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.batchGetDocuments(request));
        }

        @Override
        public void beginTransaction(BeginTransactionRequest request, StreamObserver<BeginTransactionResponse> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.beginTransaction(request));
        }

        @Override
        public void commit(CommitRequest request, StreamObserver<CommitResponse> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.commit(request));
        }

        @Override
        public void rollback(RollbackRequest request, StreamObserver<Empty> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> {
                FirestoreV1GrpcAdapter.this.router.rollback(request);
                return Empty.getDefaultInstance();
            });
        }

        @Override
        public void runQuery(RunQueryRequest request, StreamObserver<RunQueryResponse> responseObserver) {
            FirestoreV1GrpcAdapter.streaming(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.runQuery(request));
        }

        @Override
        public StreamObserver<WriteRequest> write(StreamObserver<WriteResponse> responseObserver) {
            return FirestoreV1GrpcAdapter.bidi(responseObserver, FirestoreV1GrpcAdapter.this.router::writeStream);
        }

        @Override
        public StreamObserver<ListenRequest> listen(StreamObserver<ListenResponse> responseObserver) {
            return FirestoreV1GrpcAdapter.bidi(responseObserver, FirestoreV1GrpcAdapter.this.router::listenStream);
        }

        @Override
        public void listCollectionIds(ListCollectionIdsRequest request, StreamObserver<ListCollectionIdsResponse> responseObserver) {
            FirestoreV1GrpcAdapter.unary(responseObserver, () -> FirestoreV1GrpcAdapter.this.router.listCollectionIds(request));
        }
    };

    private FirestoreV1GrpcAdapter(CloudFirestoreV1Router router) {
        this.router = router;
    }

    public static ServerServiceDefinition build(FirestoreEmulator emulator) {
        FirestoreV1GrpcAdapter adapter = new FirestoreV1GrpcAdapter(emulator.firestoreV1Router());
        return adapter.firestoreImpl.bindService();
    }

    private static <T> void unary(StreamObserver<T> responseObserver, UnaryRpc<T> supplier) {
        WrappedStreamObserver<T> wrapped = new WrappedStreamObserver<T>(responseObserver);
        try {
            wrapped.onNext(supplier.process());
            wrapped.onCompleted();
        }
        catch (Throwable t) {
            wrapped.onError(t);
        }
    }

    private static <T> void streaming(StreamObserver<T> responseObserver, StreamingRpc<T> supplier) {
        WrappedStreamObserver<T> wrapped = new WrappedStreamObserver<T>(responseObserver);
        try {
            for (T t : supplier.process()) {
                wrapped.onNext(t);
            }
            wrapped.onCompleted();
        }
        catch (Throwable e) {
            wrapped.onError(e);
        }
    }

    private static <I, O> StreamObserver<I> bidi(StreamObserver<O> sink, BidiRpc<I, O> supplier) {
        WrappedStreamObserver<O> wrapped = new WrappedStreamObserver<O>(sink);
        try {
            return supplier.process(wrapped);
        }
        catch (Throwable e) {
            wrapped.onError(e);
            return null;
        }
    }

    private static interface BidiRpc<I, O> {
        public StreamObserver<I> process(StreamObserver<O> var1) throws DatastoreException;
    }

    private static interface StreamingRpc<T> {
        public List<T> process() throws DatastoreException;
    }

    private static interface UnaryRpc<T> {
        public T process() throws DatastoreException;
    }
}

