/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore.v1beta1;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulator;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1Router;
import com.google.cloud.datastore.emulator.impl.util.ConvertingStreamObserver;
import com.google.cloud.datastore.emulator.impl.util.WrappedStreamObserver;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1beta1.BatchGetDocumentsResponse;
import com.google.firestore.v1beta1.CommitRequest;
import com.google.firestore.v1beta1.CommitResponse;
import com.google.firestore.v1beta1.DeleteDocumentRequest;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.FirestoreGrpc;
import com.google.firestore.v1beta1.GetDocumentRequest;
import com.google.firestore.v1beta1.GetOrListDocumentsRequest;
import com.google.firestore.v1beta1.GetOrListDocumentsResponse;
import com.google.firestore.v1beta1.ListCollectionIdsRequest;
import com.google.firestore.v1beta1.ListCollectionIdsResponse;
import com.google.firestore.v1beta1.ListDocumentsResponse;
import com.google.firestore.v1beta1.RollbackRequest;
import com.google.firestore.v1beta1.UpdateDocumentRequest;
import com.google.firestore.v1beta1.WriteResponse;
import com.google.protobuf.Empty;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;
import java.util.List;

public class FirestoreV1Beta1GrpcAdapter {
    private final CloudFirestoreV1Router router;
    private final FirestoreGrpc.FirestoreImplBase firestoreImpl = new FirestoreGrpc.FirestoreImplBase(){

        @Override
        public void getOrListDocuments(GetOrListDocumentsRequest request, StreamObserver<GetOrListDocumentsResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (GetOrListDocumentsResponse)GET_OR_LIST_DOCUMENTS_RESPONSE.apply(FirestoreV1Beta1GrpcAdapter.this.router.getOrListDocuments((com.google.firestore.v1.GetOrListDocumentsRequest)GET_OR_LIST_DOCUMENTS_REQUEST.apply(request))));
        }

        @Override
        public void getDocument(GetDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (Document)DOCUMENT.apply(FirestoreV1Beta1GrpcAdapter.this.router.getDocument((com.google.firestore.v1.GetDocumentRequest)GET_DOCUMENT_REQUEST.apply(request))));
        }

        @Override
        public void listDocuments(com.google.firestore.v1beta1.ListDocumentsRequest request, StreamObserver<ListDocumentsResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (ListDocumentsResponse)LIST_DOCUMENTS_RESPONSE.apply(FirestoreV1Beta1GrpcAdapter.this.router.listDocuments((ListDocumentsRequest)LIST_DOCUMENTS_REQUEST.apply(request))));
        }

        @Override
        public void createDocument(com.google.firestore.v1beta1.CreateDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (Document)DOCUMENT.apply(FirestoreV1Beta1GrpcAdapter.this.router.createDocument((CreateDocumentRequest)CREATE_DOCUMENT_REQUEST.apply(request))));
        }

        @Override
        public void updateDocument(UpdateDocumentRequest request, StreamObserver<Document> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (Document)DOCUMENT.apply(FirestoreV1Beta1GrpcAdapter.this.router.updateDocument((com.google.firestore.v1.UpdateDocumentRequest)UPDATE_DOCUMENT_REQUEST.apply(request))));
        }

        @Override
        public void deleteDocument(DeleteDocumentRequest request, StreamObserver<Empty> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> {
                FirestoreV1Beta1GrpcAdapter.this.router.deleteDocument((com.google.firestore.v1.DeleteDocumentRequest)DELETE_DOCUMENT_REQUEST.apply(request));
                return Empty.getDefaultInstance();
            });
        }

        @Override
        public void batchGetDocuments(com.google.firestore.v1beta1.BatchGetDocumentsRequest request, StreamObserver<BatchGetDocumentsResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.streaming(responseObserver, () -> FirestoreV1Beta1GrpcAdapter.this.router.batchGetDocuments((BatchGetDocumentsRequest)BATCH_GET_DOCUMENTS_REQUEST.apply(request)).stream().map(BATCH_GET_DOCUMENTS_RESPONSE).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public void beginTransaction(com.google.firestore.v1beta1.BeginTransactionRequest request, StreamObserver<com.google.firestore.v1beta1.BeginTransactionResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (com.google.firestore.v1beta1.BeginTransactionResponse)BEGIN_TRANSACTION_RESPONSE.apply(FirestoreV1Beta1GrpcAdapter.this.router.beginTransaction((BeginTransactionRequest)BEGIN_TRANSACTION_REQUEST.apply(request))));
        }

        @Override
        public void commit(CommitRequest request, StreamObserver<CommitResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (CommitResponse)COMMIT_RESPONSE.apply(FirestoreV1Beta1GrpcAdapter.this.router.commit((com.google.firestore.v1.CommitRequest)COMMIT_REQUEST.apply(request))));
        }

        @Override
        public void rollback(RollbackRequest request, StreamObserver<Empty> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> {
                FirestoreV1Beta1GrpcAdapter.this.router.rollback((com.google.firestore.v1.RollbackRequest)ROLLBACK_REQUEST.apply(request));
                return Empty.getDefaultInstance();
            });
        }

        @Override
        public void runQuery(com.google.firestore.v1beta1.RunQueryRequest request, StreamObserver<com.google.firestore.v1beta1.RunQueryResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.streaming(responseObserver, () -> FirestoreV1Beta1GrpcAdapter.this.router.runQuery((RunQueryRequest)RUN_QUERY_REQUEST.apply(request)).stream().map(RUN_QUERY_RESPONSE).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public StreamObserver<com.google.firestore.v1beta1.WriteRequest> write(StreamObserver<WriteResponse> responseObserver) {
            return FirestoreV1Beta1GrpcAdapter.bidi(responseObserver, out -> new ConvertingStreamObserver(FirestoreV1Beta1GrpcAdapter.this.router.writeStream(new ConvertingStreamObserver(out, WRITE_RESPONSE)), WRITE_REQUEST));
        }

        @Override
        public StreamObserver<com.google.firestore.v1beta1.ListenRequest> listen(StreamObserver<com.google.firestore.v1beta1.ListenResponse> responseObserver) {
            return FirestoreV1Beta1GrpcAdapter.bidi(responseObserver, out -> new ConvertingStreamObserver(FirestoreV1Beta1GrpcAdapter.this.router.listenStream(new ConvertingStreamObserver(out, LISTEN_RESPONSE)), LISTEN_REQUEST));
        }

        @Override
        public void listCollectionIds(ListCollectionIdsRequest request, StreamObserver<ListCollectionIdsResponse> responseObserver) {
            FirestoreV1Beta1GrpcAdapter.unary(responseObserver, () -> (ListCollectionIdsResponse)LIST_COLLECTION_IDS_RESPONSE.apply(FirestoreV1Beta1GrpcAdapter.this.router.listCollectionIds((com.google.firestore.v1.ListCollectionIdsRequest)LIST_COLLECTION_IDS_REQUEST.apply(request))));
        }
    };
    private static final EquivalentMessageConverter<GetOrListDocumentsRequest, com.google.firestore.v1.GetOrListDocumentsRequest> GET_OR_LIST_DOCUMENTS_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.GetOrListDocumentsRequest.parser());
    private static final EquivalentMessageConverter<GetDocumentRequest, com.google.firestore.v1.GetDocumentRequest> GET_DOCUMENT_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.GetDocumentRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.ListDocumentsRequest, ListDocumentsRequest> LIST_DOCUMENTS_REQUEST = EquivalentMessageConverter.create(ListDocumentsRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.CreateDocumentRequest, CreateDocumentRequest> CREATE_DOCUMENT_REQUEST = EquivalentMessageConverter.create(CreateDocumentRequest.parser());
    private static final EquivalentMessageConverter<UpdateDocumentRequest, com.google.firestore.v1.UpdateDocumentRequest> UPDATE_DOCUMENT_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.UpdateDocumentRequest.parser());
    private static final EquivalentMessageConverter<DeleteDocumentRequest, com.google.firestore.v1.DeleteDocumentRequest> DELETE_DOCUMENT_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.DeleteDocumentRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.BatchGetDocumentsRequest, BatchGetDocumentsRequest> BATCH_GET_DOCUMENTS_REQUEST = EquivalentMessageConverter.create(BatchGetDocumentsRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.BeginTransactionRequest, BeginTransactionRequest> BEGIN_TRANSACTION_REQUEST = EquivalentMessageConverter.create(BeginTransactionRequest.parser());
    private static final EquivalentMessageConverter<CommitRequest, com.google.firestore.v1.CommitRequest> COMMIT_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.CommitRequest.parser());
    private static final EquivalentMessageConverter<RollbackRequest, com.google.firestore.v1.RollbackRequest> ROLLBACK_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.RollbackRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.RunQueryRequest, RunQueryRequest> RUN_QUERY_REQUEST = EquivalentMessageConverter.create(RunQueryRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.WriteRequest, WriteRequest> WRITE_REQUEST = EquivalentMessageConverter.create(WriteRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1beta1.ListenRequest, ListenRequest> LISTEN_REQUEST = EquivalentMessageConverter.create(ListenRequest.parser());
    private static final EquivalentMessageConverter<ListCollectionIdsRequest, com.google.firestore.v1.ListCollectionIdsRequest> LIST_COLLECTION_IDS_REQUEST = EquivalentMessageConverter.create(com.google.firestore.v1.ListCollectionIdsRequest.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.GetOrListDocumentsResponse, GetOrListDocumentsResponse> GET_OR_LIST_DOCUMENTS_RESPONSE = EquivalentMessageConverter.create(GetOrListDocumentsResponse.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.Document, Document> DOCUMENT = EquivalentMessageConverter.create(Document.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.ListDocumentsResponse, ListDocumentsResponse> LIST_DOCUMENTS_RESPONSE = EquivalentMessageConverter.create(ListDocumentsResponse.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.BatchGetDocumentsResponse, BatchGetDocumentsResponse> BATCH_GET_DOCUMENTS_RESPONSE = EquivalentMessageConverter.create(BatchGetDocumentsResponse.parser());
    private static final EquivalentMessageConverter<BeginTransactionResponse, com.google.firestore.v1beta1.BeginTransactionResponse> BEGIN_TRANSACTION_RESPONSE = EquivalentMessageConverter.create(com.google.firestore.v1beta1.BeginTransactionResponse.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.CommitResponse, CommitResponse> COMMIT_RESPONSE = EquivalentMessageConverter.create(CommitResponse.parser());
    private static final EquivalentMessageConverter<RunQueryResponse, com.google.firestore.v1beta1.RunQueryResponse> RUN_QUERY_RESPONSE = EquivalentMessageConverter.create(com.google.firestore.v1beta1.RunQueryResponse.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.WriteResponse, WriteResponse> WRITE_RESPONSE = EquivalentMessageConverter.create(WriteResponse.parser());
    private static final EquivalentMessageConverter<ListenResponse, com.google.firestore.v1beta1.ListenResponse> LISTEN_RESPONSE = EquivalentMessageConverter.create(com.google.firestore.v1beta1.ListenResponse.parser());
    private static final EquivalentMessageConverter<com.google.firestore.v1.ListCollectionIdsResponse, ListCollectionIdsResponse> LIST_COLLECTION_IDS_RESPONSE = EquivalentMessageConverter.create(ListCollectionIdsResponse.parser());

    private FirestoreV1Beta1GrpcAdapter(CloudFirestoreV1Router router) {
        this.router = router;
    }

    public static ServerServiceDefinition build(FirestoreEmulator emulator) {
        FirestoreV1Beta1GrpcAdapter adapter = new FirestoreV1Beta1GrpcAdapter(emulator.firestoreV1Router());
        return adapter.firestoreImpl.bindService();
    }

    private static <T> void unary(StreamObserver<T> responseObserver, UnaryRpc<T> supplier) {
        WrappedStreamObserver<T> wrapped = new WrappedStreamObserver<T>(responseObserver);
        try {
            wrapped.onNext(supplier.process());
            wrapped.onCompleted();
        }
        catch (Throwable t) {
            wrapped.onError(t);
        }
    }

    private static <T> void streaming(StreamObserver<T> responseObserver, StreamingRpc<T> supplier) {
        WrappedStreamObserver<T> wrapped = new WrappedStreamObserver<T>(responseObserver);
        try {
            for (T t : supplier.process()) {
                wrapped.onNext(t);
            }
            wrapped.onCompleted();
        }
        catch (Throwable e) {
            wrapped.onError(e);
        }
    }

    private static <I, O> StreamObserver<I> bidi(StreamObserver<O> sink, BidiRpc<I, O> supplier) {
        WrappedStreamObserver<O> wrapped = new WrappedStreamObserver<O>(sink);
        try {
            return supplier.process(wrapped);
        }
        catch (Throwable e) {
            wrapped.onError(e);
            return null;
        }
    }

    private static interface BidiRpc<I, O> {
        public StreamObserver<I> process(StreamObserver<O> var1) throws DatastoreException;
    }

    private static interface StreamingRpc<T> {
        public List<T> process() throws DatastoreException;
    }

    private static interface UnaryRpc<T> {
        public T process() throws DatastoreException;
    }
}

