/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore.webchannel;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulatorMetadataKeys;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1Router;
import com.google.cloud.datastore.emulator.impl.util.WrappedStreamObserver;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.gson.JsonObject;
import com.google.net.webchannel.server.AsyncWebChannel;
import com.google.net.webchannel.server.ErrorStatus;
import com.google.net.webchannel.server.WebChannelServerSupport;
import com.google.net.webchannel.server.WebChannelServers;
import com.google.net.webchannel.server.v8.WebChannelImpl;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Context;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;

public class FirestoreV1WebChannelAdapter {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter");
    private final WebChannelServerSupport webchannelServer;

    public FirestoreV1WebChannelAdapter(CloudFirestoreV1Router router, int port) {
        this.webchannelServer = WebChannelServers.createDevServer(port);
        this.webchannelServer.setHandler(new FirestoreServerHandler(router));
    }

    public void start() throws IOException {
        this.webchannelServer.start();
    }

    public void shutdown() {
        this.webchannelServer.shutdown();
    }

    private static final class WebChannelObserver<T extends Message>
    implements StreamObserver<T> {
        private final AsyncWebChannel<String> channel;

        WebChannelObserver(AsyncWebChannel<String> channel) {
            this.channel = channel;
        }

        @Override
        public void onNext(T value) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$WebChannelObserver", "onNext", 194, "FirestoreV1WebChannelAdapter.java")).log("sending response: %s", value);
            try {
                String msg = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)value);
                this.channel.send(new StringBuilder(2 + String.valueOf(msg).length()).append("[").append(msg).append("]").toString());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t)).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$WebChannelObserver", "onError", 205, "FirestoreV1WebChannelAdapter.java")).log("error from firestore");
            JsonObject err = new JsonObject();
            err.addProperty("message", t.getMessage());
            if (t instanceof StatusException) {
                err.addProperty("status", ((StatusException)t).getStatus().getCode().name());
            } else {
                err.addProperty("status", "UNKNOWN");
            }
            JsonObject msg = new JsonObject();
            msg.add("error", err);
            String string = msg.toString();
            this.channel.send(new StringBuilder(2 + String.valueOf(string).length()).append("[").append(string).append("]").toString());
        }

        @Override
        public void onCompleted() {
            this.channel.close();
        }
    }

    private static final class FirestoreListenHandler
    extends AsyncWebChannel.Handler<String> {
        private final StreamObserver<ListenRequest> requestObserver;

        private FirestoreListenHandler(CloudFirestoreV1Router router, AsyncWebChannel<String> channel) {
            WrappedStreamObserver<ListenResponse> responseObserver = new WrappedStreamObserver<ListenResponse>(new WebChannelObserver(channel));
            try {
                this.requestObserver = router.listenStream(responseObserver);
            }
            catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onClose() {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreListenHandler", "onClose", 159, "FirestoreV1WebChannelAdapter.java")).log("channel closed");
        }

        @Override
        public void onError(ErrorStatus error) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreListenHandler", "onError", 164, "FirestoreV1WebChannelAdapter.java")).log("[ERROR] %s", error);
        }

        @Override
        public void onMetadata(String key, String metadata) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreListenHandler", "onMetadata", 169, "FirestoreV1WebChannelAdapter.java")).log("channel metadata: %s = %s", (Object)key, (Object)metadata);
        }

        @Override
        public void onMessage(String message) {
            ListenRequest.Builder builder = ListenRequest.newBuilder();
            try {
                JsonFormat.parser().merge(message, (Message.Builder)builder);
            }
            catch (InvalidProtocolBufferException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreListenHandler", "onMessage", 178, "FirestoreV1WebChannelAdapter.java")).log("invalid message: %s", message);
                throw new RuntimeException(e);
            }
            this.requestObserver.onNext(builder.build());
        }
    }

    private static final class FirestoreWriteHandler
    extends AsyncWebChannel.Handler<String> {
        private final StreamObserver<WriteRequest> requestObserver;

        private FirestoreWriteHandler(CloudFirestoreV1Router router, AsyncWebChannel<String> channel) {
            WrappedStreamObserver<WriteResponse> responseObserver = new WrappedStreamObserver<WriteResponse>(new WebChannelObserver(channel));
            try {
                this.requestObserver = router.writeStream(responseObserver);
            }
            catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onClose() {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreWriteHandler", "onClose", 117, "FirestoreV1WebChannelAdapter.java")).log("channel closed");
        }

        @Override
        public void onError(ErrorStatus error) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreWriteHandler", "onError", 122, "FirestoreV1WebChannelAdapter.java")).log("[ERROR] %s", error);
        }

        @Override
        public void onMetadata(String key, String metadata) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreWriteHandler", "onMetadata", 127, "FirestoreV1WebChannelAdapter.java")).log("channel metadata: %s = %s", (Object)key, (Object)metadata);
        }

        @Override
        public void onMessage(String message) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreWriteHandler", "onMessage", 132, "FirestoreV1WebChannelAdapter.java")).log("received message: %s", message);
            WriteRequest.Builder builder = WriteRequest.newBuilder();
            try {
                JsonFormat.parser().merge(message, (Message.Builder)builder);
            }
            catch (InvalidProtocolBufferException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreWriteHandler", "onMessage", 137, "FirestoreV1WebChannelAdapter.java")).log("invalid message: %s", message);
                throw new RuntimeException(e);
            }
            this.requestObserver.onNext(builder.build());
        }
    }

    private static final class FirestoreServerHandler
    implements WebChannelServerSupport.ServerHandler {
        private final CloudFirestoreV1Router router;

        private FirestoreServerHandler(CloudFirestoreV1Router router) {
            this.router = router;
        }

        @Override
        public void doChannel(AsyncWebChannel<?> newChannel) {
            try {
                this.wrapper((WebChannelImpl)newChannel);
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreServerHandler", "doChannel", 70, "FirestoreV1WebChannelAdapter.java")).log("failed to set up stream");
            }
        }

        private void wrapper(AsyncWebChannel<String> channel) {
            String url = channel.getHandshakeHeaders().getUrl();
            QueryStringDecoder decoder = new QueryStringDecoder(url);
            String db = Preconditions.checkNotNull(decoder.parameters().get("database"), "expected %s to have a 'database' query parameter", (Object)url).get(0);
            Context.current().withValue(FirestoreEmulatorMetadataKeys.DATABASE_REF.contextKey(), db).run(() -> {
                AsyncWebChannel.Handler handler;
                if (url.startsWith("/google.firestore.v1.Firestore/Write/")) {
                    handler = new FirestoreWriteHandler(this.router, channel);
                } else if (url.startsWith("/google.firestore.v1.Firestore/Listen/")) {
                    handler = new FirestoreListenHandler(this.router, channel);
                } else {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/cloud/datastore/emulator/firestore/webchannel/FirestoreV1WebChannelAdapter$FirestoreServerHandler", "lambda$wrapper$0", 93, "FirestoreV1WebChannelAdapter.java")).log("unknown route: %s", url);
                    channel.abort();
                    return;
                }
                channel.start(handler);
            });
        }
    }
}

