/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.firestorev1.FirestoreV1AutoIdGenerator;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.emulator.impl.AutoValue_CloudFirestoreV1_EntityMutationResult;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1ListenStream;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1WriteStream;
import com.google.cloud.datastore.emulator.impl.FirestoreEmulatorConfig;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.events.EventManager;
import com.google.cloud.datastore.emulator.impl.proto.ListCollectionIdsPageToken;
import com.google.cloud.datastore.emulator.impl.proto.ListDocumentsPageToken;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQuerySemantics;
import com.google.cloud.datastore.emulator.impl.rules.EmulatorRulesCompiler;
import com.google.cloud.datastore.emulator.impl.storage.FirestoreEmulatorLookupHandler;
import com.google.cloud.datastore.emulator.impl.storage.FlatLocalEntityStore;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.transactions.EmulatorTransactionManager;
import com.google.cloud.datastore.emulator.impl.transactions.TransactionUtils;
import com.google.cloud.datastore.emulator.impl.util.EmulatorComparators;
import com.google.cloud.datastore.emulator.impl.util.EmulatorPageTokens;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.cloud.datastore.emulator.impl.watch.FirestoreSyncManager;
import com.google.cloud.datastore.emulator.impl.watch.ListenStreamManager;
import com.google.cloud.datastore.emulator.impl.watch.StreamId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.common.time.TimeSource;
import com.google.firestore.emulator.v1.ClearDataRequest;
import com.google.firestore.emulator.v1.CreateTriggerRequest;
import com.google.firestore.emulator.v1.CreateTriggerResponse;
import com.google.firestore.emulator.v1.EventTrigger;
import com.google.firestore.emulator.v1.GetRuleCoverageRequest;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.firestore.emulator.v1.SetSecurityRulesRequest;
import com.google.firestore.emulator.v1.SetSecurityRulesResponse;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JavaTimeConversions;
import com.google.storage.onestore.v3.OnestoreEntity;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class CloudFirestoreV1
implements FirestoreSyncManager {
    private static final Duration MAX_FUTURE_SNAPSHOT_READ_SKEW = Duration.ofMillis(50L);
    private static final Duration TRANSACTION_TIME_OUT = Duration.ofMinutes(5L);
    private static final int MAX_BATCH_WRITE_ENTITIES = 500;
    private final DatabaseRef databaseRef;
    private final TimeSource timeSource;
    private final Duration maxReadStaleness;
    private final EmulatorTransactionManager transactionManager;
    private final LocalEntityStore localEntityStore;
    private final FirestoreEmulatorConverters converters;
    private final ListenStreamManager<ListenRequest> listenStreamManager;
    private final AtomicReference<EmulatorRulesCompiler.EmulatorCompilationResult> rules;
    private final AtomicReference<ImmutableMap<String, EventTrigger>> triggers;
    private final EventManager eventManager;
    private final FirestoreEmulatorQuerySemantics queryManager;
    private final AtomicLong nextStreamId = new AtomicLong();
    private final Random random;

    public CloudFirestoreV1(FirestoreEmulatorConfig config, DatabaseRef databaseRef) {
        this.databaseRef = databaseRef;
        this.timeSource = config.timeSource();
        this.transactionManager = new EmulatorTransactionManager(this.timeSource, TRANSACTION_TIME_OUT);
        this.maxReadStaleness = Duration.ofMillis(config.datastoreConfig().getMaxReadStalenessMs());
        this.localEntityStore = new FlatLocalEntityStore(this.timeSource, Duration.ofMinutes(5L));
        this.converters = new FirestoreEmulatorConverters(databaseRef.partitionId(), Preconditions.checkNotNull(config).datastoreConfig());
        this.rules = new AtomicReference<EmulatorRulesCompiler.EmulatorCompilationResult>(EmulatorRulesCompiler.makeAuthorizer(config.defaultRules(), this.converters));
        this.listenStreamManager = new ListenStreamManager(this, this.timeSource);
        this.eventManager = new EventManager(databaseRef.projectId(), config.eventPublisher(), this.converters);
        this.triggers = new AtomicReference(ImmutableMap.of());
        this.queryManager = new FirestoreEmulatorQuerySemantics(config.datastoreConfig());
        this.random = config.random();
    }

    public Document getDocument(FirestoreEmulatorRequestContext context, GetDocumentRequest request) throws DatastoreException {
        Lookup lookup = this.converters.toLookup(request);
        ImmutableList<ReadResult> readResults = this.lookUp(context, lookup.keys(), lookup.propertyMask(), this.transactionManager.create(request));
        ReadResult readResult = Iterables.getOnlyElement(readResults);
        if (!readResult.exists()) {
            throw new DatastoreException(String.format("Document (%s) not found.", request.getName()), DatastoreV3Pb.Error.ErrorCode.NOT_FOUND, null);
        }
        return this.converters.toDocument(readResult);
    }

    public ListDocumentsResponse listDocuments(FirestoreEmulatorRequestContext context, ListDocumentsRequest request) throws DatastoreException {
        EmulatorTransactionManager.EmulatorTransaction txn = this.transactionManager.create(request);
        Instant readTime = txn.fold(EmulatorTransactionManager.ReadOnlyTransaction::snapshotReadTime, readWriteTransaction -> {
            throw new UnsupportedOperationException("transactional listDocuments not implemented");
        });
        Query listDocumentsQuery = this.converters.toListDocumentsQuery(request);
        EntityRef parent = this.converters.parseParent(request.getParent()).append(EntityRef.PathElement.create(request.getCollectionId(), null));
        Optional<EntityRef> lastRef = request.getPageToken().isEmpty() ? Optional.empty() : Optional.of(this.converters.toEntityRef(EmulatorPageTokens.ListDocuments.deserialize(request.getPageToken()).getDocumentName()));
        ImmutableList<ReadResult> documents = request.getShowMissing() ? this.showMissingListDocuments(context, parent, lastRef, listDocumentsQuery.limit(), readTime) : this.snapshotQuery(context, listDocumentsQuery, readTime);
        ListDocumentsResponse.Builder builder = ListDocumentsResponse.newBuilder();
        if (documents.size() == listDocumentsQuery.limit().intValue()) {
            ListDocumentsPageToken pageToken = FirestoreEmulatorConverters.toDocumentPageToken(Iterables.getLast(documents).cursor());
            builder.setNextPageToken(EmulatorPageTokens.ListDocuments.serialize(pageToken));
        }
        documents.stream().map(this.converters::toDocument).forEach(builder::addDocuments);
        return builder.build();
    }

    private ImmutableList<ReadResult> showMissingListDocuments(FirestoreEmulatorRequestContext context, EntityRef parent, Optional<EntityRef> lastRef, int limit, Instant readTime) throws DatastoreException {
        ImmutableMap<EntityRef, EntityReadResult> rows;
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(readTime);){
            this.rules.get().getAuthorizer().checkMetadataOperation(context);
            rows = readView.all();
        }
        return rows.values().stream().flatMap(row -> Streams.stream(row.entity())).map(Entity::ref).filter(ref -> parent.path().isPrefixOf(ref.path())).map(ref -> ref.truncate(parent.path().size())).filter(ref -> lastRef.map(lr -> EmulatorComparators.ENTITY_REF_COMPARATOR.compare((EntityRef)lr, (EntityRef)ref) < 0).orElse(true)).sorted(EmulatorComparators.ENTITY_REF_COMPARATOR).distinct().limit(limit).map(ref -> this.converters.rowToReadResult(rows.getOrDefault(ref, EntityReadResult.builder().entity(Optional.of(Entity.createFromRef(ref))).ref((EntityRef)ref).readAt(readTime).build()))).collect(ImmutableList.toImmutableList());
    }

    public Document createDocument(FirestoreEmulatorRequestContext context, CreateDocumentRequest request) throws DatastoreException {
        return this.converters.toCreateResponse(this.internalCommit(context, this.converters.toWrite(request)));
    }

    public Document updateDocument(FirestoreEmulatorRequestContext context, UpdateDocumentRequest request) throws DatastoreException {
        return this.converters.toUpdateResponse(this.internalCommit(context, this.converters.toWrite(request)));
    }

    public void deleteDocument(FirestoreEmulatorRequestContext context, DeleteDocumentRequest request) throws DatastoreException {
        this.internalCommit(context, this.converters.toWrite(request));
    }

    public ImmutableList<BatchGetDocumentsResponse> batchGetDocuments(FirestoreEmulatorRequestContext context, BatchGetDocumentsRequest request) throws DatastoreException {
        Lookup lookup = this.converters.toLookup(request);
        EmulatorTransactionManager.EmulatorTransaction transactionHandle = this.transactionManager.create(request);
        ArrayList<BatchGetDocumentsResponse> batchGetDocumentsResponses = new ArrayList<BatchGetDocumentsResponse>();
        ImmutableList<ReadResult> readResults = this.lookUp(context, lookup.keys(), lookup.propertyMask(), transactionHandle);
        if (TransactionUtils.isNewTransaction(request.getConsistencySelectorCase())) {
            batchGetDocumentsResponses.add(BatchGetDocumentsResponse.newBuilder().setTransaction(this.converters.toTransactionBytes(transactionHandle.handle())).build());
        }
        batchGetDocumentsResponses.addAll(readResults.stream().map(this.converters::toBatchGetDocumentResponse).collect(ImmutableList.toImmutableList()));
        return ImmutableList.copyOf(batchGetDocumentsResponses);
    }

    public BeginTransactionResponse beginTransaction(FirestoreEmulatorRequestContext context, BeginTransactionRequest request) throws DatastoreException {
        return BeginTransactionResponse.newBuilder().setTransaction(this.converters.toTransactionBytes(this.transactionManager.create(request.getOptions()).handle())).build();
    }

    public CommitResponse commit(FirestoreEmulatorRequestContext context, CommitRequest request) throws DatastoreException {
        if (request.getWritesCount() == 0) {
            return CommitResponse.getDefaultInstance();
        }
        return this.converters.toCommitResponse(this.internalCommit(context, this.converters.toWrite(request, JavaTimeConversions.toProtoTimestamp(context.requestTime())), this.transactionManager.create(request).handle()));
    }

    public void rollback(FirestoreEmulatorRequestContext context, RollbackRequest request) throws DatastoreException {
        this.rollbackTransaction(Transactions.getTransactionHandle(request.getTransaction()));
    }

    public ImmutableList<RunQueryResponse> runQuery(FirestoreEmulatorRequestContext context, RunQueryRequest request) throws DatastoreException {
        EmulatorTransactionManager.ReadOnlyTransaction transactionHandle = this.transactionManager.create(request).fold(readOnlyTransaction -> readOnlyTransaction, readWriteTransaction -> {
            throw new UnsupportedOperationException("transactional queries not implemented");
        });
        Query query = this.converters.toQuery(request, TransactionUtils.isNewTransaction(request.getConsistencySelectorCase()) ? transactionHandle.handle() : 0L);
        Instant readTime = transactionHandle.snapshotReadTime();
        ArrayList<RunQueryResponse> runQueryResponses = new ArrayList<RunQueryResponse>();
        if (TransactionUtils.isNewTransaction(request.getConsistencySelectorCase())) {
            runQueryResponses.add(RunQueryResponse.newBuilder().setTransaction(this.converters.toTransactionBytes(transactionHandle.handle())).build());
        }
        ImmutableList<ReadResult> readResults = this.snapshotQuery(context, query, readTime);
        Timestamp timestamp = JavaTimeConversions.toProtoTimestamp(readTime);
        if (readResults.isEmpty()) {
            runQueryResponses.add(RunQueryResponse.newBuilder().setReadTime(timestamp).build());
            return ImmutableList.copyOf(runQueryResponses);
        }
        readResults.forEach(readResult -> runQueryResponses.add(RunQueryResponse.newBuilder().setDocument(this.converters.toDocument((ReadResult)readResult)).setReadTime(timestamp).build()));
        return ImmutableList.copyOf(runQueryResponses);
    }

    public CloudFirestoreV1WriteStream writeStream(FirestoreEmulatorRequestContext context, StreamObserver<WriteResponse> responseObserver) {
        return CloudFirestoreV1WriteStream.create(this, this.timeSource, responseObserver, Long.toString(this.nextStreamId.getAndIncrement()), context);
    }

    public CloudFirestoreV1ListenStream listenStream(FirestoreEmulatorRequestContext context, StreamObserver<ListenResponse> responseObserver) {
        return CloudFirestoreV1ListenStream.create(context, StreamId.of(this.nextStreamId.getAndIncrement()), this.converters, this.listenStreamManager, responseObserver);
    }

    public ListCollectionIdsResponse listCollectionIds(FirestoreEmulatorRequestContext context, ListCollectionIdsRequest request) throws DatastoreException {
        ImmutableList<String> collectionIds;
        EntityRef parent = this.converters.parseParent(request.getParent());
        ListCollectionIdsResponse.Builder builder = ListCollectionIdsResponse.newBuilder();
        ListCollectionIdsPageToken pageToken = EmulatorPageTokens.ListCollectionIds.deserialize(request.getPageToken());
        this.rules.get().getAuthorizer().checkMetadataOperation(context);
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(context.requestTime());){
            Stream<String> collectionIdStream = readView.all().keySet().stream().filter(ref -> ref.parent().equals(parent)).map(EntityRef::collectionId).distinct().sorted();
            if (!request.getPageToken().isEmpty()) {
                collectionIdStream = collectionIdStream.filter(collectionId -> collectionId.compareTo(pageToken.getCollectionId()) > 0);
            }
            if (request.getPageSize() > 0) {
                collectionIdStream = collectionIdStream.limit(request.getPageSize());
            }
            collectionIds = collectionIdStream.collect(ImmutableList.toImmutableList());
        }
        if (request.getPageSize() > 0 && collectionIds.size() == request.getPageSize()) {
            ListCollectionIdsPageToken nextPageToken = EmulatorPageTokens.ListCollectionIds.create((String)Iterables.getLast(collectionIds));
            builder.setNextPageToken(EmulatorPageTokens.ListCollectionIds.serialize(nextPageToken));
        }
        collectionIds.forEach(builder::addCollectionIds);
        return builder.build();
    }

    public SetSecurityRulesResponse setSecurityRules(FirestoreEmulatorRequestContext context, SetSecurityRulesRequest request) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        EmulatorRulesCompiler.EmulatorCompilationResult result = EmulatorRulesCompiler.makeAuthorizer(request.getRules(), this.converters);
        if (!request.getIgnoreErrors()) {
            result.checkCompilationSucceeded();
        }
        this.rules.set(result);
        return SetSecurityRulesResponse.newBuilder().addAllIssues(result.issues()).build();
    }

    public void clearData(FirestoreEmulatorRequestContext context, ClearDataRequest request) throws DatastoreException {
        Set entitiesToDelete;
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(context.requestTime());){
            entitiesToDelete = readView.all().keySet();
        }
        for (List chunk : Lists.partition(((ImmutableSet)entitiesToDelete).asList(), 500)) {
            ImmutableList<Mutation> mutations = chunk.stream().map(ref -> Mutation.delete(FirestoreEmulatorConverters.toReference(ref)).build()).collect(ImmutableList.toImmutableList());
            Write write = Write.builder().mutations(mutations).build();
            FirestoreEmulatorRequestContext elevatedContext = context.toBuilder().auth(Optional.of(EmulatorAuthorization.ofAdmin(EmulatorAuthorization.AdminRole.OWNER))).build();
            this.internalCommit(elevatedContext, write);
        }
    }

    public RuleCoverageReport ruleCoverageReport(FirestoreEmulatorRequestContext context, GetRuleCoverageRequest request) throws DatastoreException {
        return this.rules.get().getAuthorizer().ruleCoverageReport();
    }

    public CreateTriggerResponse createTrigger(FirestoreEmulatorRequestContext context, CreateTriggerRequest request) throws DatastoreException {
        EventTrigger eventTrigger = request.getEventTrigger();
        String eventType = eventTrigger.getEventType();
        Preconditions.checkArgument(eventTrigger.getService().equals("firestore.googleapis.com"), "EventTrigger service must be: %s", (Object)"firestore.googleapis.com");
        Preconditions.checkArgument(EventManager.SUPPORTED_EVENT_TYPES.contains(eventType), "Unsupported eventType: %s", (Object)eventType);
        this.triggers.updateAndGet(current -> {
            HashMap<String, EventTrigger> hashMap = new HashMap<String, EventTrigger>((Map<String, EventTrigger>)current);
            hashMap.put(request.getName(), eventTrigger);
            return ImmutableMap.copyOf(hashMap);
        });
        return CreateTriggerResponse.getDefaultInstance();
    }

    public WriteResponse write(FirestoreEmulatorRequestContext context, WriteRequest request) throws DatastoreException {
        Timestamp requestTime = JavaTimeConversions.toProtoTimestamp(context.requestTime());
        return this.converters.toWriteResponse(this.internalCommit(context, this.converters.toWrite(request, requestTime)));
    }

    private void rollbackTransaction(long transaction) {
        this.localEntityStore.commit(transaction, ImmutableMap.of());
    }

    private WriteResult internalCommit(FirestoreEmulatorRequestContext context, Write write) throws DatastoreException {
        return this.internalCommit(context, write, this.transactionManager.nextReadWrite().handle());
    }

    private WriteResult internalCommit(FirestoreEmulatorRequestContext context, Write write, long transaction) throws DatastoreException {
        ImmutableMap<EntityRef, EntityReadResult> results;
        ImmutableMap<EntityRef, EntityMutationResult> mutationResults;
        ImmutableMap<EntityRef, EntityReadResult> rows;
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.allocateAutoIds(write);
        ImmutableMap mutationsByRef = Maps.uniqueIndex(write.mutations(), m -> FirestoreEmulatorConverters.toEntityRef(m.key()));
        if (mutationsByRef.size() > 500) {
            throw DatastoreExceptionHelper.badRequest("cannot write more than %d entities in a single call", 500);
        }
        try (LocalEntityStore.ReadWriteView rw = this.localEntityStore.readWrite(transaction, (ImmutableSet<EntityRef>)mutationsByRef.keySet());){
            rows = rw.get(mutationsByRef.keySet());
            mutationResults = ImmutableMap.copyOf(Maps.transformEntries(rows, (ref, row) -> this.computeNewEntityViaSubMutations((EntityReadResult)row, (Mutation)mutationsByRef.get(ref))));
            ImmutableMap<EntityRef, Optional<Entity>> newEntities = ImmutableMap.copyOf(Maps.transformValues(mutationResults, EntityMutationResult::newEntity));
            this.rules.get().getAuthorizer().checkCommit(context, transaction, write, rw, newEntities);
            for (Map.Entry entry : rows.entrySet()) {
                EntityReadResult row2 = (EntityReadResult)entry.getValue();
                FirestoreEmulatorConverters.checkMutation(mutationsByRef.get(entry.getKey()), row2.entity().isPresent(), row2.updatedAt().map(FirestoreEmulatorConverters::toMicroseconds).orElse(-1L));
            }
            results = rw.commit(newEntities);
        }
        catch (Exception e) {
            this.rollbackTransaction(transaction);
            throw e;
        }
        this.listenStreamManager.notifyListeners(ImmutableMap.copyOf(Maps.transformValues(results, this.converters::rowToReadResult)));
        this.eventManager.reportEvents(this.triggers.get(), rows, results);
        return WriteResult.builder().commitTimestamp(FirestoreEmulatorConverters.toMicroseconds(results.values().stream().map(EntityReadResult::readAt).findAny().orElse(context.requestTime()))).originalMutationsIndexes(write.originalMutationsMap() == null ? ImmutableList.of() : Ints.asList(write.originalMutationsMap())).originalTransformations(write.originalTransformations()).collapsedMutationResults(write.mutations().stream().map(m -> {
            EntityRef ref = FirestoreEmulatorConverters.toEntityRef(m.key());
            return CloudFirestoreV1.constructMutationResult(m, (EntityReadResult)results.get(ref), (EntityMutationResult)mutationResults.get(ref));
        }).collect(ImmutableList.toImmutableList())).build();
    }

    private static MutationResult constructMutationResult(Mutation m, EntityReadResult readResult, EntityMutationResult mutationResult) {
        return MutationResult.builder().key(m.key()).transformedValues(mutationResult.transformedValues()).entity(readResult.masked(m.readPropertyMask()).entity().orElse(null)).createVersion(readResult.createdAt().map(FirestoreEmulatorConverters::toMicroseconds).orElse(-1L)).updateVersion(readResult.updatedAt().map(FirestoreEmulatorConverters::toMicroseconds).orElse(-1L)).build();
    }

    public ImmutableList<ReadResult> lookUp(FirestoreEmulatorRequestContext context, ImmutableList<OnestoreEntity.Reference> keys, PropertyMask mask, EmulatorTransactionManager.EmulatorTransaction transactionHandle) throws DatastoreException {
        return transactionHandle.fold(readOnlyTransaction -> this.snapshotLookup(context, keys, mask, readOnlyTransaction.snapshotReadTime()), readWriteTransaction -> this.transactionalLookup(context, keys, mask, readWriteTransaction.handle()));
    }

    private ImmutableList<ReadResult> transactionalLookup(FirestoreEmulatorRequestContext context, List<OnestoreEntity.Reference> keys, PropertyMask mask, long transaction) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        try (LocalEntityStore.ReadView readView = this.localEntityStore.read(transaction);){
            FirestoreEmulatorLookupHandler handler = new FirestoreEmulatorLookupHandler(this.converters, readView);
            this.rules.get().getAuthorizer().checkLookup(context, transaction, ImmutableSet.copyOf(keys), readView);
            ImmutableList<ReadResult> immutableList = handler.batchLookup(keys).stream().map(readResult -> readResult.exists() ? readResult.withMask(mask) : readResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    private void checkValidReadTime(Instant readTime) throws DatastoreException {
        Instant now = this.timeSource.now();
        if (readTime.plus(this.maxReadStaleness).isBefore(now)) {
            throw DatastoreExceptionHelper.badRequest("The requested snapshot version is too old.", new Object[0]);
        }
        if (readTime.minus(MAX_FUTURE_SNAPSHOT_READ_SKEW).isAfter(now)) {
            throw DatastoreExceptionHelper.badRequest("The requested snapshot version is invalid.", new Object[0]);
        }
    }

    private void allocateAutoIds(Write write) {
        for (Mutation mutation : write.mutations()) {
            if (!mutation.allocateKey()) continue;
            OnestoreEntity.Path.Element lastElement = V3Paths.lastElement(mutation.key());
            lastElement.setName(FirestoreV1AutoIdGenerator.generate(this.random));
        }
    }

    @Override
    public ImmutableList<ReadResult> snapshotLookup(FirestoreEmulatorRequestContext context, ImmutableList<OnestoreEntity.Reference> keys, PropertyMask mask, Instant readTime) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.checkValidReadTime(readTime);
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(readTime);){
            FirestoreEmulatorLookupHandler handler = new FirestoreEmulatorLookupHandler(this.converters, readView);
            this.rules.get().getAuthorizer().checkLookup(context, null, ImmutableSet.copyOf(keys), readView);
            ImmutableList<ReadResult> immutableList = handler.batchLookup(keys).stream().map(readResult -> readResult.exists() ? readResult.withMask(mask) : readResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    @Override
    public ImmutableList<ReadResult> snapshotQuery(FirestoreEmulatorRequestContext context, Query query, Instant readTime) throws DatastoreException {
        ImmutableMap<EntityRef, EntityReadResult> rows;
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.checkValidReadTime(readTime);
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(readTime);){
            this.rules.get().getAuthorizer().checkQuery(context, query, readView);
            rows = readView.all();
        }
        ImmutableList<Entity> presentRows = rows.values().stream().flatMap(row -> Streams.stream(row.entity())).collect(ImmutableList.toImmutableList());
        return this.queryManager.runQuery(presentRows, query).stream().map(entity -> this.converters.rowToReadResult(((EntityReadResult)rows.get(entity.ref())).masked(query.propertyMask()))).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    ImmutableList<ReadResult> getAllEntities() {
        Instant now = this.timeSource.now();
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(now);){
            ImmutableMap<EntityRef, EntityReadResult> rows = readView.all();
            ImmutableList<ReadResult> immutableList = rows.values().stream().filter(row -> row.entity().isPresent()).map(this.converters::rowToReadResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    @VisibleForTesting
    ListenStreamManager<ListenRequest> getListenStreamManager() {
        return this.listenStreamManager;
    }

    @VisibleForTesting
    FirestoreEmulatorConverters getConverters() {
        return this.converters;
    }

    @VisibleForTesting
    ImmutableMap<String, EventTrigger> getTriggers() {
        return this.triggers.get();
    }

    private EntityMutationResult computeNewEntityViaSubMutations(EntityReadResult row, Mutation m) {
        ImmutableList.Builder transformationValuesBuilder = ImmutableList.builder();
        OnestoreEntity.EntityProto currentEntity = row.entity().map(this.converters::entityToProto).orElse(null);
        for (Mutation subMutation : m.subMutations()) {
            if (subMutation.isVerify()) continue;
            if (subMutation.isDelete()) {
                currentEntity = null;
                continue;
            }
            PropertyMask writeMask = subMutation.writePropertyMask();
            currentEntity = currentEntity == null ? writeMask.mask(subMutation.entity()) : writeMask.maskInto(subMutation.entity(), currentEntity);
            if (subMutation.transformation() == null) continue;
            Entity entity = this.converters.protoToEntity(currentEntity);
            EntityTransformation.TransformationResult result = subMutation.transformation().transform(entity);
            transformationValuesBuilder.addAll(result.transformedValues());
            currentEntity = this.converters.entityToProto(result.transformedEntity());
        }
        return EntityMutationResult.create(Optional.ofNullable(currentEntity).map(this.converters::protoToEntity), (ImmutableList<Value>)transformationValuesBuilder.build());
    }

    @AutoValue
    static abstract class EntityMutationResult {
        EntityMutationResult() {
        }

        public static EntityMutationResult create(Optional<Entity> newEntity, ImmutableList<Value> values) {
            return new AutoValue_CloudFirestoreV1_EntityMutationResult(newEntity, values);
        }

        public abstract Optional<Entity> newEntity();

        public abstract ImmutableList<Value> transformedValues();
    }
}

