/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.cloud.datastore.emulator.impl.watch.CollectionSelector;
import com.google.cloud.datastore.emulator.impl.watch.ListenStream;
import com.google.cloud.datastore.emulator.impl.watch.ListenStreamManager;
import com.google.cloud.datastore.emulator.impl.watch.StreamId;
import com.google.cloud.datastore.emulator.impl.watch.StreamTarget;
import com.google.cloud.datastore.emulator.impl.watch.TargetId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.time.TimeSource;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentChange;
import com.google.firestore.v1.DocumentDelete;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Target;
import com.google.firestore.v1.TargetChange;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.JavaTimeConversions;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CloudFirestoreV1ListenStream
implements ListenStream<ListenRequest> {
    private final FirestoreEmulatorRequestContext context;
    private final AtomicInteger lastId = new AtomicInteger();
    private final StreamId streamId;
    private final FirestoreEmulatorConverters converters;
    private final ListenStreamManager<ListenRequest> manager;
    private final StreamObserver<ListenResponse> responseObserver;
    private final Set<TargetId> targetIds = new HashSet<TargetId>();
    private final TimeSource timeSource;

    public static CloudFirestoreV1ListenStream create(FirestoreEmulatorRequestContext context, StreamId streamId, FirestoreEmulatorConverters converters, ListenStreamManager<ListenRequest> manager, StreamObserver<ListenResponse> responseObserver) {
        return new CloudFirestoreV1ListenStream(context, streamId, converters, manager, responseObserver, manager.timeSource());
    }

    private CloudFirestoreV1ListenStream(FirestoreEmulatorRequestContext context, StreamId streamId, FirestoreEmulatorConverters converters, ListenStreamManager<ListenRequest> manager, StreamObserver<ListenResponse> responseObserver, TimeSource timeSource) {
        this.context = context;
        this.streamId = streamId;
        this.converters = converters;
        this.manager = manager;
        this.responseObserver = responseObserver;
        this.timeSource = timeSource;
    }

    @Override
    public FirestoreEmulatorRequestContext context() {
        return this.context;
    }

    @Override
    public void notify(TargetId targetId, ImmutableList<ReadResult> readResults) throws InvalidConversionException {
        for (ReadResult readResult : readResults) {
            ListenResponse.Builder responseBuilder = ListenResponse.newBuilder();
            if (readResult.exists()) {
                Document document = this.converters.toDocument(readResult);
                responseBuilder.setDocumentChange(DocumentChange.newBuilder().addTargetIds(targetId.id()).setDocument(document).build());
            } else {
                DocumentDelete.Builder documentDeleteBuilder = DocumentDelete.newBuilder().addRemovedTargetIds(targetId.id()).setDocument(FirestoreEmulatorConverters.toDocumentName(FirestoreEmulatorConverters.toEntityRef(readResult.reference())));
                Long readTimestamp = readResult.readTimestamp();
                if (readTimestamp != null) {
                    documentDeleteBuilder.setReadTime(Timestamps.fromMicros(readTimestamp));
                }
                responseBuilder.setDocumentDelete(documentDeleteBuilder.build());
            }
            this.responseObserver.onNext(responseBuilder.build());
        }
    }

    @Override
    public void notifyReset(TargetId targetId) {
        this.responseObserver.onNext(ListenResponse.newBuilder().setTargetChange(TargetChange.newBuilder().setReadTime(JavaTimeConversions.toProtoTimestamp(this.timeSource.now())).addTargetIds(targetId.id()).setTargetChangeType(TargetChange.TargetChangeType.RESET)).build());
    }

    @Override
    public void notifySynced() {
        this.responseObserver.onNext(ListenResponse.newBuilder().setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.NO_CHANGE).setReadTime(JavaTimeConversions.toProtoTimestamp(this.timeSource.now()))).build());
    }

    @Override
    public ImmutableSet<TargetId> targetIds() {
        return ImmutableSet.copyOf(this.targetIds);
    }

    @Override
    public StreamId streamId() {
        return this.streamId;
    }

    @Override
    public void onNext(ListenRequest request) {
        switch (request.getTargetChangeCase()) {
            case ADD_TARGET: {
                try {
                    this.addTarget(request.getAddTarget());
                }
                catch (DatastoreException e) {
                    TargetId targetId = TargetId.of(request.getAddTarget().getTargetId());
                    this.notifyTargetRemoveInternal(targetId, Optional.of(e));
                    this.manager.removeTarget(StreamTarget.of(this.streamId, targetId));
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    this.manager.removeStream(this.streamId);
                    this.responseObserver.onError(e);
                }
                break;
            }
            case REMOVE_TARGET: {
                TargetId targetId = TargetId.of(request.getRemoveTarget());
                this.notifyTargetRemoveInternal(targetId, Optional.empty());
                this.manager.removeTarget(StreamTarget.of(this.streamId, targetId));
                break;
            }
            case TARGETCHANGE_NOT_SET: {
                String string = String.valueOf(request.getTargetChangeCase());
                throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unknown target change: ").append(string).toString());
            }
        }
    }

    @Override
    public void onError(Throwable t) {
        Status s = Status.fromThrowable(t);
        if (s.getCode() != Status.Code.CANCELLED) {
            this.responseObserver.onError(t);
        }
    }

    @Override
    public void onCompleted() {
        this.responseObserver.onCompleted();
    }

    @Override
    public void notifyCurrent(TargetId targetId) {
        this.responseObserver.onNext(ListenResponse.newBuilder().setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.CURRENT).addTargetIds(targetId.id()).setReadTime(JavaTimeConversions.toProtoTimestamp(this.timeSource.now()))).build());
    }

    @Override
    public void notifyTargetRemove(TargetId targetId, DatastoreException cause) {
        this.notifyTargetRemoveInternal(targetId, Optional.of(cause));
    }

    private void notifyTargetRemoveInternal(TargetId targetId, Optional<DatastoreException> cause) {
        if (this.targetIds.remove(targetId)) {
            TargetChange.Builder targetChange = TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.REMOVE).addTargetIds(targetId.id());
            cause.ifPresent(e -> targetChange.setCause(FirestoreEmulatorConverters.toStatus(e)));
            this.manager.removeTarget(StreamTarget.of(this.streamId, targetId));
            this.responseObserver.onNext(ListenResponse.newBuilder().setTargetChange(targetChange).build());
        }
    }

    private TargetId nextTargetId(int clientProvidedId) {
        if (clientProvidedId < 0) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Invalid target id: ").append(clientProvidedId).toString());
        }
        if (clientProvidedId == 0) {
            return TargetId.of(this.lastId.incrementAndGet());
        }
        int currentId = this.lastId.get();
        while (clientProvidedId > currentId && !this.lastId.compareAndSet(currentId, clientProvidedId)) {
            currentId = this.lastId.get();
        }
        return TargetId.of(clientProvidedId);
    }

    private void addTarget(Target target) throws DatastoreException {
        Preconditions.checkArgument(target.getResumeToken().equals(ByteString.EMPTY));
        Preconditions.checkArgument(!target.hasReadTime());
        TargetId targetId = this.nextTargetId(target.getTargetId());
        Preconditions.checkArgument(!this.targetIds.contains(targetId));
        this.targetIds.add(targetId);
        this.responseObserver.onNext(ListenResponse.newBuilder().setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.ADD).addTargetIds(targetId.id())).build());
        Instant readTime = this.timeSource.now();
        ImmutableList<ReadResult> readResults = null;
        switch (target.getTargetTypeCase()) {
            case DOCUMENTS: {
                ImmutableSet.Builder refs = ImmutableSet.builder();
                for (String documentName : target.getDocuments().getDocumentsList()) {
                    refs.add(this.converters.toEntityRef(documentName));
                }
                readResults = this.manager.addDocumentTargets(this, targetId, (ImmutableSet<EntityRef>)refs.build(), readTime);
                break;
            }
            case QUERY: {
                Preconditions.checkArgument(target.getQuery().getStructuredQuery().getFromCount() <= 1);
                StructuredQuery.CollectionSelector collectionSelector = Iterables.getOnlyElement(target.getQuery().getStructuredQuery().getFromList(), StructuredQuery.CollectionSelector.getDefaultInstance());
                CollectionSelector collectionSelectorRep = CollectionSelector.of(collectionSelector.getCollectionId(), collectionSelector.getAllDescendants());
                Query query = this.converters.toQuery(target.getQuery());
                readResults = this.manager.addQueryTargets(this, targetId, query, this.converters.parseParent(target.getQuery().getParent()), collectionSelectorRep, readTime);
                break;
            }
            case TARGETTYPE_NOT_SET: {
                throw new IllegalArgumentException("expected TargetType to be set");
            }
        }
        this.notify(targetId, readResults);
        this.notifyCurrent(targetId);
        this.notifySynced();
    }
}

