/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulatorMetadataKeys;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1ListenStream;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1WriteStream;
import com.google.cloud.datastore.emulator.impl.FirestoreEmulatorConfig;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.time.TimeSource;
import com.google.firestore.emulator.v1.ClearDataRequest;
import com.google.firestore.emulator.v1.CreateTriggerRequest;
import com.google.firestore.emulator.v1.CreateTriggerResponse;
import com.google.firestore.emulator.v1.GetRuleCoverageRequest;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.firestore.emulator.v1.SetSecurityRulesRequest;
import com.google.firestore.emulator.v1.SetSecurityRulesResponse;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.GetOrListDocumentsRequest;
import com.google.firestore.v1.GetOrListDocumentsResponse;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteResponse;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CloudFirestoreV1Router {
    public static final String PARTITION_ID = "dev";
    private final ConcurrentMap<DatabaseRef, CloudFirestoreV1> databases = new ConcurrentHashMap<DatabaseRef, CloudFirestoreV1>();
    private final FirestoreEmulatorConfig config;
    private final TimeSource timeSource;
    private final FirestoreEmulatorConverters converters;

    public CloudFirestoreV1Router(FirestoreEmulatorConfig config) {
        this.config = config;
        this.timeSource = config.timeSource();
        this.converters = new FirestoreEmulatorConverters(PARTITION_ID, config.datastoreConfig());
    }

    private synchronized CloudFirestoreV1 backendFor(DatabaseRef databaseRef) throws DatastoreException {
        Preconditions.checkArgument(databaseRef.databaseId().equals(""));
        CloudFirestoreV1 db = (CloudFirestoreV1)this.databases.get(databaseRef);
        if (db == null) {
            db = new CloudFirestoreV1(this.config, databaseRef);
            this.databases.put(databaseRef, db);
        }
        return db;
    }

    public GetOrListDocumentsResponse getOrListDocuments(GetOrListDocumentsRequest request) throws DatastoreException {
        ListDocumentsRequest listDocumentsRequest = this.converters.toListDocumentsRequest(request);
        if (listDocumentsRequest != null) {
            return this.converters.toGetOrListDocumentsResponse(this.listDocuments(listDocumentsRequest));
        }
        return this.converters.toGetOrListDocumentsResponse(this.getDocument(this.converters.toGetDocumentRequest(request)));
    }

    public Document getDocument(GetDocumentRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).getDocument(context, request);
    }

    public ListDocumentsResponse listDocuments(ListDocumentsRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).listDocuments(context, request);
    }

    public Document createDocument(CreateDocumentRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).createDocument(context, request);
    }

    public Document updateDocument(UpdateDocumentRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).updateDocument(context, request);
    }

    public void deleteDocument(DeleteDocumentRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        this.backendFor(context.databaseRef()).deleteDocument(context, request);
    }

    public ImmutableList<BatchGetDocumentsResponse> batchGetDocuments(BatchGetDocumentsRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).batchGetDocuments(context, request);
    }

    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).beginTransaction(context, request);
    }

    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).commit(context, request);
    }

    public void rollback(RollbackRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        this.backendFor(context.databaseRef()).rollback(context, request);
    }

    public ImmutableList<RunQueryResponse> runQuery(RunQueryRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).runQuery(context, request);
    }

    public CloudFirestoreV1WriteStream writeStream(StreamObserver<WriteResponse> responseObserver) throws DatastoreException {
        FirestoreEmulatorRequestContext context = this.constructRequestContext(null);
        return this.backendFor(context.databaseRef()).writeStream(context, responseObserver);
    }

    public CloudFirestoreV1ListenStream listenStream(StreamObserver<ListenResponse> responseObserver) throws DatastoreException {
        FirestoreEmulatorRequestContext context = this.constructRequestContext(null);
        return this.backendFor(context.databaseRef()).listenStream(context, responseObserver);
    }

    public ListCollectionIdsResponse listCollectionIds(ListCollectionIdsRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).listCollectionIds(context, request);
    }

    public SetSecurityRulesResponse setSecurityRules(SetSecurityRulesRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).setSecurityRules(context, request);
    }

    public void clearData(ClearDataRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        this.backendFor(context.databaseRef()).clearData(context, request);
    }

    public RuleCoverageReport getRuleCoverage(GetRuleCoverageRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).ruleCoverageReport(context, request);
    }

    public CreateTriggerResponse createTrigger(CreateTriggerRequest request) throws DatastoreException {
        DatabaseRef inferredDatabase = this.inferDatabaseRef(request);
        FirestoreEmulatorRequestContext context = this.constructRequestContext(inferredDatabase);
        return this.backendFor(context.databaseRef()).createTrigger(context, request);
    }

    private FirestoreEmulatorRequestContext constructRequestContext(DatabaseRef inferred) throws DatastoreException {
        FirestoreEmulatorRequestContext.Builder builder = FirestoreEmulatorRequestContext.builder().auth(EmulatorAuthorization.fromHeader(FirestoreEmulatorMetadataKeys.AUTHORIZATION.contextKey().get())).requestTime(this.timeSource.now());
        String dbRef = FirestoreEmulatorMetadataKeys.DATABASE_REF.contextKey().get();
        if (dbRef != null) {
            builder.databaseRef(this.converters.toDatabaseRef(dbRef));
        } else {
            Preconditions.checkNotNull(inferred, "could not infer db from headers or from request");
            builder.databaseRef(inferred);
        }
        return builder.build();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(GetDocumentRequest request) throws DatastoreException {
        return this.converters.toEntityRef(request.getName()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(ListDocumentsRequest request) throws DatastoreException {
        return this.converters.parseParent(request.getParent()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(CreateDocumentRequest request) throws DatastoreException {
        return this.converters.toEntityRef(request).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(UpdateDocumentRequest request) throws DatastoreException {
        return this.converters.toEntityRef(request.getDocument().getName()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(DeleteDocumentRequest request) throws DatastoreException {
        return this.converters.toEntityRef(request.getName()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(BatchGetDocumentsRequest request) throws DatastoreException {
        return this.converters.toDatabaseRef(request.getDatabase());
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(BeginTransactionRequest request) throws DatastoreException {
        return this.converters.toDatabaseRef(request.getDatabase());
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(CommitRequest request) throws DatastoreException {
        return this.converters.toDatabaseRef(request.getDatabase());
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(RollbackRequest request) throws DatastoreException {
        return this.converters.toDatabaseRef(request.getDatabase());
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(RunQueryRequest request) throws DatastoreException {
        return this.converters.parseParent(request.getParent()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(ListCollectionIdsRequest request) throws DatastoreException {
        return this.converters.parseParent(request.getParent()).partitionRef().databaseRef();
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(SetSecurityRulesRequest request) throws DatastoreException {
        String projectId = this.extractProjectIdFromProjectName(request.getProject());
        return this.defaultDatabaseRef(projectId);
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(GetRuleCoverageRequest request) throws DatastoreException {
        String projectId = this.extractProjectIdFromProjectName(request.getProject());
        return this.defaultDatabaseRef(projectId);
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(ClearDataRequest request) throws DatastoreException {
        return this.converters.toDatabaseRef(request.getDatabase());
    }

    @VisibleForTesting
    DatabaseRef inferDatabaseRef(CreateTriggerRequest request) throws DatastoreException {
        String projectId = this.extractProjectIdFromTriggerName(request.getName());
        return this.defaultDatabaseRef(projectId);
    }

    private String extractProjectIdFromProjectName(String projectName) {
        String[] parts = projectName.split("/");
        Preconditions.checkArgument(parts.length == 2);
        Preconditions.checkArgument(parts[0].equals("projects"));
        Preconditions.checkArgument(!parts[1].isEmpty());
        return parts[1];
    }

    private String extractProjectIdFromTriggerName(String triggerName) {
        String[] parts = triggerName.split("/");
        Preconditions.checkArgument(parts.length == 4);
        Preconditions.checkArgument(parts[0].equals("projects"));
        Preconditions.checkArgument(!parts[1].isEmpty());
        Preconditions.checkArgument(parts[2].equals("triggers"));
        Preconditions.checkArgument(!parts[3].isEmpty());
        return parts[1];
    }

    private DatabaseRef defaultDatabaseRef(String projectId) {
        return DatabaseRef.createForProject(PARTITION_ID, projectId, "");
    }
}

